package com.demoscene.tv.model

import com.google.gson.annotations.SerializedName

data class Demo(
    @SerializedName("id")
    val id: String,
    
    @SerializedName("name")
    val name: String,
    
    @SerializedName("group")
    val group: String,
    
    @SerializedName("releaseDate")
    val releaseDate: String,
    
    @SerializedName("party")
    val party: String,
    
    @SerializedName("type")
    val type: String,
    
    @SerializedName("platform")
    val platform: String,
    
    @SerializedName("youtubeUrl")
    val youtubeUrl: String?,
    
    @SerializedName("thumbnailUrl")
    val thumbnailUrl: String?,
    
    @SerializedName("rating")
    val rating: Float,
    
    @SerializedName("description")
    val description: String
) {
    fun getYoutubeVideoId(): String? {
        if (youtubeUrl == null) return null
        
        // Extract video ID from various YouTube URL formats
        return when {
            youtubeUrl.contains("youtube.com/watch?v=") -> {
                youtubeUrl.substringAfter("v=").substringBefore("&")
            }
            youtubeUrl.contains("youtu.be/") -> {
                youtubeUrl.substringAfter("youtu.be/").substringBefore("?")
            }
            else -> null
        }
    }
    
    fun getCardImageUrl(): String {
        // Use YouTube thumbnail if available, otherwise placeholder
        return thumbnailUrl ?: 
               getYoutubeVideoId()?.let { "https://img.youtube.com/vi/$it/hqdefault.jpg" } ?: 
               "https://via.placeholder.com/320x180?text=${name.take(20)}"
    }
}

data class DemoCategory(
    val title: String,
    val demos: List<Demo>
)
