package com.demoscene.tv.data

import com.demoscene.tv.model.Demo
import com.demoscene.tv.model.DemoCategory

object DemoDataProvider {
    
    // In a real app, this would fetch from pouet.net API
    // For now, hardcoded demo data with real YouTube links
    fun getCategories(): List<DemoCategory> {
        return listOf(
            DemoCategory(
                title = "Farbrausch Classics",
                demos = listOf(
                    Demo(
                        id = "1221",
                        name = "fr-043: rove",
                        group = "Farbrausch",
                        releaseDate = "2007",
                        party = "Breakpoint 2007",
                        type = "64k intro",
                        platform = "Windows",
                        youtubeUrl = "https://www.youtube.com/watch?v=3Vq5JW-RFvU",
                        thumbnailUrl = null,
                        rating = 4.8f,
                        description = "Legendary 64k intro by Farbrausch. Real-time procedural graphics that pushed hardware limits in 2007."
                    ),
                    Demo(
                        id = "12569",
                        name = "fr-041: debris",
                        group = "Farbrausch",
                        releaseDate = "2007",
                        party = "Breakpoint 2007",
                        type = "64k intro",
                        platform = "Windows",
                        youtubeUrl = "https://www.youtube.com/watch?v=wqu_IpkOYBg",
                        thumbnailUrl = null,
                        rating = 4.9f,
                        description = "Another stunning 64k by Farbrausch. Incredible visuals compressed into just 65536 bytes."
                    ),
                    Demo(
                        id = "63",
                        name = "fr-08: .the .product",
                        group = "Farbrausch",
                        releaseDate = "2000",
                        party = "Mekka & Symposium 2000",
                        type = "64k intro",
                        platform = "Windows",
                        youtubeUrl = "https://www.youtube.com/watch?v=Y3n3c_8Nn2Y",
                        thumbnailUrl = null,
                        rating = 4.7f,
                        description = "Revolutionary 64k intro that changed the demoscene. .werkkzeug1 tool debut."
                    )
                )
            ),
            DemoCategory(
                title = "Top Rated 64k Intros",
                demos = listOf(
                    Demo(
                        id = "62471",
                        name = "Elevated",
                        group = "Rgba & TBC",
                        releaseDate = "2009",
                        party = "Breakpoint 2009",
                        type = "4k intro",
                        platform = "Windows",
                        youtubeUrl = "https://www.youtube.com/watch?v=jB0vBmiTr6o",
                        thumbnailUrl = null,
                        rating = 4.9f,
                        description = "Stunning 4k procedural landscape. One of the best 4k intros ever made."
                    ),
                    Demo(
                        id = "55",
                        name = "Yellow Rose of Texas",
                        group = "Fit & Bandwagon",
                        releaseDate = "1993",
                        party = "Assembly '93",
                        type = "demo",
                        platform = "Amiga",
                        youtubeUrl = "https://www.youtube.com/watch?v=n7aEPeW8bDo",
                        thumbnailUrl = null,
                        rating = 4.6f,
                        description = "Classic Amiga demo showcasing the platform's capabilities."
                    ),
                    Demo(
                        id = "820",
                        name = "Iconoclast",
                        group = "Rgba & Conspiracy",
                        releaseDate = "2010",
                        party = "Revision 2010",
                        type = "64k intro",
                        platform = "Windows",
                        youtubeUrl = "https://www.youtube.com/watch?v=4FHvWYlN2bI",
                        thumbnailUrl = null,
                        rating = 4.8f,
                        description = "Award-winning 64k intro with incredible sync and visuals."
                    )
                )
            ),
            DemoCategory(
                title = "Classic PC Demos",
                demos = listOf(
                    Demo(
                        id = "63",
                        name = "Second Reality",
                        group = "Future Crew",
                        releaseDate = "1993",
                        party = "Assembly '93",
                        type = "demo",
                        platform = "MS-DOS",
                        youtubeUrl = "https://www.youtube.com/watch?v=rFv7mHTf0nA",
                        thumbnailUrl = null,
                        rating = 4.9f,
                        description = "The most legendary PC demo of all time. Defined what demos could be in 1993."
                    ),
                    Demo(
                        id = "22",
                        name = "Unreal",
                        group = "Future Crew",
                        releaseDate = "1992",
                        party = "Assembly '92",
                        type = "demo",
                        platform = "MS-DOS",
                        youtubeUrl = "https://www.youtube.com/watch?v=a3ww0gwEszo",
                        thumbnailUrl = null,
                        rating = 4.7f,
                        description = "Groundbreaking demo featuring voxel landscape rendering."
                    ),
                    Demo(
                        id = "11",
                        name = "Crystal Dream II",
                        group = "Triton",
                        releaseDate = "1993",
                        party = "The Party 1993",
                        type = "demo",
                        platform = "MS-DOS",
                        youtubeUrl = "https://www.youtube.com/watch?v=Z3y4SDPz53c",
                        thumbnailUrl = null,
                        rating = 4.5f,
                        description = "Beautiful demo with smooth animations and great music."
                    )
                )
            ),
            DemoCategory(
                title = "Amiga Classics",
                demos = listOf(
                    Demo(
                        id = "701",
                        name = "Tint",
                        group = "The Black Lotus",
                        releaseDate = "2000",
                        party = "Mekka & Symposium 2000",
                        type = "demo",
                        platform = "Amiga",
                        youtubeUrl = "https://www.youtube.com/watch?v=aRxfU9SgD0E",
                        thumbnailUrl = null,
                        rating = 4.8f,
                        description = "Stunning Amiga demo pushing the hardware to its limits."
                    ),
                    Demo(
                        id = "3741",
                        name = "Origin",
                        group = "Complex",
                        releaseDate = "1994",
                        party = "The Party 1994",
                        type = "demo",
                        platform = "Amiga",
                        youtubeUrl = "https://www.youtube.com/watch?v=iH1f4RMk8W4",
                        thumbnailUrl = null,
                        rating = 4.6f,
                        description = "Classic Complex production with beautiful effects."
                    ),
                    Demo(
                        id = "199",
                        name = "State of the Art",
                        group = "Spaceballs",
                        releaseDate = "1992",
                        party = "The Party 1992",
                        type = "demo",
                        platform = "Amiga",
                        youtubeUrl = "https://www.youtube.com/watch?v=oN9lFuHLJh0",
                        thumbnailUrl = null,
                        rating = 4.7f,
                        description = "Legendary Amiga demo with innovative vector effects."
                    )
                )
            ),
            DemoCategory(
                title = "Modern Masterpieces",
                demos = listOf(
                    Demo(
                        id = "88539",
                        name = "Gaia Machina",
                        group = "Approximate",
                        releaseDate = "2021",
                        party = "Revision 2021",
                        type = "demo",
                        platform = "Windows",
                        youtubeUrl = "https://www.youtube.com/watch?v=M6TP6qJX6YA",
                        thumbnailUrl = null,
                        rating = 4.8f,
                        description = "Modern demo showcasing cutting-edge real-time graphics."
                    ),
                    Demo(
                        id = "85331",
                        name = "Oscar's Chair",
                        group = "Ctrl-Alt-Test",
                        releaseDate = "2020",
                        party = "Revision 2020",
                        type = "64k intro",
                        platform = "Windows",
                        youtubeUrl = "https://www.youtube.com/watch?v=IjA1_gtIjvU",
                        thumbnailUrl = null,
                        rating = 4.9f,
                        description = "Award-winning 64k intro with stunning visuals and storytelling."
                    ),
                    Demo(
                        id = "90084",
                        name = "8 Bits of Wonders",
                        group = "Digitools",
                        releaseDate = "2022",
                        party = "Revision 2022",
                        type = "demo",
                        platform = "Commodore 64",
                        youtubeUrl = "https://www.youtube.com/watch?v=1H5aDqbPjvs",
                        thumbnailUrl = null,
                        rating = 4.7f,
                        description = "Modern C64 demo pushing the vintage hardware in new ways."
                    )
                )
            )
        )
    }
    
    fun getDemoById(id: String): Demo? {
        return getCategories()
            .flatMap { it.demos }
            .find { it.id == id }
    }
}
