package com.demoscene.tv

import android.view.ViewGroup
import androidx.leanback.widget.ImageCardView
import androidx.leanback.widget.Presenter
import androidx.core.content.ContextCompat
import com.bumptech.glide.Glide
import com.demoscene.tv.model.Demo

class CardPresenter : Presenter() {
    
    companion object {
        private const val CARD_WIDTH = 313
        private const val CARD_HEIGHT = 176
    }
    
    override fun onCreateViewHolder(parent: ViewGroup): ViewHolder {
        val cardView = ImageCardView(parent.context).apply {
            isFocusable = true
            isFocusableInTouchMode = true
            setBackgroundColor(ContextCompat.getColor(context, R.color.card_background))
        }
        return ViewHolder(cardView)
    }
    
    override fun onBindViewHolder(viewHolder: ViewHolder, item: Any) {
        val demo = item as Demo
        val cardView = viewHolder.view as ImageCardView
        
        cardView.titleText = demo.name
        cardView.contentText = "${demo.group} • ${demo.releaseDate}"
        cardView.setMainImageDimensions(CARD_WIDTH, CARD_HEIGHT)
        
        // Load thumbnail
        Glide.with(cardView.context)
            .load(demo.getCardImageUrl())
            .centerCrop()
            .error(R.drawable.default_card)
            .into(cardView.mainImageView)
    }
    
    override fun onUnbindViewHolder(viewHolder: ViewHolder) {
        val cardView = viewHolder.view as ImageCardView
        cardView.badgeImage = null
        cardView.mainImage = null
    }
}
