package com.demoscene.tv.model

import android.os.Parcelable
import kotlinx.parcelize.Parcelize

@Parcelize
data class Demo(
    val id: String,
    val title: String,
    val group: String,
    val year: Int,
    val platform: String,
    val type: String,
    val party: String?,
    val rating: Float,
    val youtubeUrl: String,
    val thumbnailUrl: String,
    val pouetUrl: String,
    val description: String,
    // Pouet vote count - positivity only
    val voteUp: Int = 0
) : Parcelable

data class CategoryRow(
    val title: String,
    val demos: List<Demo>
)
