package com.demoscene.tv

import android.content.Intent
import android.os.Bundle
import android.os.Handler
import android.os.Looper
import android.view.KeyEvent
import android.view.MotionEvent
import android.widget.LinearLayout
import android.widget.Toast
import androidx.fragment.app.FragmentActivity
import com.demoscene.tv.ui.MarbleButtonHelper

class MenuActivity : FragmentActivity() {

    private val longPressHandler = Handler(Looper.getMainLooper())
    private var longPressTriggered = false

    // Easter egg - Debris by Farbrausch
    private val easterEggUrl = "https://www.youtube.com/watch?v=k_oTQd93eRI"

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_menu)

        val menuSearch = findViewById<LinearLayout>(R.id.menu_search)
        val menuRefresh = findViewById<LinearLayout>(R.id.menu_refresh)
        val menuAbout = findViewById<LinearLayout>(R.id.menu_about)
        val menuGreets = findViewById<LinearLayout>(R.id.menu_greets)

        MarbleButtonHelper.applyRandomMarble(this, menuSearch)
        MarbleButtonHelper.applyRandomMarble(this, menuRefresh)
        MarbleButtonHelper.applyRandomMarble(this, menuAbout)
        MarbleButtonHelper.applyRandomMarble(this, menuGreets)

        menuSearch.setOnClickListener {
            startActivity(Intent(this, SearchActivity::class.java))
            finish()
        }

        menuRefresh.setOnClickListener {
            Toast.makeText(this, "Refreshing demos...", Toast.LENGTH_SHORT).show()
            val prefs = getSharedPreferences("demoscene_tv", MODE_PRIVATE)
            prefs.edit().putBoolean("refresh_requested", true).apply()

            val intent = Intent(this, HubActivity::class.java)
            intent.flags = Intent.FLAG_ACTIVITY_CLEAR_TOP or Intent.FLAG_ACTIVITY_NEW_TASK
            startActivity(intent)
            finish()
        }

        // About - normal click opens About, long press (10 sec) plays Debris
        menuAbout.setOnClickListener {
            if (!longPressTriggered) {
                startActivity(Intent(this, AboutActivity::class.java))
                finish()
            }
        }

        menuAbout.setOnTouchListener { _, event ->
            when (event.action) {
                MotionEvent.ACTION_DOWN -> {
                    longPressTriggered = false
                    longPressHandler.postDelayed({
                        longPressTriggered = true
                        playEasterEgg()
                    }, 10000) // 10 seconds
                    false
                }
                MotionEvent.ACTION_UP, MotionEvent.ACTION_CANCEL -> {
                    longPressHandler.removeCallbacksAndMessages(null)
                    false
                }
                else -> false
            }
        }

        // Also handle D-pad select held for 10 seconds
        menuAbout.setOnKeyListener { _, keyCode, event ->
            if (keyCode == KeyEvent.KEYCODE_DPAD_CENTER || keyCode == KeyEvent.KEYCODE_ENTER) {
                when (event.action) {
                    KeyEvent.ACTION_DOWN -> {
                        if (event.repeatCount == 0) {
                            longPressTriggered = false
                            longPressHandler.postDelayed({
                                longPressTriggered = true
                                playEasterEgg()
                            }, 10000)
                        }
                        true
                    }
                    KeyEvent.ACTION_UP -> {
                        longPressHandler.removeCallbacksAndMessages(null)
                        if (!longPressTriggered) {
                            startActivity(Intent(this, AboutActivity::class.java))
                            finish()
                        }
                        true
                    }
                    else -> false
                }
            } else {
                false
            }
        }

        menuGreets.setOnClickListener {
            startActivity(Intent(this, GreetsActivity::class.java))
            finish()
        }

        menuSearch.requestFocus()
    }

    private fun playEasterEgg() {
        // Play Debris by Farbrausch
        val intent = Intent(this, PlayerActivity::class.java)
        intent.putExtra("DEMO_YOUTUBE_URL", easterEggUrl)
        startActivity(intent)
        finish()
    }

    override fun onKeyDown(keyCode: Int, event: KeyEvent?): Boolean {
        if (keyCode == KeyEvent.KEYCODE_BACK || keyCode == KeyEvent.KEYCODE_MENU) {
            finish()
            return true
        }
        return super.onKeyDown(keyCode, event)
    }
}
