# Missing Resources & How to Add Them

## ⚠️ What's Missing

The app is **fully functional** but missing these visual assets:

### 1. App Banner (For TV Launcher)
- **Required for**: TV home screen display
- **Without it**: App shows in launcher but with default/ugly icon
- **Impact**: Non-critical, app works fine

### 2. Launcher Icons
- **Required for**: App icon
- **Without it**: Uses default Android robot icon
- **Impact**: Cosmetic only

## ✅ Current Status

The app will **build and run perfectly** without these assets. Android Studio will show warnings but they're safe to ignore for testing.

## 🎨 How to Add App Banner (Optional)

### Quick Way (Use Placeholder)

1. Find any 320x180 image you like (demoscene artwork?)
2. Save as `app_banner.png`
3. Put it here: `app/src/main/res/drawable-xhdpi/app_banner.png`
4. Rebuild app

### Proper Way (Create Custom Banner)

Use any image editor (GIMP, Photoshop, Figma):

**Dimensions**: 320 x 180 pixels
**Format**: PNG with transparency
**Content Ideas**:
- "Demoscene TV" text with demo aesthetic
- Pouet.net logo styled
- Retro CRT scan lines effect
- Farbrausch-inspired graphics

**Where to save**:
```
app/src/main/res/
  ├── drawable-xhdpi/app_banner.png   (320x180)
  ├── drawable-xxhdpi/app_banner.png  (480x270) - optional
  └── drawable-xxxhdpi/app_banner.png (640x360) - optional
```

Just the `xhdpi` version is enough for testing!

### Example Banner Ideas

**Option 1: Simple Text**
- Black background
- Blue/cyan "Demoscene TV" text
- Scanline effect overlay

**Option 2: Pouet-Inspired**
- Use pouet.net colors
- "Powered by pouet.net" subtitle
- Demo thumbnail collage

**Option 3: Retro Aesthetic**
- Amiga Workbench style
- Old-school demoscene font
- Star field background

## 🚀 How to Add Launcher Icons (Optional)

### Super Easy Way - Android Studio Asset Tool

1. **Right-click** `app/src/main/res` folder
2. **New** → **Image Asset**
3. **Icon Type**: Launcher Icons
4. **Asset Type**: 
   - Use a simple logo/image
   - Or use clipart (search "monitor" or "video")
5. **Name**: `ic_launcher`
6. Click **Next** → **Finish**

Done! Android Studio generates all sizes automatically.

### Manual Way (If You Want Custom Icon)

Create these files:

```
app/src/main/res/
  ├── mipmap-mdpi/ic_launcher.png      (48x48)
  ├── mipmap-hdpi/ic_launcher.png      (72x72)
  ├── mipmap-xhdpi/ic_launcher.png     (96x96)
  ├── mipmap-xxhdpi/ic_launcher.png    (144x144)
  └── mipmap-xxxhdpi/ic_launcher.png   (192x192)
```

**Icon Design Ideas**:
- Old CRT TV with demo playing
- Pouet.net "P" logo styled
- Retro computer
- Play button with scanlines

## 🔧 If You Get Build Errors About Missing Resources

Add temporary placeholder:

```bash
# Navigate to project root
cd DemosceneTV

# Create placeholder banner
mkdir -p app/src/main/res/drawable-xhdpi
convert -size 320x180 xc:black -fill white -pointsize 30 \
  -annotate +60+100 'Demoscene TV' \
  app/src/main/res/drawable-xhdpi/app_banner.png

# Or just create any black 320x180 PNG and rename it
```

## 📱 Want to See Examples?

Look at other TV apps for inspiration:
- Netflix (red and white, simple)
- YouTube TV (red play button)
- Plex (orange chevron)

Keep it simple - TV launcher icons should be recognizable from 10 feet away!

## 🎯 Bottom Line

**You don't need these to test the app!**

The app is **100% functional** without custom icons/banners. They're purely cosmetic. 

Add them later if you want to polish it up or distribute it publicly.

For now, just **build → run → enjoy browsing demos** on your TV!

---

**Priority**: 
- 🟢 App functionality: **Complete**
- 🟡 Visual polish: **Optional**
- 🔵 pouet.net API: **Future enhancement**
