package com.demoscene.tv

import android.os.Bundle
import androidx.fragment.app.FragmentActivity

class DetailsActivity : FragmentActivity() {
    
    companion object {
        const val EXTRA_DEMO_ID = "demo_id"
        const val SHARED_ELEMENT_NAME = "demo_card"
    }
    
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_details)
        
        if (savedInstanceState == null) {
            val demoId = intent.getStringExtra(EXTRA_DEMO_ID)
            
            val fragment = DetailsFragment().apply {
                arguments = Bundle().apply {
                    putString(EXTRA_DEMO_ID, demoId)
                }
            }
            
            supportFragmentManager.beginTransaction()
                .replace(R.id.details_fragment, fragment)
                .commit()
        }
    }
}
