package com.demoscene.tv.data

import com.demoscene.tv.model.Demo
import com.demoscene.tv.model.CategoryRow

/**
 * Mock data provider - In production, this would call pouet.net API
 */
object DemoDataProvider {

    fun getCategoryRows(): List<CategoryRow> {
        return listOf(
            CategoryRow("Farbrausch Classics", getFarbrauschDemos()),
            CategoryRow("Top Rated 64k Intros", getTop64kDemos()),
            CategoryRow("Amiga Legends", getAmigaDemos()),
            CategoryRow("Modern PC Demos", getModernDemos()),
            CategoryRow("4k Intros", get4kDemos())
        )
    }

    private fun getFarbrauschDemos(): List<Demo> {
        return listOf(
            Demo(
                id = "1221",
                title = "fr-043: rove",
                group = "Farbrausch",
                year = 2007,
                platform = "Windows",
                type = "64k",
                party = "Breakpoint 2007",
                rating = 4.8f,
                youtubeUrl = "https://www.youtube.com/watch?v=5bJN5dXmtlU",
                thumbnailUrl = "https://content.pouet.net/files/screenshots/00001/00001221.jpg",
                pouetUrl = "https://www.pouet.net/prod.php?which=1221",
                description = "Legendary 64k intro with stunning procedural graphics"
            ),
            Demo(
                id = "30244",
                title = "fr-041: debris",
                group = "Farbrausch",
                year = 2007,
                platform = "Windows",
                type = "64k",
                party = "Breakpoint 2007",
                rating = 4.9f,
                youtubeUrl = "https://www.youtube.com/watch?v=wqu_IpkOYBg",
                thumbnailUrl = "https://content.pouet.net/files/screenshots/00030/00030244.jpg",
                pouetUrl = "https://www.pouet.net/prod.php?which=30244",
                description = "One of the most technically impressive 64k intros ever made"
            ),
            Demo(
                id = "1216",
                title = "fr-08: .the .product",
                group = "Farbrausch",
                year = 2000,
                platform = "Windows",
                type = "64k",
                party = "Mekka & Symposium 2000",
                rating = 4.7f,
                youtubeUrl = "https://www.youtube.com/watch?v=Y3n3c_8Nn2Y",
                thumbnailUrl = "https://content.pouet.net/files/screenshots/00001/00001216.jpg",
                pouetUrl = "https://www.pouet.net/prod.php?which=1216",
                description = "Classic Farbrausch production that defined 64k intros"
            )
        )
    }

    private fun getTop64kDemos(): List<Demo> {
        return listOf(
            Demo(
                id = "55704",
                title = "Elevated",
                group = "RGBA & TBC",
                year = 2009,
                platform = "Windows",
                type = "4k",
                party = "Breakpoint 2009",
                rating = 4.9f,
                youtubeUrl = "https://www.youtube.com/watch?v=jB0vBmiTr6o",
                thumbnailUrl = "https://content.pouet.net/files/screenshots/00055/00055704.jpg",
                pouetUrl = "https://www.pouet.net/prod.php?which=55704",
                description = "Legendary 4k intro with procedural landscapes"
            ),
            Demo(
                id = "68375",
                title = "Fermi Paradox",
                group = "Mercury",
                year = 2016,
                platform = "Windows",
                type = "64k",
                party = "Revision 2016",
                rating = 4.8f,
                youtubeUrl = "https://www.youtube.com/watch?v=4CyhvPF1z20",
                thumbnailUrl = "https://content.pouet.net/files/screenshots/00068/00068375.jpg",
                pouetUrl = "https://www.pouet.net/prod.php?which=68375",
                description = "Beautiful space-themed 64k intro"
            ),
            Demo(
                id = "61592",
                title = "Chaos Theory",
                group = "Conspiracy",
                year = 2006,
                platform = "Windows",
                type = "64k",
                party = "Breakpoint 2006",
                rating = 4.7f,
                youtubeUrl = "https://www.youtube.com/watch?v=ZfuierUvx1A",
                thumbnailUrl = "https://content.pouet.net/files/screenshots/00061/00061592.jpg",
                pouetUrl = "https://www.pouet.net/prod.php?which=61592",
                description = "Classic 64k with amazing visuals and soundtrack"
            )
        )
    }

    private fun getAmigaDemos(): List<Demo> {
        return listOf(
            Demo(
                id = "4115",
                title = "State of the Art",
                group = "Spaceballs",
                year = 1992,
                platform = "Amiga OCS/ECS",
                type = "Demo",
                party = "The Party 1992",
                rating = 4.9f,
                youtubeUrl = "https://www.youtube.com/watch?v=EKiL3pOTPiA",
                thumbnailUrl = "https://content.pouet.net/files/screenshots/00004/00004115.jpg",
                pouetUrl = "https://www.pouet.net/prod.php?which=4115",
                description = "Legendary Amiga demo that defined the era"
            ),
            Demo(
                id = "717",
                title = "9 Fingers",
                group = "Spaceballs",
                year = 1993,
                platform = "Amiga OCS/ECS",
                type = "Demo",
                party = "The Gathering 1993",
                rating = 4.7f,
                youtubeUrl = "https://www.youtube.com/watch?v=kfEoGS5cHEk",
                thumbnailUrl = "https://content.pouet.net/files/screenshots/00000/00000717.jpg",
                pouetUrl = "https://www.pouet.net/prod.php?which=717",
                description = "Classic Amiga demo with amazing effects"
            )
        )
    }

    private fun getModernDemos(): List<Demo> {
        return listOf(
            Demo(
                id = "85227",
                title = "SEQUENCE",
                group = "Still",
                year = 2020,
                platform = "Windows",
                type = "Demo",
                party = "Revision 2020",
                rating = 4.8f,
                youtubeUrl = "https://www.youtube.com/watch?v=D3iCGp7AD0g",
                thumbnailUrl = "https://content.pouet.net/files/screenshots/00085/00085227.jpg",
                pouetUrl = "https://www.pouet.net/prod.php?which=85227",
                description = "Modern demo with stunning real-time graphics"
            ),
            Demo(
                id = "91465",
                title = "Offscreen Colonies",
                group = "Logicoma",
                year = 2022,
                platform = "Windows",
                type = "Demo",
                party = "Revision 2022",
                rating = 4.7f,
                youtubeUrl = "https://www.youtube.com/watch?v=TpIG6fwOHNI",
                thumbnailUrl = "https://content.pouet.net/files/screenshots/00091/00091465.jpg",
                pouetUrl = "https://www.pouet.net/prod.php?which=91465",
                description = "Award-winning modern demo"
            )
        )
    }

    private fun get4kDemos(): List<Demo> {
        return listOf(
            Demo(
                id = "55704",
                title = "Elevated",
                group = "RGBA & TBC",
                year = 2009,
                platform = "Windows",
                type = "4k",
                party = "Breakpoint 2009",
                rating = 4.9f,
                youtubeUrl = "https://www.youtube.com/watch?v=jB0vBmiTr6o",
                thumbnailUrl = "https://content.pouet.net/files/screenshots/00055/00055704.jpg",
                pouetUrl = "https://www.pouet.net/prod.php?which=55704",
                description = "Mind-blowing 4k intro"
            ),
            Demo(
                id = "83222",
                title = "Bronx",
                group = "Alcatraz",
                year = 2019,
                platform = "Windows",
                type = "4k",
                party = "Revision 2019",
                rating = 4.6f,
                youtubeUrl = "https://www.youtube.com/watch?v=jPrQnj5cQsE",
                thumbnailUrl = "https://content.pouet.net/files/screenshots/00083/00083222.jpg",
                pouetUrl = "https://www.pouet.net/prod.php?which=83222",
                description = "Beautiful 4k intro with procedural city"
            )
        )
    }
}
