package com.demoscene.tv.model

/**
 * Represents a demoscene production from pouet.net
 */
data class Demo(
    val id: String,
    val title: String,
    val group: String,
    val year: Int,
    val platform: String,
    val type: String, // 64k, 4k, demo, musicdisk, etc.
    val party: String?,
    val rating: Float, // 0.0 to 5.0
    val youtubeUrl: String?,
    val thumbnailUrl: String,
    val pouetUrl: String,
    val description: String = ""
)

/**
 * Category row for the TV interface
 */
data class CategoryRow(
    val title: String,
    val demos: List<Demo>
)
