
Object Torus, Torus2;

#define RAD1 64
#define TORN 12

#define TR1 40

float TX0, TY0, TZ0, TDX, TDY, TDZ, TCDist,
  XAdd[8] = { -1.2f, -0.8f, 0.8f, 1.2f, 1.2f, 0.8f, -0.8f, -1.2f },
  YAdd[8] = { -0.6f, -1.0f, -1.0f, -0.6f, 0.6f, 1.0f, 1.0f, 0.6f };

void Torus_Init( void )
  {
    int T, I, J;

    Torus.NumVects = TORN*RAD1*8;
    if (( Torus.Vects = (Vect*) malloc( Torus.NumVects * sizeof( Vect ))) == NULL )
      PostQuitMessage( 0 );
    Torus.NumFaces = TORN*RAD1*8;
    if (( Torus.Faces = (Face*) malloc( Torus.NumFaces * sizeof( Face ))) == NULL )
      PostQuitMessage( 0 );

    Torus2.NumVects = TORN*RAD1*8;
    if (( Torus2.Vects = (Vect*) malloc( Torus2.NumVects * sizeof( Vect ))) == NULL )
      PostQuitMessage( 0 );

    for ( T = 0; T < TORN; T++ )
      for ( I = 0; I < RAD1; I++ )
        for ( J = 0; J < 8; J++ )
          {
            TZ0 = (float) YAdd[J];
            TX0 = (float) (( T+1 ) * TR1 / 10.0f + Fsin( I*6*Pi / RAD1 ) + XAdd[J] ) * Fsin( I*2*Pi / RAD1 );
            TY0 = (float) (( T+1 ) * TR1 / 10.0f + Fsin( I*6*Pi / RAD1 ) + XAdd[J] ) * Fcos( I*2*Pi / RAD1 );
            Vertex( &(Torus2.Vects[ T*RAD1*8 + I*8 + J ]), TX0, TY0, TZ0 );
           }

    F = 0;
    for ( T = 0; T < TORN; T++ )
      for ( I = 0; I < RAD1; I++ )
        for ( J = 0; J < 8; J++ )
          {
            Torus.Faces[ T*RAD1*8 + I*8 + J ].Type = 4;
            Torus.Faces[ T*RAD1*8 + I*8 + J ].A = T*RAD1*8 + I*8 + J;
            Torus.Faces[ T*RAD1*8 + I*8 + J ].B = T*RAD1*8 + ((I+1)&(RAD1-1))*8 + J;
            Torus.Faces[ T*RAD1*8 + I*8 + J ].C = T*RAD1*8 + ((I+1)&(RAD1-1))*8 + ((J+1)&7);
            Torus.Faces[ T*RAD1*8 + I*8 + J ].D = T*RAD1*8 + I*8 + ((J+1)&7);
            Torus.Faces[ T*RAD1*8 + I*8 + J ].pA = &Torus.Vects[ T*RAD1*8 + I*8 + J ];
            Torus.Faces[ T*RAD1*8 + I*8 + J ].pB = &Torus.Vects[ T*RAD1*8 + ((I+1)&(RAD1-1))*8 + J ];
            Torus.Faces[ T*RAD1*8 + I*8 + J ].pC = &Torus.Vects[ T*RAD1*8 + ((I+1)&(RAD1-1))*8 + ((J+1)&7) ];
            Torus.Faces[ T*RAD1*8 + I*8 + J ].pD = &Torus.Vects[ T*RAD1*8 + I*8 + ((J+1)&7) ];
            Torus.Faces[ T*RAD1*8 + I*8 + J ].ColR = 0.125f * ( 1.0f + 0.2f * Fsin( J*Pi/4 + 0.13f ));
            Torus.Faces[ T*RAD1*8 + I*8 + J ].ColG = 0.353f * ( 1.0f + 0.2f * Fsin( J*Pi/4 + 0.13f ));
            Torus.Faces[ T*RAD1*8 + I*8 + J ].ColB = 0.361f * ( 1.0f + 0.2f * Fsin( J*Pi/4 + 0.13f ));
            Torus.Faces[ T*RAD1*8 + I*8 + J ].ColA = 1.0f;
           }
   }

float RotX, RotY, RotZ, SinX, SinY, SinZ, CosX, CosY, CosZ, Mat[3][3];

void Torus_Draw( float Timer )
  {
    int T, I, J;

    V = 0;
    for ( T = 0; T < TORN; T++ )
      {
        RotX = ( Timer - T*32 ) * 0.0023f;   SinX = Fsin( RotX );  CosX = Fcos( RotX );
        RotY = ( Timer - T*32 ) * 0.0031f;   SinY = Fsin( RotY );  CosY = Fcos( RotY );
        RotZ = ( Timer - T*32 ) * 0.0041f;   SinZ = Fsin( RotZ );  CosZ = Fcos( RotZ );

        Mat[0][0] =  SinX * SinY * SinZ + CosX * CosZ;
        Mat[0][1] =  CosY * SinZ;
        Mat[0][2] =  SinX * CosZ - CosX * SinY * SinZ;
        Mat[1][0] =  SinX * SinY * CosZ - CosX * SinZ;
        Mat[1][1] =  CosY * CosZ;
        Mat[1][2] = -CosX * SinY * CosZ - SinX * SinZ;
        Mat[2][0] = -SinX * CosY;
        Mat[2][1] =  SinY;
        Mat[2][2] =  CosX * CosY;

        for ( I = 0; I < RAD1; I++ )
          for ( J = 0; J < 8; J++ )
            {
              Torus.Vects[ V ].X = Mat[0][0] * Torus2.Vects[ V ].X + Mat[0][1] * Torus2.Vects[ V ].Y + Mat[0][2] * Torus2.Vects[ V ].Z;
              Torus.Vects[ V ].Y = Mat[1][0] * Torus2.Vects[ V ].X + Mat[1][1] * Torus2.Vects[ V ].Y + Mat[1][2] * Torus2.Vects[ V ].Z;
              Torus.Vects[ V ].Z = Mat[2][0] * Torus2.Vects[ V ].X + Mat[2][1] * Torus2.Vects[ V ].Y + Mat[2][2] * Torus2.Vects[ V ].Z;
              V++;
             }
       }

    Camp.X = 27.5f;
    Camp.Y = 16.0f;
    Camp.Z = 10.5f;

    for ( T = 0; T < TORN; T++ )
      for ( I = 0; I < RAD1; I++ )
        for ( J = 0; J < 8; J++ )
          {
              TDX = Torus.Faces[ T*RAD1*8 + I*8 + J ].pA->X - Camp.X;
              TDY = Torus.Faces[ T*RAD1*8 + I*8 + J ].pA->Y - Camp.Y;
              TDZ = Torus.Faces[ T*RAD1*8 + I*8 + J ].pA->Z - Camp.Z;
              TCDist = Fsqrt( TDX*TDX + TDY*TDY + TDZ*TDZ ) * 0.023f;
              if ( TCDist > 1.0f ) TCDist = 1.0f;
            Torus.Faces[ T*RAD1*8 + I*8 + J ].Shade = 1.0f - TCDist;
           }

    glMatrixMode( GL_PROJECTION );
    glLoadIdentity();
    gluPerspective( 90.0f, 640.0f / 360.0f, 0.01f, 10.0f ); 
    glScalef( 0.2f, 0.2f, 0.2f );

    gluLookAt( Camp.X, Camp.Y, Camp.Z, 1.0f*Fsin( Timer*0.005f ), 1.0f*Fcos( Timer*0.0037f ), 2.0f*Fsin( Timer*0.0031f ), 0.0f, Fsin( Timer*0.0003f), Fcos( Timer*0.0003f ));
    glMatrixMode( GL_MODELVIEW );
    glLoadIdentity();

    DrawObject( &Torus, 0.0f, 0.0f, 0.0f );
   }
