
// --- Morph.
//  Copyright (c) 2000. Remage / Fresh!mindworkz.

Object Morph;

#define M1 64
#define M2 64
#define MR1 18.0f
#define MR2 12.0f

float MX0, MY0, MZ0, MDX, MDY, MDZ, MCDist, MT1, MT2, MR3, MR4;

void Morph_Init( void )
  {
    int I, J;

    Morph.NumVects = M1*M2;
    if (( Morph.Vects = (Vect*) malloc( Morph.NumVects * sizeof( Vect ))) == NULL )
      PostQuitMessage( 0 );
    Morph.NumFaces = M1*M2;
    if (( Morph.Faces = (Face*) malloc( Morph.NumFaces * sizeof( Face ))) == NULL )
      PostQuitMessage( 0 );
    
    F = 0;
    for ( I = 0; I < M1; I++ )
      for ( J = 0; J < M2; J++ )
        {
          Morph.Faces[ F ].Type = 4;
          Morph.Faces[ F ].A = I*M2+J;
          Morph.Faces[ F ].B = ((I+1)&(M1-1))*M2+J;
          Morph.Faces[ F ].C = ((I+1)&(M1-1))*M2+((J+1)&(M2-1));
          Morph.Faces[ F ].D = I*M2+((J+1)&(M2-1));
          Morph.Faces[ F ].pA = &Morph.Vects[ I*M2+J ];
          Morph.Faces[ F ].pB = &Morph.Vects[ ((I+1)&(M1-1))*M2+J ];
          Morph.Faces[ F ].pC = &Morph.Vects[ ((I+1)&(M1-1))*M2+((J+1)&(M2-1)) ];
          Morph.Faces[ F ].pD = &Morph.Vects[ I*M2+((J+1)&(M2-1)) ];
          Morph.Faces[ F ].ColR = 0.5f;
          Morph.Faces[ F ].ColG = 0.5f;
          Morph.Faces[ F ].ColB = 0.5f;
          Morph.Faces[ F++ ].ColA = 0.5f;
         }
   }

void Morph_Draw( float Timer )
  {
    int I, J;
    
    MT1 = Timer / 2048.0f;
    MT2 = 0.3f * Fsin( MT1*Pi ) * MT1;
    MT1 = 0.3f * Fsin( MT1*Pi ) * ( 1.0f - MT1 );

    V = 0;
    for ( I = 0; I < M1; I++ )
      for ( J = 0; J < M2; J++ )
        {
/*
          MR3 = MR1 * ( 1.0f + MT1 * Fsin( I*10*Pi / M1 - Timer * 0.0125f ));
          MR4 = MR2 * ( 1.0f + MT2 * Fsin( J*6*Pi / M1 + Timer * 0.0131f ));
          X0 = MR3 * Fsin( J*Pi / M2 ) * Fsin( I*2*Pi / M1 );
          Y0 = MR3 * Fsin( J*Pi / M2 ) * Fcos( I*2*Pi / M1 );
          Z0 = MR4 * Fcos( J*Pi / M2 );
*/
          MR3 = 
            ( 1.0f + MT1 * Fcos( J*6*Pi / M2 - Timer*0.0025f )) * ( 1.0f + MT2 * Fcos( I*10*Pi / M1 + Timer*0.0131f )) * 
            ( 1.0f + MT2 * Fcos( J*4*Pi / M2 + Timer*0.0072f )) * ( 1.0f + MT1 * Fcos( I*8*Pi / M1 - Timer*0.0163f ));

          X0 = MR3 * MR1 * Fsin( J*Pi / M2 ) * Fsin( I*2*Pi / M1 );
          Y0 = MR3 * MR1 * Fsin( J*Pi / M2 ) * Fcos( I*2*Pi / M1 );
          Z0 = MR3 * MR2 * Fcos( J*Pi / M2 );

          Vertex( &Morph.Vects[ I*M2 + J ], X0, Y0, Z0 );
         }

    Camp.X = 27.5f;
    Camp.Y = 16.0f;
    Camp.Z = 10.5f;

    for ( I = 0; I < M1; I++ )
      for ( J = 0; J < M2; J++ )
        {
          MDX = Morph.Faces[ I*M2 + J ].pA->X - Camp.X;
          MDY = Morph.Faces[ I*M2 + J ].pA->Y - Camp.Y;
          MDZ = Morph.Faces[ I*M2 + J ].pA->Z - Camp.Z;
          MCDist = Fsqrt( MDX*MDX + MDY*MDY + MDZ*MDZ ) * 0.023f;
          if ( MCDist > 1.0f ) MCDist = 1.0f;
          Morph.Faces[ I*M2 + J ].Shade = 1.0f - MCDist;
         }

    glMatrixMode( GL_PROJECTION );
    glLoadIdentity();
    gluPerspective( 90.0f, 640.0f / 360.0f, 0.01f, 10.0f ); 
    glScalef( 0.2f, 0.2f, 0.2f );

    gluLookAt( Camp.X, Camp.Y, Camp.Z, 1.0f*Fsin( Timer*0.005f ), 1.0f*Fcos( Timer*0.0037f ), 2.0f*Fsin( Timer*0.0031f ), 0.0f, Fsin( Timer*0.0003f), Fcos( Timer*0.0003f ));
    glMatrixMode( GL_MODELVIEW );
    glLoadIdentity();

    DrawObject( &Morph, 0.0f, 0.0f, 0.0f );
   }