
// --- Single - 64k Intro.
//  Copyright (c) 2000. Remage / Fresh!mindworkz.

#define SYNC 2048

/*
 Everything But The Girl - Single.

I called you from the hotel phone. I haven't dialed this code before.
I'm sleeping later, waking later, I'm eating less and thinking more.
And how am I without you? Am I more myself or less myself?
I feel younger, louder. Like I don't always connect.
Like I don't ever connect.

Do you like being single? Do you want me back, do you want me back?
Do I like being single? Am I coming back, am I coming back?
Do you want me back?

I'll put my suitcase here for now, I'll turn the TV to the bed,
but if no-one calls and I don't speak all day, do I disappear?
Look at me without you, I'm quite proud of myself,
I feel reckless, clumsy. Like I'm making a mistake,
a really big mistake.

Do you like being single? Do you want me back, do you want me back?
Do I like being single? Am I coming back, am I coming back?
Do you want me back?

Now I know, each time I go, I don't really know, what I think I know.
Do you want me back, do you want me back?
*/

#include <Windows.h>
#include <StdIO.h>

#include <GL\GL.h>
#include <GL\GLu.h>

#include "Single.h"

#define RESX 640
#define BITS 16
#define FULLSCREEN

#define MXMPLAY

#include "Chip.i"
#include "Indexed.i"

// ---------- Math.

#pragma warning( push )
#pragma warning( disable : 4035 )

float __cdecl Fabs( float value )
  { __asm {
        fld [value]
        fabs
        }
   }

float __cdecl Fsqrt( float value )
  { __asm {
        fld [value]
        fsqrt
        }
   }

float __cdecl Fsin( float value )
  { __asm {
        fld [value]
        fsin
        }
   }

float __cdecl Fcos( float value )
  { __asm {
        fld [value]
        fcos
        }
   }

float __cdecl Frac( float value )
  { int tmp;
     float float05 = 0.5f;
     _asm {
        fld [value]
        fld [value]
        fsub [float05]
        fistp [tmp]
        fild [tmp]
        fsubp st(1), st(0)
        }
   }

#ifdef NDEBUG

void* __cdecl malloc( size_t siz )
  { return (void*) HeapAlloc( GetProcessHeap(), HEAP_ZERO_MEMORY, siz );
   }

#endif

float Fsqr( float value )
  { return value*value;
   }

int Trunc( float value )
  { 
    float float05 = 0.5f;
    int tmp;
    __asm {
      fld [value]
      fsub [float05]
      fistp [tmp]
      }
    return tmp;
   }

int Round( float Value )
  {
    int Tmp;
    __asm {
      fld [Value]
      fistp [Tmp]
      }
    return Tmp;
  }

#pragma warning( pop )

// ---------- MxmPlay.

#ifdef MXMPLAY
extern "C" unsigned long __stdcall ds_init( HWND hWnd, void *Mxm );
extern "C" void __stdcall ds_close( void );
extern "C" void __stdcall xmpPlay( void );
// extern "C" char __stdcall xmpGetSync( void );
// extern "C" void __stdcall xmpStop( void );
#endif

// ---------- WinMainCRTStartup().

void WinMainCRTStartup( void )
  { ExitProcess( (UINT) WinMain( GetModuleHandleA( NULL ), NULL, NULL, SW_SHOW ));
   }

// ---------- Globals.

const float Pi = 3.1415926536f, Pi2 = 2.0f * Pi;
char SyncVal;

HDC hDC;
HGLRC hRC;

int PixelFmt;
const PIXELFORMATDESCRIPTOR PixelFmtDesc = 
  { sizeof( PIXELFORMATDESCRIPTOR ), 1, PFD_DRAW_TO_WINDOW | PFD_SUPPORT_OPENGL | PFD_DOUBLEBUFFER, 
     PFD_TYPE_RGBA, BITS, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, BITS, 0, 0, PFD_MAIN_PLANE, 0, 0, 0, 0 
   };

HWND hWnd;
MSG Msg;

DEVMODE DevMode;
RECT Rect;

BOOL DoTimer = TRUE;
DWORD TInit, TCurr;
float Timer;
int Frame = 0;

GLuint Texture[2];
unsigned char *Indexed2;

void *xmdat;

// ---------- WndProc().

LRESULT __stdcall WndProc( HWND hWnd, UINT Msg, WPARAM wParam, LPARAM lParam )
  { 
     switch ( Msg )
       { case WM_CREATE:
            if ( ! (hDC = GetDC( hWnd ))) 
              { 
#ifdef _DEBUG
                 char ErrStr[16];
                 sprintf( ErrStr, "Err[%d]:", (DWORD) GetLastError());
                 MessageBox( 0, "Failed: GetDC();", ErrStr, MB_ICONERROR | MB_OK );
#endif
                 PostQuitMessage( 0 );
                 return 0;
               }
            if ( ! (PixelFmt = ChoosePixelFormat( hDC, &PixelFmtDesc )))
              { 
#ifdef _DEBUG
                 char ErrStr[16];
                 sprintf( ErrStr, "Err[%d]:", (DWORD) GetLastError());
                 MessageBox( 0, "Failed: ChoosePixelFormat();", ErrStr, MB_ICONERROR | MB_OK );
#endif
                 PostQuitMessage( 0 );
                 return 0;
               }
            if ( !SetPixelFormat( hDC, PixelFmt, &PixelFmtDesc ))
              { 
#ifdef _DEBUG
                 char ErrStr[16];
                 sprintf( ErrStr, "Err[%d]:", (DWORD) GetLastError());
                 MessageBox( 0, "Failed: SetPixelFormat();", ErrStr, MB_ICONERROR | MB_OK );
#endif
                 PostQuitMessage( 0 );
                 return 0;
               }

            if ( ! (hRC = wglCreateContext( hDC )))
              { 
#ifdef _DEBUG
                 char ErrStr[16];
                 sprintf( ErrStr, "Err[%d]:", (DWORD) GetLastError());
                 MessageBox( 0, "Failed: wglCreateContext();", ErrStr, MB_ICONERROR | MB_OK );
#endif
                 PostQuitMessage( 0 );
                 return 0;
               }
            if ( ! wglMakeCurrent( hDC, hRC ))
              { 
#ifdef _DEBUG
                 char ErrStr[16];
                 sprintf( ErrStr, "Err[%d]:", (DWORD) GetLastError());
                 MessageBox( 0, "Failed: wglMakeCurrent();", ErrStr, MB_ICONERROR | MB_OK );
#endif
                 PostQuitMessage( 0 );
                 return 0;
               }
            GetClientRect( hWnd, &Rect );
#ifdef MXMPLAY
            ds_init( hWnd, Includer );
            __asm
              { pushad
                 xor eax,eax
                 call xmpPlay
                 popad
               }
#endif
            TInit = timeGetTime();
            break;
         case WM_CLOSE:
         case WM_DESTROY:
#ifdef MXMPLAY
            ds_close();
#endif
            ChangeDisplaySettings( NULL, 0 );
            wglMakeCurrent( hDC, 0 );
            wglDeleteContext( hRC );
            ReleaseDC( hWnd, hDC );
            PostQuitMessage( 0 );
            break;
#ifdef _DEBUG
    		 case WM_CHAR:
		        if ( wParam == ' ' )
              DoTimer = !DoTimer;
            break;
#endif
         case WM_KEYDOWN:
            if ( wParam == VK_ESCAPE )
              SendMessage( hWnd, WM_CLOSE, 0, 0 );
         default: 
            return DefWindowProc( hWnd, Msg, wParam, lParam );
       }
     return 0;
   }

// ==========================================================================
//    OpenGL Code.
// ==========================================================================

void Vertex( Vect* Out, float X, float Y, float Z )
  { Out->X = X;
     Out->Y = Y;
     Out->Z = Z;
   }

float GlobalShade = 1.0f;

void DrawObject( Object *Obj, float tx, float ty, float tz )
  {
     for ( int i = 0; i < Obj->NumFaces; i++ )
       {
          switch ( Obj->Faces[ i ].Type )
            { case 4: 
                 glColor4f( 
                   BackR + (Obj->Faces[ i ].ColR-BackR) * Obj->Faces[ i ].Shade * GlobalShade, 
                   BackG + (Obj->Faces[ i ].ColG-BackG) * Obj->Faces[ i ].Shade * GlobalShade,
                   BackB + (Obj->Faces[ i ].ColB-BackB) * Obj->Faces[ i ].Shade * GlobalShade, Obj->Faces[ i ].ColA );
                 glBegin( GL_QUADS ); 
                 glVertex3f( Obj->Faces[ i ].pA->X + tx, Obj->Faces[ i ].pA->Y + ty, Obj->Faces[ i ].pA->Z + tz );
                 glVertex3f( Obj->Faces[ i ].pB->X + tx, Obj->Faces[ i ].pB->Y + ty, Obj->Faces[ i ].pB->Z + tz );
                 glVertex3f( Obj->Faces[ i ].pC->X + tx, Obj->Faces[ i ].pC->Y + ty, Obj->Faces[ i ].pC->Z + tz );
                 glVertex3f( Obj->Faces[ i ].pD->X + tx, Obj->Faces[ i ].pD->Y + ty, Obj->Faces[ i ].pD->Z + tz );
                 glEnd();
                 break;
               case 3:
                 glColor4f( 
                   BackR + (Obj->Faces[ i ].ColR-BackR) * Obj->Faces[ i ].Shade * GlobalShade, 
                   BackG + (Obj->Faces[ i ].ColG-BackG) * Obj->Faces[ i ].Shade * GlobalShade,
                   BackB + (Obj->Faces[ i ].ColB-BackB) * Obj->Faces[ i ].Shade * GlobalShade, Obj->Faces[ i ].ColA );
                 glBegin( GL_TRIANGLES );
                 glVertex3f( Obj->Faces[ i ].pA->X + tx, Obj->Faces[ i ].pA->Y + ty, Obj->Faces[ i ].pA->Z + tz );
                 glVertex3f( Obj->Faces[ i ].pB->X + tx, Obj->Faces[ i ].pB->Y + ty, Obj->Faces[ i ].pB->Z + tz );
                 glVertex3f( Obj->Faces[ i ].pC->X + tx, Obj->Faces[ i ].pC->Y + ty, Obj->Faces[ i ].pC->Z + tz );
                 glEnd();
                 break;
               case 2: 
        				 glDisable( GL_DEPTH_TEST );
			           glBlendFunc( GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA );
				         glEnable( GL_BLEND );
				         glLineWidth( 1.0f );
      			     glEnable( GL_LINE_SMOOTH );
			        	 glColor4f( 
                   BackR + (Obj->Faces[ i ].ColR-BackR) * Obj->Faces[ i ].Shade * GlobalShade, 
                   BackG + (Obj->Faces[ i ].ColG-BackG) * Obj->Faces[ i ].Shade * GlobalShade,
                   BackB + (Obj->Faces[ i ].ColB-BackB) * Obj->Faces[ i ].Shade * GlobalShade, Obj->Faces[ i ].ColA );
                 glBegin( GL_LINES );
                 glVertex3f( Obj->Faces[ i ].pA->X + tx, Obj->Faces[ i ].pA->Y + ty, Obj->Faces[ i ].pA->Z + tz );
                 glVertex3f( Obj->Faces[ i ].pB->X + tx, Obj->Faces[ i ].pB->Y + ty, Obj->Faces[ i ].pB->Z + tz );
				         glEnd();
    		         // glDisable( GL_BLEND );
                 glEnable( GL_DEPTH_TEST );
                 break;
             }
        }
   }

// Camera Position.
Vect Camp;

#include "Blob.cpp"
#include "Rings.cpp"
#include "Hexatun.cpp"
#include "Quads.cpp"
#include "Fonts.cpp"
#include "Torus.cpp"
#include "Knot.cpp"
#include "HexFloor.cpp"
#include "Ringt.cpp"
#include "Morph.cpp"

// ---------- WinMain().

WNDCLASS WndClass =
  { CS_VREDRAW | CS_HREDRAW | CS_OWNDC, (WNDPROC) &WndProc, 0, 0, NULL, NULL, NULL, NULL, NULL, "Fresh"
   };

int __stdcall WinMain( HINSTANCE hInst, HINSTANCE hPrev, LPSTR lpCmdLine, int nShow )
  { 
    WndClass.hInstance = hInst;
    if ( !RegisterClass( &WndClass ))
      { 
#ifdef _DEBUG
        char ErrStr[16];
        sprintf( ErrStr, "Err[%d]:", (DWORD) GetLastError());
        MessageBox( 0, "Failed: RegisterClass();", ErrStr, MB_ICONERROR | MB_OK );
#endif
        return 0;
       }

    hWnd = CreateWindow( "Fresh", "Fresh!mindworkz", WS_POPUP, 0, 0, RESX, RESX*3/4, 0, 0, hInst, NULL );
    if ( !hWnd )
      { 
#ifdef _DEBUG
        char ErrStr[16];
        sprintf( ErrStr, "Err[%d]:", (DWORD) GetLastError());
        MessageBox( 0, "Failed: CreateWindow();", ErrStr, MB_ICONERROR | MB_OK );
#endif
        return 0;
       }

#ifdef FULLSCREEN     
    DevMode.dmSize = sizeof( DEVMODE );
    DevMode.dmFields = DM_PELSWIDTH | DM_PELSHEIGHT;
    DevMode.dmPelsWidth = RESX;
    DevMode.dmPelsHeight = RESX*3/4;
    ChangeDisplaySettings( &DevMode, CDS_FULLSCREEN );
#endif

    ShowCursor( FALSE );
    ShowWindow( hWnd, SW_SHOW );
    UpdateWindow( hWnd );
    SetFocus( hWnd );

    wglMakeCurrent( hDC, hRC );

    if (( Indexed2 = (unsigned char*) malloc( 256*256*4 )) == NULL )
      PostQuitMessage( 0 );

    for ( int I = 0; I < 256*256*4; I++ )
      Indexed2[ I ] = 255;

    for ( int J = 0; J < 89; J++ )
      for ( I = 0; I < 255; I++ )
        {
          Indexed2[ J*256*4 + I*4 + 0 ] = Indexed[ 5 + 3*Indexed[773+J*256+I]];
          Indexed2[ J*256*4 + I*4 + 1 ] = Indexed[ 6 + 3*Indexed[773+J*256+I]];
          Indexed2[ J*256*4 + I*4 + 2 ] = Indexed[ 7 + 3*Indexed[773+J*256+I]];
          if (( Indexed2[ J*256*4 + I*4 + 0 ]+Indexed2[ J*256*4 + I*4 + 1 ]+Indexed2[ J*256*4 + I*4 + 2 ] > 600 ) && 
            ( I < 85 ))
            Indexed2[ J*256*4 + I*4 + 3 ] = 0; else
            Indexed2[ J*256*4 + I*4 + 3 ] = 255;
         }

    glGenTextures( 2, &Texture[0] );

    glBindTexture( GL_TEXTURE_2D, Texture[0] );
    glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR );
    glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR );
    glTexImage2D( GL_TEXTURE_2D, 0, 4, 256, 256, 0, GL_RGBA, GL_UNSIGNED_BYTE, Indexed2 );

    glBindTexture( GL_TEXTURE_2D, Texture[1] );
    glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR );
    glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR );
    glTexImage2D( GL_TEXTURE_2D, 0, 4, 128, 128, 0, GL_ALPHA, GL_UNSIGNED_BYTE, Fontset );

    Blob_Init();
    Knot_Init();
    Rings_Init();
    Noise_Init();
    HexFl_Init();
    HexaTun_Init();
    Quads_Init();
    Torus_Init();
    Ringt_Init();
    Morph_Init();

// ---
// ---

#ifdef _DEBUG    
    float Fps = 0;
#endif

    // TInit = timeGetTime();

    while ( TRUE ) 
      {
        // --- MessageLoop. 
        while ( PeekMessage( &Msg, 0, 0, 0, PM_NOREMOVE ))
          { 
            if ( !GetMessage( &Msg, 0, 0, 0 )) return 0;
            TranslateMessage( &Msg );
            DispatchMessage( &Msg );
           }
          // --- Timer.
/*
          __asm
            { pushad
               call xmpGetSync
               mov [SyncVal], al
               popad
               }
          if ( !SyncVal )
            TInit = timeGetTime();
*/
          TCurr = timeGetTime();
          if ( DoTimer ) Timer += (float) ( TCurr - TInit ) * 0.1f;
#ifdef _DEBUG
          if ( Frame )
            Fps = 0.9f * Fps + 100.0f / (float) ( TCurr - TInit );
#endif
          TInit = TCurr;

          // --- MainCode.
          
          glClearColor( 0.0f, 0.0f, 0.0f, 0.0f );
          glClear( GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT );

          glViewport( 0, 0, 640, 480 );

          glMatrixMode( GL_PROJECTION );
          glLoadIdentity();
          gluOrtho2D( 0, 640, 480, 0 );
          glMatrixMode( GL_MODELVIEW );
          glLoadIdentity();

          glDisable( GL_BLEND );
          glDisable( GL_DEPTH_TEST );
          glColor3f( BackR, BackG, BackB );
          glRectf( 0.0f, 60.0f, 640.0f, 420.0f );

          glEnable( GL_DEPTH_TEST );
          glViewport( 0, 60, 640, 360 );

          // --- Part1.
          if ( Timer > 128 )
          if ( Timer < 128+SYNC )
            { 
              if ( Timer < 128+256 ) GlobalShade = ( Timer-128 ) / 256.0f; else
              if ( Timer > 128+SYNC-256 ) GlobalShade = ( 128+SYNC-Timer ) / 256.0f; else
                GlobalShade =  1.0f;
              Knot_Draw(( Timer-128 )*0.4f, 12, 3 );
             } else
          // --- Part2.
          if ( Timer < 128+2*SYNC )
            { 
              if ( Timer < 128+SYNC+256 ) GlobalShade = ( Timer-SYNC-128 ) / 256.0f; else
              if ( Timer > 128+2*SYNC-256 ) GlobalShade = ( 128+2*SYNC-Timer ) / 256.0f; else
                GlobalShade =  1.0f;
              Ringt_Draw( Timer-SYNC );

              glMatrixMode( GL_PROJECTION );
              glLoadIdentity();
              gluOrtho2D( 0, 640, 360, 0 );
              glMatrixMode( GL_MODELVIEW );
              glLoadIdentity();

              glBindTexture( GL_TEXTURE_2D, Texture[0] );
              glShadeModel( GL_SMOOTH );
              glBlendFunc( GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA );
              glDisable( GL_DEPTH_TEST );
              glEnable( GL_BLEND );
              glEnable( GL_TEXTURE_2D );

              glColor4f( 1.0f, 1.0f, 1.0f, 0.2f * GlobalShade );
              glBegin( GL_QUADS );
                glTexCoord2f( 85.0f / 256.0f, 0.0f / 256.0f );
                glVertex3f( 250.0f, 30.0f, 0.0f );
                glTexCoord2f( 255.0f / 256.0f, 0.0f / 256.0f );
                glVertex3f( 590.0f, 30.0f, 0.0f );
                glTexCoord2f( 255.0f / 256.0f, 88.0f / 256.0f );
                glVertex3f( 590.0f, 206.0f, 0.0f );
                glTexCoord2f( 85.0f / 256.0f, 88.0f / 256.0f );
                glVertex3f( 250.0f, 206.0f, 0.0f );
              glEnd();

              glColor4f( 1.0f, 1.0f, 1.0f, 0.9f * GlobalShade );
              glBegin( GL_QUADS );
                glTexCoord2f( 85.0f / 256.0f, 0.0f / 256.0f );
                glVertex3f( 400.0f, 40.0f, 0.0f );
                glTexCoord2f( 255.0f / 256.0f, 0.0f / 256.0f );
                glVertex3f( 570.0f, 40.0f, 0.0f );
                glTexCoord2f( 255.0f / 256.0f, 88.0f / 256.0f );
                glVertex3f( 570.0f, 128.0f, 0.0f );
                glTexCoord2f( 85.0f / 256.0f, 88.0f / 256.0f );
                glVertex3f( 400.0f, 128.0f, 0.0f );
              glEnd();
/*
              glColor4f( 1.0f, 1.0f, 1.0f, GlobalShade );
              glBegin( GL_QUADS );
                glTexCoord2f( 0.0f / 256.0f, 0.0f / 256.0f );
                glVertex3f( 335.0f, 131.0f, 0.0f );
                glTexCoord2f( 85.0f / 256.0f, 0.0f / 256.0f );
                glVertex3f( 420.0f, 131.0f, 0.0f );
                glTexCoord2f( 85.0f / 256.0f, 14.0f / 256.0f );
                glVertex3f( 420.0f, 145.0f, 0.0f );
                glTexCoord2f( 0.0f / 256.0f, 14.0f / 256.0f );
                glVertex3f( 335.0f, 145.0f, 0.0f );

                glTexCoord2f( 0.0f / 256.0f, 15.0f / 256.0f );
                glVertex3f( 420.0f, 131.0f, 0.0f );
                glTexCoord2f( 85.0f / 256.0f, 15.0f / 256.0f );
                glVertex3f( 505.0f, 131.0f, 0.0f );
                glTexCoord2f( 85.0f / 256.0f, 29.0f / 256.0f );
                glVertex3f( 505.0f, 145.0f, 0.0f );
                glTexCoord2f( 0.0f / 256.0f, 29.0f / 256.0f );
                glVertex3f( 420.0f, 145.0f, 0.0f );
              glEnd();
*/
              glBindTexture( GL_TEXTURE_2D, Texture[1] );

              X_DrawString( "SINGLE", 420.0f, 140.0f, 1, 14, GlobalShade );

              glDisable( GL_TEXTURE_2D );
              glDisable( GL_BLEND );
              glEnable( GL_DEPTH_TEST );

             } else
          // --- Part3.
          if ( Timer < 128+3*SYNC )
            {
              if ( Timer < 128+2*SYNC+256 ) GlobalShade = ( Timer-2*SYNC-128 ) / 256.0f; else
              if ( Timer > 128+3*SYNC-256 ) GlobalShade = ( 128+3*SYNC-Timer ) / 256.0f; else
                GlobalShade =  1.0f;
              BlobIso = 0.3f;
              Blob_Draw( Timer-128, 0 );
             } else
          // --- Part4.
          if ( Timer < 128+4*SYNC )  
            {
              if ( Timer < 128+3*SYNC+256 ) GlobalShade = ( Timer-3*SYNC-128 ) / 256.0f; else
              if ( Timer > 128+4*SYNC-256 ) GlobalShade = ( 128+4*SYNC-Timer ) / 256.0f; else
                GlobalShade =  1.0f;
              HexFl_Draw( Timer-3*SYNC-256 );
             } else
          // --- Part5.
          if ( Timer < 128+5*SYNC )  
            {
              if ( Timer < 128+4*SYNC+256 ) GlobalShade = ( Timer-4*SYNC-128 ) / 256.0f; else
              if ( Timer > 128+5*SYNC-256 ) GlobalShade = ( 128+5*SYNC-Timer ) / 256.0f; else
                GlobalShade =  1.0f;
              Torus_Draw( Timer-SYNC-128 );
             } else
          // --- Part6.
          if ( Timer < 128+6*SYNC )  
            {
              if ( Timer < 128+5*SYNC+256 ) GlobalShade = ( Timer-5*SYNC-128 ) / 256.0f; else
              if ( Timer > 128+6*SYNC-256 ) GlobalShade = ( 128+6*SYNC-Timer ) / 256.0f; else
                GlobalShade =  1.0f;
              BlobIso = 0.18f;
              Blob_Draw( Timer-SYNC-128, 1 );
             } else
          // --- Part7.
          if ( Timer < 128+7*SYNC )
            {
              if ( Timer < 128+6*SYNC+256 ) GlobalShade = ( Timer-6*SYNC-128 ) / 256.0f; else
              if ( Timer > 128+7*SYNC-256 ) GlobalShade = ( 128+7*SYNC-Timer ) / 256.0f; else
                GlobalShade =  1.0f;
              GlobalShade *= 0.8f;
              Rings_Draw( Timer-128-512 );
              // Quads_Draw( Timer-128, GlobalShade );
             } else
          // --- Part8.
          if ( Timer < 128+8*SYNC )
            {
              if ( Timer < 128+7*SYNC+256 ) GlobalShade = ( Timer-7*SYNC-128 ) / 256.0f; else
              if ( Timer > 128+8*SYNC-256 ) GlobalShade = ( 128+8*SYNC-Timer ) / 256.0f; else
                GlobalShade = 1.0f;
              Morph_Draw( Timer-128-7*SYNC );
             } else
          // --- Part9.
          if ( Timer < 128+9*SYNC )
            {
              if ( Timer < 128+8*SYNC+256 ) GlobalShade = ( Timer-8*SYNC-128 ) / 256.0f; else
              if ( Timer > 128+9*SYNC-256 ) GlobalShade = ( 128+9*SYNC-Timer ) / 256.0f; else
                GlobalShade = 1.0f;
              HexaTun_Draw( Timer-8*SYNC-128, 1.0f + 0.2f * Fsin(( Timer-8*SYNC-128 ) * Pi / 510.0f )); 
             } else
          // --- Part10.
          if ( Timer < 128+11*SYNC )
            {
              if ( Timer < 128+9*SYNC+256 ) GlobalShade = ( Timer-9*SYNC-128 ) / 256.0f; else
              if ( Timer > 128+10*SYNC ) GlobalShade = ( 128+11*SYNC-Timer ) / SYNC; else
                GlobalShade = 1.0f;
              BlobIso = 0.22f;
              TBlob_Draw( Timer );
             } else
            SendMessage( hWnd, WM_CLOSE, 0, 0 );

          // --- Texts.
         
          glMatrixMode( GL_PROJECTION );
          glLoadIdentity();
          gluOrtho2D( 0, 640, 360, 0 );
          glMatrixMode( GL_MODELVIEW );
          glLoadIdentity();

          TimedStrings( Timer );

#ifdef _DEBUG

          // --- Frames/Sec.
          char FpsTx[10];
          sprintf( FpsTx, "%4.2f", Timer );
          X_DrawString( FpsTx, 80, 6, 1, 1, 1.0f );
          sprintf( FpsTx, "%3.3f", Fps );
          X_DrawString( FpsTx, 130, 6, 1, 1, 1.0f );

#endif

          if ( DoTimer ) Frame++;
          SwapBuffers( hDC );
        }
   }
