
#include "Fontset.i"

float Fontx[] = {
  0, 103, 0, 0, 0, 0, 0, 123, 0, 0, 0, 0, 87, 90, 75, 106,
  0, 8, 14, 21, 29, 37, 44, 52, 60, 67, 75, 79, 0, 0, 0, 96,
  112, 0, 8, 16, 23, 30, 37, 43, 51, 58, 62, 67, 74, 78, 88, 95,
  103, 110, 117, 0, 7, 13, 21, 28, 38, 45, 52, 0, 0, 0, 0, 0 };
float Fonty[] = {
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14,
  14, 14, 14, 30, 30, 30, 30, 30, 30, 30, 30, 0, 0, 0, 0, 0 };
float Fontw[] = {
  7, 3, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 4, 6, 3, 6, 
  8, 6, 7, 8, 8, 7, 8, 8, 7, 8, 4, 0, 0, 0, 0, 7,
  12, 8, 8, 7, 7, 7, 6, 8, 7, 4, 5, 7, 4, 10, 7, 8,  // a-o
  7, 7, 6, 7, 6, 8, 7, 10, 7, 7, 7, 0, 0, 0, 0 };
float Fonth[] = {
  0, 12, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 12, 12, 12, 12,
  12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 0, 0, 0, 12,
  12, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15,
  15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 0, 0, 0, 0 };

void X_DrawFont( char chr, float x, float y, float size, float alpha )
  {
    chr -= ' ';
    if (( chr > 0 ) && ( chr < 64 ))
      {
        glColor4f( 0.0f, 0.0f, 0.0f, alpha );
        glShadeModel( GL_SMOOTH );
        glBlendFunc( GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA );
        glDisable( GL_DEPTH_TEST );
        glEnable( GL_BLEND );
        glEnable( GL_TEXTURE_2D );
        glBegin( GL_QUADS );
          glTexCoord2f( Fontx[chr] / 128.0f, Fonty[chr] / 128.0f );
          glVertex3f( x - size*Fontw[chr]/2, y - size*Fonth[chr]/2, 0 );
          glTexCoord2f( (Fontx[chr]+Fontw[chr]) / 128.0f, Fonty[chr] / 128.0f );
          glVertex3f( x + size*Fontw[chr]/2, y - size*Fonth[chr]/2, 0 );
          glTexCoord2f( (Fontx[chr]+Fontw[chr]) / 128.0f, (Fonty[chr]+Fonth[chr]) / 128.0f );
          glVertex3f( x + size*Fontw[chr]/2, y + size*Fonth[chr]/2, 0 );
          glTexCoord2f( Fontx[chr] / 128.0f, (Fonty[chr]+Fonth[chr]) / 128.0f );
          glVertex3f( x - size*Fontw[chr]/2, y + size*Fonth[chr]/2, 0 );
        glEnd();
        glDisable( GL_TEXTURE_2D );
        glDisable( GL_BLEND );
        glEnable( GL_DEPTH_TEST );
       }
   }

float X_StrLen( char *str, float size, float dist )
  {
    float len = 0.0f;
    while ( *str )
      len += ( Fontw[ *(str++) - ' ' ] + dist ) * size;
    return len;
   }

void X_DrawString( char *str, float x, float y, float size, float dist, float alpha )
  {
    x -= X_StrLen( str, size, dist )/2;
    while ( *str )
      {
        X_DrawFont( *str, x, y, size, alpha );
        X_DrawFont( *str, x, y, 2*size, 0.2f*alpha );
        X_DrawFont( *str, x, y, 3*size, 0.1f*alpha );
        x += ( Fontw[ *(str++) - ' ' ] + dist ) * size;
       }
   }

// ---

typedef struct _Ttext
  { 
    int TextN;
    float Timer, X, Y; 
   } Ttext;

#define TIME 1024

char *Text[] =
  { 
    "I CALLED YOU FROM THE HOTEL PHONE.", "I HAVEN'T DIALED THIS CODE BEFORE.",
    "I'M SLEEPING LATER, WAKING LATER,", "I'M EATING LESS AND THINKING MORE.",
    "AND HOW AM I WITHOUT YOU?", "AM I MORE MYSELF OR LESS MYSELF?",
    "I FEEL YOUNGER, LOUDER.", "LIKE I DON'T ALWAYS CONNECT.",
    "LIKE I DON'T EVER CONNECT.",

    "I'LL PUT MY SUITCASE HERE FOR NOW,", "I'LL TURN THE TV TO THE BED,",
    "BUT IF NO-ONE CALLS AND I DON'T SPEAK ALL DAY,", "DO I DISAPPEAR?",
    "LOOK AT ME, WITHOUT YOU", "I'M QUITE PROUD OF MYSELF,",
    "I FEEL RECKLESS, CLUMSY.", "LIKE I'M MAKING A MISTAKE,",
    "A REALLY BIG MISTAKE.",

    "DO YOU LIKE BEING SINGLE?", "DO YOU WANT ME BACK,", "DO YOU WANT ME BACK?",
    "DO I LIKE BEING SINGLE?", "AM I COMING BACK,", "AM I COMING BACK?",
    "DO YOU WANT ME BACK?",

//  "NOW I KNOW, EACH TIME I GO,", "I DON'T REALLY KNOW,", "WHAT I THINK I KNOW.",
//  "DO YOU WANT ME BACK,", "DO YOU WANT ME BACK?"

    "FRESH.SCENE-HU.COM", "REMAGE - JUST - IMMORTAL RAT"
   };

#define TTXT 27

Ttext Ttxt[] = 
  {
    { 25, 10*SYNC + 640.0f, 320.0f, 320.0f }, { 26, 640.0f, 320.0f, 320.0f },

    { 0, 2*SYNC + 128.0f, 360.0f, 50.0f }, { 1, 2*SYNC + 640.0f, 360.0f, 80.0f },
    { 2, 2*SYNC + 1152.0f, 360.0f, 110.0f }, { 3, 2*SYNC + 1664.0f, 360.0f, 140.0f },
    { 4, 3*SYNC + 128.0f, 360.0f, 80.0f }, { 5, 3*SYNC + 640.0f, 360.0f, 110.0f },
    { 6, 3*SYNC + 1152.0f, 360.0f, 140.0f }, { 7, 3*SYNC + 1664.0f, 360.0f, 170.0f },
    { 8, 4*SYNC + 128.0f, 300.0f, 250.0f },

    { 9, 5*SYNC + 128.0f, 360.0f, 50.0f }, { 10, 5*SYNC + 640.0f, 360.0f, 80.0f },
    { 11, 5*SYNC + 1152.0f, 360.0f, 110.0f }, { 12, 5*SYNC + 1664.0f, 360.0f, 140.0f },
    { 13, 6*SYNC + 128.0f, 360.0f, 80.0f }, { 14, 6*SYNC + 640.0f, 360.0f, 110.0f },
    { 15, 6*SYNC + 1152.0f, 360.0f, 140.0f }, { 16, 6*SYNC + 1664.0f, 360.0f, 170.0f },
    { 17, 7*SYNC + 128.0f, 300.0f, 250.0f },

    { 18, 8*SYNC + 128.0f, 360.0f, 50.0f }, { 19, 8*SYNC + 640.0f, 360.0f, 80.0f },
    { 20, 8*SYNC + 1152.0f, 360.0f, 110.0f },

    { 21, 9*SYNC + 128.0f, 360.0f, 80.0f }, { 22, 9*SYNC + 640.0f, 360.0f, 110.0f },
    { 23, 9*SYNC + 1152.0f, 360.0f, 140.0f },

    { 24, 10*SYNC + 128.0f, 300.0f, 220.0f }

   };

void TimedStrings( float Timer )
  {
    int I;
    float T2, Al, Dt;

    for ( I = 0; I < TTXT; I++ )
      if (( Timer > Ttxt[I].Timer ) && ( Timer < ( Ttxt[I].Timer + TIME )))
        {
          T2 = ( Timer - Ttxt[I].Timer ) / TIME;
          T2 = T2*T2;
          Al = Fsin( T2 * Pi / 2 );
          Al *= 3*( 1.0f - Al );
          Dt = 16.0f - 14.0f * Fcos( T2 * Pi / 2 );
          X_DrawString( Text[ Ttxt[I].TextN ], Ttxt[I].X, Ttxt[I].Y, 1.0f, Dt, Al );
         }
   }
