
#include <D3D8.h>
#include "Fmath.h"
#include "Main.h"

extern float Fpow( float Value, float Exp );

// ------------------------------------------------------------------------------------------------

HDC Lyrics_hDC;
HFONT hFont, hPrevFont;
HBITMAP hBitmap, hPrevBitmap;
BITMAPINFO BitmapInfo =
  { sizeof( BITMAPINFOHEADER ), 512, 512, 1, 32, BI_RGB, 0, 0, 0, 0, 0 };
unsigned char *BitmapData, *Buf;

LPDIRECT3DTEXTURE8 Lyrics_Texture1 = NULL;
LPDIRECT3DVERTEXBUFFER8 Lyrics_VertexBuffer1 = NULL;

extern int HunLyrics;

// ------------------------------------------------------------------------------------------------

#define D3DFVF_LYRICS_VERTEX1 (D3DFVF_XYZRHW|D3DFVF_DIFFUSE|D3DFVF_TEX1)
struct  LYRICS_VERTEX1
  {
    D3DVECTOR Vertex;
    float RHW;
    DWORD Diffuse;
    float TexU, TexV;
   };

LYRICS_VERTEX1 *Lyrics_Vertex1, Lyrics_ConstVertex1[] = 
  {{{ 360.0f, 280.0f, 0.5f }, 1.0f, 0x00FFFFFF, 0.0f, 1.0f },
    {{ 616.0f, 280.0f, 0.5f }, 1.0f, 0x00FFFFFF, 1.0f, 1.0f },
    {{ 360.0f, 344.0f, 0.5f }, 1.0f, 0x00FFFFFF, 0.0f, 0.0f },
    {{ 616.0f, 344.0f, 0.5f }, 1.0f, 0x00FFFFFF, 1.0f, 0.0f }};

// ------------------------------------------------------------------------------------------------

typedef struct _LYRICSTRUCT
  {
    LPDIRECT3DTEXTURE8 Texture;
    int FontX, FontY, FontH, Color;
    char *String[2];
    float Time1, Time2, ScreenX, ScreenY, ScreenSpd;
   } LYRICSTRUCT;

/*
 2  Did it happen to you, that you had no mood to sleep, to escape into dreams,
      and nevertheless you could (also) dream awake 'till morning?
 2  And then the Sun still rises, everything is peaceful.
      No one noticed the new beginning day yet; how can it be endured alone? 
 2  It is so beautiful that the night yields the world to the light, though I 
      should only cry. I could only lose everything, even that, what never were 
      mine. 
 2  It never will be mine. She said. And... this morning the yesterday had been 
      lost too. Every day... How could I wait for the tomorrow? 
 1  Even if these few years I lived have taken so long, what else could I
      wait for?
----------
 2  It was so easy. She promised nothing, 'cause She couldn't do. Still, a 
      glance was enough to believe, She doesn't want to lose me either... 
 2  And then I didn't have to promise anything, 'cause noone else mattered 
      since that moment. 
 2  And I was happy if I could give something at all. And I (also) had my head in 
      the clouds, when I could not only think about Her, but I could be near Her.
 1  But... this was the most... 
 1  Nevertheless I am selfish. 
----------
 2  I could scream that I need Her. Can you imagine the feeling, to wake day 
      by day to the fact, that you are still lonely? 
 2  And if this never was different? I thought I had got accustomed, but... when
      I could see Her, I could imagine, that I can forget all this bad forever. 
 2  That there's someone, whose dream I can watch over, and with whom I can be 
      happy to live. (and with Her can we be pleased that we live.) 
      Whose hands I can hold, whose face I can caress. 
 2  Whom I could clasp in my arms, with whom I can see the sunset and with whom 
      every moment can only be beautiful.
----------
 1
 2  But the dawn is approaching slowly... maybe it'll be beautiful, but I 
      couldn't see anything from my tears at all...
 1  She must still be sleeping. She has someone to dream of.
*/

/*
 2  Elfordult-e mr veled, hogy nem volt kedved elaludni, lmokba meneklni, 
      s mgis reggelig bren is csak lmodni tudtl? 
 2  s aztn mgis felkel a nap, minden csndes. Mg senki sem vette szre, 
      hogy j nap kezddtt; hogy lehet ezt elviselni egyedl?
 2  Olyan gynyr, ahogy az jszaka tengedi a vilgot a fnynek, n mgis csak srni tudnk.
      Mindent csak elveszteni tudtam, mg azt is, ami sosem volt az enym.
 2  Sose lesz.  mondta. s... ezen a reggelen is elveszett a tegnap. Minden nap... 
      Hogyan tudnm vrni a holnapot? 
 1  Ha ez a pr v is ilyen hossz volt, amita lek, mire tudnk mg vrni?
- 
 2  Olyan knny volt.  nem grt semmit, mert nem tehette.
      Mgis elg volt egy pillants, hogy elhiggyem;  sem akar elveszteni... 
 2  s akkor mr nem kellett meggrnem semmit, mert ettl a pillanattl kezdve 
      nem szmtott senki ms.
 2  s boldog voltam, ha egyltaln adhattam valamit. s mr attl is a fellegekben jrtam, 
      ha nem csak gondolhattam r, hanem a kzelben is lehettem.
 1  Pedig... ez volt a legtbb... 
 1  s mgis nz vagyok.
-
 2  vlteni tudnk, hogy szksgem van r.
      El tudod kpzelni, milyen rzs nap mint nap arra bredni, hogy mg mindig magnyos vagy?
 2  s ha ez soha nem is volt mskpp? Azt hittem, hogy hozzszoktam mr,
      de... ha csak rnzhettem, el tudtam kpzelni, hogy mindezt a rosszat rkre el tudom felejteni.
 2  Hogy van valaki, akinek vigyzhatom az lmt, s vele egytt rlhetek annak, hogy lnk.
      Akinek foghatom a kezt, megsimogathatom az arct.
 2  Akit tlelhetek, s akivel nzhetem a naplementt,
      s akivel minden pillanat csak gynyr lehet.
-
 1
 2  De lassan kzeledik a hajnal... lehet, hogy gynyr lesz, de gysem ltnk
      belle semmit a knnyeimtl...
 1   mg biztos alszik. Neki van kirl lmodnia.
*/

LYRICSTRUCT Lyrics[] =
  {
    { NULL, 20, 51, 40, 0x9F9F9F, { "Precalculating, please wait...", "Precalculating, please wait..." }, 
        0.0f, 5.0f, 64.0f, 95.0f, -30.0f },
// --- [ 0.0f ]
    { NULL, 20, 51, 47, 0x8F8F8F, { "Did it happen to you,", "Elfordult-e mr veled," },
        0.0f, 5.0f, 64.0f, 95.0f, -30.0f },
    { NULL, 1, 31, 46, 0x8F8F8F, { "that you had no mood to sleep,", "hogy nem volt kedved elaludni," },
        1.0f, 6.0f, 64.0f, 130.0f, 32.0f },
    { NULL, 120, 21, 50, 0x9F9F9F, { "to escape into dreams,", "lmokba meneklni," },
        2.0f, 7.0f, 64.0f, 165.0f, 15.0f },
    { NULL, 10, 71, 40, 0x7F7F7F, { "and nevertheless you could", "s mgis reggelig bren is" },
        3.0f, 8.0f, 64.0f, 158.0f, -26.0f },
    { NULL, 120, 1, 80, 0xCFCFCF, { "dream awake", "csak lmodni" },
        4.0f, 8.5f, 24.0f, 220.0f, 8.0f },
    { NULL, 185, 41, 50, 0x7F7F7F, { "till morning ?", "tudtl ?" },
        5.0f, 9.0f, 64.0f, 240.0f, 18.0f },
// --- [ 8.0f ]
    { NULL, 20, 51, 47, 0x8F8F8F, { "And the Sun still rises,", "s aztn mgis felkel a nap," },
        8.0f, 13.0f, 80.0f, 70.0f, 30.0f },
    { NULL, 20, 21, 40, 0x7F7F7F, { "everything is peaceful.", "minden csndes." },
        8.7f, 13.7f, 80.0f, 105.0f, -5.0f },
    { NULL, 20, 31, 55, 0x9F9F9F, { "No one noticed", "Mg senki sem vette szre," },
        10.0f, 15.0f, 80.0f, 150.0f, -20.0f },
    { NULL, 20, 71, 50, 0x7F7F7F, { "the new beginning day yet;", "hogy j nap kezddtt;" },
        11.0f, 16.0f, 80.0f, 150.0f, 15.0f },
    { NULL, 20, 21, 47, 0x7F7F7F, { "how can it be endured", "hogyan lehet ezt elviselni" },
        12.0f, 17.0f, 80.0f, 225.0f, -15.0f },
    { NULL, 30, 21, 80, 0xCFCFCF, { "alone ?", "egyedl ?" },
        12.8f, 17.8f, 80.0f, 245.0f, 35.0f },
// --- [ 16.0f ]
    { NULL, 1, 51, 42, 0x8F8F8F, { "It is so beautiful that the night", "Olyan gynyr ahogy az jszaka" },
        16.0f, 21.0f, 70.0f, 70.0f, -20.0f },
    { NULL, 10, 11, 47, 0x9F9F9F, { "yields the world to the light,", "tengedi a vilgot a fnynek," },
        17.0f, 22.0f, 70.0f, 115.0f, 10.0f },
    { NULL, 60, 31, 47, 0x6F6F6F, { "though I should only cry.", "n mgis csak srni tudnk." },
        18.0f, 23.0f, 40.0f, 140.0f, 20.0f },
    { NULL, 10, 61, 45, 0xCFCFCF, { "I could only lose everything,", "Mindent csak elveszteni tudtam," },
        19.0f, 24.0f, 70.0f, 190.0f, -15.0f },
    { NULL, 20, 31, 65, 0x8F8F8F, { "even that,", "mg azt is," },
        20.0f, 25.0f, 70.0f, 230.0f, 35.0f },
    { NULL, 20, 21, 50, 0x9F9F9F, { "what never was mine.", "ami sosem volt az enym." },
        21.0f, 26.0f, 70.0f, 260.0f, 10.0f },
    { NULL, 80, 41, 40, 0x6F6F6F, { "Never will be mine.", "Sose lesz." },
        23.0f, 28.0f, 90.0f, 80.0f, -10.0f },
// --- [ 24.0f ]
    { NULL, 20, 21, 80, 0x6F6F6F, { "She said.", " mondta." },
        24.0f, 29.0f, 70.0f, 100.0f, 20.0f },
    { NULL, 285, 36, 50, 0x8F8F8F, { "And...", "s..." },
        24.5f, 29.5f, 90.0f, 104.0f, 20.0f },
    { NULL, 25, 36, 47, 0x8F8F8F, { "this morning the yesterday", "Ezen a reggelen is" },
        26.0f, 31.0f, 70.0f, 133.0f, -10.0f },
    { NULL, 55, 36, 47, 0x8F8F8F, { "had been lost too.", "elveszett a tegnap." },
        27.0f, 32.0f, 63.0f, 150.0f, -20.0f },
    { NULL, 295, 40, 40, 0x8F8F8F, { "Every day...", "Minden nap..." },
        27.5f, 32.5f, 100.0f, 152.0f, -20.0f },
    { NULL, 45, 36, 60, 0xAFAFAF, { "How could I wait", "Hogyan tudnm vrni" },
        29.0f, 34.0f, 70.0f, 190.0f, 20.0f },
    { NULL, 25, 16, 50, 0x8F8F8F, { "for the tomorrow ?", "a holnapot ?" },
        29.5f, 34.5f, 70.0f, 225.0f, -25.0f },
// --- [ 32.0f ]
    { NULL, 20, 21, 40, 0x7F7F7F, { "Even if these few years I lived", "Ha ez a pr v is ilyen" },
        31.5f, 35.5f, 70.0f, 110.0f, 20.0f },
    { NULL, 50, 21, 50, 0x6F6F6F, { "have taken so long,", "hossz volt, amita lek," },
        32.0f, 36.0f, 70.0f, 130.0f, -10.0f },
    { NULL, 80, 21, 70, 0x5F5F5F, { "what else", "mire" },
        33.0f, 37.0f, 70.0f, 160.0f, -20.0f },
    { NULL, 30, 61, 50, 0x4F4F4F, { "could I wait for ?", "tudnk mg vrni ?" },
        33.5f, 37.5f, 70.0f, 170.0f, 5.0f },
// --- [ 36.0f ]
    { NULL, 20, 21, 47, 0x9F9F9F, { "It was so easy.", "Olyan knny volt." },
        36.0f, 41.0f, 60.0f, 90.0f, 20.0f },
    { NULL, 20, 34, 47, 0x8F8F8F, { "She promised nothing,", " nem grt semmit," },
        37.0f, 42.0f, 50.0f, 105.0f, -13.0f },
    { NULL, 20, 21, 47, 0x7F7F7F, { "'cause She couldn't do.", "mert nem tehette." },
        38.0f, 43.0f, 90.0f, 135.0f, -5.0f },
    { NULL, 2, 21, 50, 0x9F9F9F, { "Still, a glance was enough", "Mgis elg volt egy pillants" },
        39.0f, 44.0f, 70.0f, 175.0f, 10.0f },
    { NULL, 100, 41, 70, 0xCFCFCF, { "to believe,", "hogy elhiggyem," },
        39.5f, 44.5f, 160.0f, 185.0f, 14.0f },
    { NULL, 20, 21, 47, 0x9F9F9F, { "that She doesn't want to", " sem akar" },
        41.0f, 46.0f, 40.0f, 230.0f, 20.0f },
    { NULL, 20, 21, 45, 0x8F8F8F, { "lose me either...", "elveszteni..." },
        41.5f, 46.5f, 160.0f, 250.0f, -10.0f },
// --- [ 44.0f ]
    { NULL, 20, 51, 50, 0x7F7F7F, { "And then I didn't have to", "s akkor mr nem kellett" },
        44.0f, 49.0f, 40.0f, 85.0f, 30.0f },
    { NULL, 20, 21, 47, 0x8F8F8F, { "promise anything,", "meggrnem semmit," },
        44.5f, 49.5f, 70.0f, 120.0f, 12.0f },
    { NULL, 20, 41, 45, 0xAFAFAF, { "'cause noone else mattered", "mert ettl a pillanattl kezdve" },
        45.5f, 50.5f, 50.0f, 140.0f, -22.0f },
    { NULL, 20, 21, 50, 0x9F9F9F, { "since that moment.", "nem szmtott senki ms." },
        46.0f, 51.0f, 70.0f, 170.0f, -8.0f },
    { NULL, 20, 21, 45, 0x7F7F7F, { "And I was happy if I could", "s boldog voltam," },
        48.0f, 53.0f, 70.0f, 210.0f, -10.0f },
    { NULL, 2, 21, 43, 0x6F6F6F, { "give something at all.", "ha egyltaln adhattam valamit." },
        49.0f, 54.0f, 70.0f, 230.0f, 18.0f },
// --- [ 52.0f ]
    { NULL, 2, 21, 45, 0x7F7F7F, { "And I had my head in the clouds", "s mr attl is a fellegekben" },
        52.0f, 57.0f, 70.0f, 120.0f, -8.0f },
    { NULL, 10, 21, 47, 0x8F8F8F, { "when I could not only", " jrtam, ha nem csak" },
        53.0f, 58.0f, 70.0f, 150.0f, 28.0f },
    { NULL, 20, 21, 45, 0x9F9F9F, { "think about Her,", "gondolhattam r, hanem" },
        53.75f, 58.75f, 70.0f, 190.0f, -18.0f },
    { NULL, 20, 21, 47, 0x8F8F8F, { "but I could be near Her.", "a kzelben is lehettem." },
        55.0f, 60.0f, 70.0f, 220.0f, 13.0f },
// --- [ 60.0f ]
    { NULL, 20, 21, 50, 0x7F7F7F, { "But... this was the most...", "Pedig... ez volt a legtbb..." },
        60.0f, 65.0f, 70.0f, 150.0f, -8.0f },
// --- [ 64.0f ]
    { NULL, 20, 21, 45, 0x6F6F6F, { "Nevertheless I am selfish.", "s mgis nz vagyok." },
        65.5f, 70.5f, 300.0f, 280.0f, -8.0f },
// --- [ 68.0f ]
    { NULL, 20, 21, 55, 0x9F9F9F, { "I could scream", "vlteni tudnk," },
        68.0f, 73.0f, 350.0f, 90.0f, 20.0f },
    { NULL, 20, 34, 40, 0x8F8F8F, { "that I need Her.", "hogy szksgem van r." },
        69.0f, 74.0f, 390.0f, 103.0f, -13.0f },
    { NULL, 20, 21, 47, 0x7F7F7F, { "Can you imagine the feeling", "El tudod kpzelni," },
        70.0f, 75.0f, 350.0f, 145.0f, -5.0f },
    { NULL, 20, 21, 47, 0x9F9F9F, { "to wake day by day", "milyen rzs nap mint nap" },
        71.0f, 76.0f, 400.0f, 170.0f, 10.0f },
    { NULL, 100, 41, 45, 0xAFAFAF, { "to the fact, that", "arra bredni, hogy" },
        72.0f, 77.0f, 270.0f, 200.0f, -14.0f },
    { NULL, 10, 21, 47, 0x9F9F9F, { "you are still lonely ?", "mg mindig magnyos vagy ?" },
        73.0f, 78.0f, 340.0f, 230.0f, 20.0f },
    { NULL, 20, 21, 45, 0x7F7F7F, { "And if this", "s ha ez" },
        74.5f, 79.5f, 360.0f, 260.0f, -10.0f },
    { NULL, 20, 21, 40, 0x6F6F6F, { "never was different ?", "soha nem is volt mskpp ?" },
        75.0f, 80.0f, 400.0f, 272.0f, 18.0f },
// --- [ 76.0f ]
    { NULL, 20, 51, 47, 0x8F8F8F, { "I thought I had got ", "Azt hittem, hogy" },
        76.0f, 81.0f, 364.0f, 95.0f, -30.0f },
    { NULL, 1, 31, 45, 0x8F8F8F, { "accustomed, but...", "hozzszoktam mr, de..." },
        76.5f, 81.5f, 364.0f, 130.0f, 32.0f },
    { NULL, 120, 21, 47, 0x9F9F9F, { "when I could see Her,", "ha csak rnzhettem," },
        78.0f, 83.0f, 364.0f, 165.0f, 15.0f },
    { NULL, 10, 71, 50, 0x7F7F7F, { "I could imagine", "el tudtam kpzelni," },
        79.0f, 84.0f, 364.0f, 155.0f, -26.0f },
    { NULL, 20, 1, 55, 0xCFCFCF, { "that I can forget", "hogy mindezt a rosszat" },
        80.0f, 85.0f, 374.0f, 210.0f, 18.0f },
    { NULL, 15, 41, 50, 0x7F7F7F, { "all this bad forever.", "rkre el tudom felejteni." },
        81.0f, 86.0f, 364.0f, 230.0f, 8.0f },
// --- [ 84.0f ]
    { NULL, 20, 51, 47, 0x8F8F8F, { "That there's someone,", "Hogy van valaki" },
        84.0f, 89.0f, 380.0f, 80.0f, 30.0f },
    { NULL, 20, 21, 40, 0x7F7F7F, { "whose dream I can watch over,", "akinek vigyzhatom az lmt," },
        85.0f, 90.0f, 380.0f, 113.0f, -5.0f },
    { NULL, 20, 31, 55, 0x9F9F9F, { "and with whom", "s vele egytt rlhetek" },
        86.0f, 91.0f, 380.0f, 150.0f, -20.0f },
    { NULL, 20, 71, 50, 0x7F7F7F, { "I can be happy to live.", "annak, hogy lnk." },
        87.0f, 92.0f, 380.0f, 155.0f, 15.0f },
    { NULL, 20, 31, 47, 0x7F7F7F, { "Whose hands I can hold,", "Akinek foghatom a kezt," },
        89.0f, 94.0f, 380.0f, 230.0f, -15.0f },
    { NULL, 30, 21, 45, 0x6F6F6F, { "whose face I can caress.", "megsimogathatom az arct." },
        90.0f, 95.0f, 380.0f, 255.0f, 35.0f },
// --- [ 92.0f ]
    { NULL, 2, 21, 45, 0x7F7F7F, { "Whom I could clasp in my arms,", "Akit tlelhetek," },
        92.0f, 97.0f, 350.0f, 120.0f, -8.0f },
    { NULL, 10, 31, 40, 0x6F6F6F, { "with whom I can see the sunset,", "s akivel nzhetem a naplementt," },
        93.0f, 98.0f, 330.0f, 135.0f, 18.0f },
    { NULL, 20, 41, 47, 0x9F9F9F, { "and with whom ", "s akivel" },
        95.0f, 100.0f, 370.0f, 150.0f, -18.0f },
    { NULL, 20, 21, 50, 0x9F9F9F, { "every moment", "minden pillanat" },
        96.0f, 101.0f, 390.0f, 190.0f, 23.0f },
    { NULL, 20, 25, 45, 0x8F8F8F, { "can only be beautiful.", "csak gynyr lehet." },
        97.0f, 102.0f, 370.0f, 218.0f, 13.0f },
// --- [ 100.0f ]
    { NULL, 20, 51, 57, 0xAFAFAF, { "But the dawn", "De lassan" },
        103.5f, 108.5f, 80.0f, 70.0f, 30.0f },
// --- [ 104.0f ]
    { NULL, 20, 21, 40, 0x8F8F8F, { "is approaching slowly...", "kzeledik a hajnal..." },
        104.0f, 109.0f, 80.0f, 107.0f, -5.0f },
    { NULL, 20, 31, 50, 0x9F9F9F, { "maybe it'll be beautiful,", "lehet, hogy gynyr lesz," },
        106.0f, 111.0f, 80.0f, 135.0f, -20.0f },
    { NULL, 20, 71, 47, 0x8F8F8F, { "but I couldn't see anything", "de gysem ltnk belle" },
        107.0f, 112.0f, 80.0f, 143.0f, 15.0f },
    { NULL, 20, 21, 40, 0x7F7F7F, { "from my tears at all...", "semmit a knnyeimtl..." },
        107.5f, 112.0f, 80.0f, 185.0f, -10.0f },
    { NULL, 30, 21, 47, 0xCFCFCF, { "She must still be sleeping.", " mg biztos alszik." },
        110.0f, 115.0f, 80.0f, 235.0f, 15.0f },
// --- [ 112.0f ]
    { NULL, 30, 21, 47, 0x7F7F7F, { "She has someone", "Neki van kirl" },
        111.5f, 116.5f, 60.0f, 255.0f, -8.0f },
    { NULL, 30, 21, 60, 0x6F6F6F, { "to dream of.", "lmodnia." },
        112.0f, 117.0f, 120.0f, 270.0f, 18.0f },
// --- [ 116.0f ]
    { NULL, 30, 41, 43, 0x7F7F7F, { "\"Dreams\" by Fresh!mindworkz", "\"Dreams\" by Fresh!mindworkz" } ,
        116.0f, 120.0f, 360.0f, 307.0f, 0.0f },
    { NULL, 30, 21, 30, 0x6F6F6F, { "Remage (code), Just (music), Enok (logo).","Remage (code), Just (music), Enok (logo)." },
        116.0f, 120.0f, 374.0f, 335.0f, 0.0f },
   };

// #define BORDER
// #define TIME 36.0f
#define LyricsNum 85

// ------------------------------------------------------------------------------------------------

int strlength( const char *St )
  {
    char *St2;
    for ( St2 = (char*) St; *St2!=0; St2++ );
    return ((int) St2 - (int) St );
   }

// ------------------------------------------------------------------------------------------------

void *Lyrics_CreateBMP( int Width, int Height )
  {
    Lyrics_hDC = CreateCompatibleDC( hDC );
    BitmapData = (unsigned char*) HeapAlloc( GetProcessHeap(), HEAP_ZERO_MEMORY, Width*Height*4 );
    BitmapInfo.bmiHeader.biWidth = Width;
    BitmapInfo.bmiHeader.biHeight = Height;
    hBitmap = CreateDIBSection( Lyrics_hDC, &BitmapInfo, DIB_RGB_COLORS, (void**) &BitmapData, NULL, 0 );
    hPrevBitmap = (HBITMAP) SelectObject( Lyrics_hDC, (HGDIOBJ) hBitmap );
    return BitmapData;
   }

void Lyrics_Write( int X, int Y, int Height, char *String, DWORD Color )
  {
    RECT Rect1 = { 2, 2, 509, 125 }, Rect2 = { 4, 4, 507, 123 };
    hFont = CreateFont( Height, 0, 0, 0, FW_NORMAL, 1, 0, 0, DEFAULT_CHARSET, OUT_TT_ONLY_PRECIS, CLIP_DEFAULT_PRECIS, 
      ANTIALIASED_QUALITY, FF_ROMAN|DEFAULT_PITCH, "Times New Roman Italic" );
    hPrevFont = (HFONT) SelectObject( Lyrics_hDC, (HGDIOBJ) hFont );
#ifdef BORDER
    FillRect( Lyrics_hDC, &Rect1, (HBRUSH) GetStockObject( WHITE_BRUSH ));
    FillRect( Lyrics_hDC, &Rect2, (HBRUSH) GetStockObject( BLACK_BRUSH ));
#endif
    SetTextColor( Lyrics_hDC, Color );
    SetBkMode( Lyrics_hDC, TRANSPARENT );
    ExtTextOut( Lyrics_hDC, X, Y, 0, NULL, String, strlength( String ), NULL );
    DeleteObject( SelectObject( Lyrics_hDC, (HGDIOBJ) hPrevFont ));
   }

void Lyrics_DeleteBMP( void )
  {
    DeleteObject( SelectObject( Lyrics_hDC, (HGDIOBJ) hPrevBitmap ));
    HeapFree( GetProcessHeap(), 0, (void*) BitmapData );
    DeleteDC( Lyrics_hDC );
   }

int Lyrics_Initialize( void )
  {
    int i, j, i2, j2, av0, av1, av2, av3;
    unsigned char *Ptr, *Ptr2;

    // --- Initialize Textures.
    for ( int L=0; L<LyricsNum; L++ )
      {
        // MessageBox( 0, "Lyrics_Initialize() Loop", "DEBUG!", MB_OK );
        Direct3DDevice->CreateTexture( 256, 64, 0, 0, D3DFMT_A8R8G8B8, D3DPOOL_MANAGED, &Lyrics[L].Texture );
        Lyrics[L].Texture->LockRect( 0, &D3DLockedRect, NULL, 0 );
        Ptr2 = (unsigned char*) D3DLockedRect.pBits;
        Ptr = (unsigned char*) Lyrics_CreateBMP( 512, 128 );
        Lyrics_Write( Lyrics[L].FontX, Lyrics[L].FontY, Lyrics[L].FontH, Lyrics[L].String[HunLyrics], Lyrics[L].Color );

        for ( j=0; j<64; j++ )
          for ( i=0; i<256; i++ )
            {
              av0 = av1 = av2 = av3 = 0;
              for ( j2=0; j2<2; j2++ )
                for ( i2=0; i2<2; i2++ )
                  {
                    av0 += Ptr[ (j*2+j2) * 2048 + (i*2+i2) * 4 + 0 ];
                    av1 += Ptr[ (j*2+j2) * 2048 + (i*2+i2) * 4 + 1 ];
                    av2 += Ptr[ (j*2+j2) * 2048 + (i*2+i2) * 4 + 2 ];
                    av3 += Ptr[ (j*2+j2) * 2048 + (i*2+i2) * 4 + 3 ];
                   }
              Ptr2[ j*1024 + i*4 + 0 ] = av0 / 4;
              Ptr2[ j*1024 + i*4 + 1 ] = av1 / 4;
              Ptr2[ j*1024 + i*4 + 2 ] = av2 / 4;
              Ptr2[ j*1024 + i*4 + 3 ] = av3 / 4;
            }

        Lyrics_DeleteBMP();
        Lyrics[L].Texture->UnlockRect( 0 );
       }

    // --- Vertex Buffer.
    if ( Direct3DDevice->CreateVertexBuffer( 8*sizeof( LYRICS_VERTEX1 ), 0, D3DFVF_LYRICS_VERTEX1, 
           D3DPOOL_DEFAULT, &Lyrics_VertexBuffer1 ) != D3D_OK ) return 0;
    if ( Lyrics_VertexBuffer1->Lock( 0, 8*sizeof( LYRICS_VERTEX1 ), (BYTE**) &Lyrics_Vertex1, 0 ) != D3D_OK ) return 0;

    for ( i=0; i<8; i++ )
      Lyrics_Vertex1[i] = Lyrics_ConstVertex1[i&3];

    Lyrics_VertexBuffer1->Unlock();

    // --- Render "Precalculating..."

    Direct3DDevice->BeginScene();
    Direct3DDevice->Clear( 0, NULL, D3DCLEAR_TARGET|D3DCLEAR_ZBUFFER|D3DCLEAR_STENCIL, D3DCOLOR_XRGB(0,0,0), 1.0f, 0 );

    // --- Setup Texture.
    Direct3DDevice->SetTexture( 0, Lyrics[0].Texture );

    Direct3DDevice->SetTextureStageState( 0, D3DTSS_MAGFILTER, D3DTEXF_LINEAR );
    Direct3DDevice->SetTextureStageState( 0, D3DTSS_MINFILTER, D3DTEXF_LINEAR );
    Direct3DDevice->SetTextureStageState( 0, D3DTSS_MIPFILTER, D3DTEXF_NONE );

    Direct3DDevice->SetTextureStageState( 0, D3DTSS_COLOROP, D3DTOP_SELECTARG1 );
    Direct3DDevice->SetTextureStageState( 0, D3DTSS_COLORARG1, D3DTA_TEXTURE );
    Direct3DDevice->SetTextureStageState( 0, D3DTSS_ALPHAOP, D3DTOP_DISABLE );

    Direct3DDevice->SetTextureStageState( 1, D3DTSS_COLOROP, D3DTOP_DISABLE );

    // --- Setup Shader.
    Direct3DDevice->SetVertexShader( D3DFVF_LYRICS_VERTEX1 );

    Direct3DDevice->SetRenderState( D3DRS_AMBIENT, 0x00FFFFFF );

    Direct3DDevice->SetStreamSource( 0, Lyrics_VertexBuffer1, sizeof( LYRICS_VERTEX1 ));
    Direct3DDevice->DrawPrimitive( D3DPT_TRIANGLESTRIP, 0, 2 );

    Direct3DDevice->EndScene();
    Direct3DDevice->Present( NULL, NULL, NULL, NULL );
    return 1;
   }

void Lyrics_Render( float Time )
  {
#ifdef TIME
    Time += TIME;
#endif    

    // --- Setup Blending.
    Direct3DDevice->SetRenderState( D3DRS_SRCBLEND, D3DBLEND_ONE );
    Direct3DDevice->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_ONE );
    Direct3DDevice->SetRenderState( D3DRS_ALPHABLENDENABLE, TRUE );
    Direct3DDevice->SetRenderState( D3DRS_ZENABLE, FALSE );

    Direct3DDevice->SetRenderState( D3DRS_STENCILENABLE, FALSE );
    
    Direct3DDevice->LightEnable( 0, FALSE );

    // --- Setup Shader.
    Direct3DDevice->SetVertexShader( D3DFVF_LYRICS_VERTEX1 );

    Direct3DDevice->SetTextureStageState( 0, D3DTSS_COLOROP, D3DTOP_MODULATE );
    Direct3DDevice->SetTextureStageState( 0, D3DTSS_COLORARG1, D3DTA_TEXTURE );
    Direct3DDevice->SetTextureStageState( 0, D3DTSS_COLORARG2, D3DTA_DIFFUSE );
    Direct3DDevice->SetTextureStageState( 0, D3DTSS_ALPHAOP, D3DTOP_DISABLE );

    Direct3DDevice->SetTextureStageState( 0, D3DTSS_MAGFILTER, D3DTEXF_LINEAR );
    Direct3DDevice->SetTextureStageState( 0, D3DTSS_MINFILTER, D3DTEXF_LINEAR );
    Direct3DDevice->SetTextureStageState( 0, D3DTSS_MIPFILTER, D3DTEXF_NONE );

    Direct3DDevice->SetTextureStageState( 1, D3DTSS_COLOROP, D3DTOP_DISABLE );

//  Direct3DDevice->SetRenderState( D3DRS_AMBIENT, 0x00B0B0B0 );
    Direct3DDevice->SetRenderState( D3DRS_AMBIENT, 0x00FFFFFF );

    for ( int L=1; L<LyricsNum; L++ )
      if (( Time >= Lyrics[L].Time1 ) && ( Time < Lyrics[L].Time2 ))
        {
          float Time2 = ( Time - Lyrics[L].Time1 ) / ( Lyrics[L].Time2 - Lyrics[L].Time1 );
          float Delta = Time2 * Lyrics[L].ScreenSpd;
          float Light = Fcos( Fpow( Time2, 0.8f ) * Fmath_2Pi );
          DWORD Diffuse1 = 0x00010101 * Fround( 127.0f - 127.0f * Light );
          DWORD Diffuse2 = 0x00010101 * Fround( 15.0f - 15.0f * Light );
          // DWORD Diffuse2 = 0x00010101 * Fround( 31.0f - 31.0f * Light );

          // --- Setup Texture.
          Direct3DDevice->SetTexture( 0, Lyrics[L].Texture );

          // --- Update Lyrics VertexBuffer.
          if ( Lyrics_VertexBuffer1->Lock( 0, 8*sizeof( LYRICS_VERTEX1 ), (BYTE**) &Lyrics_Vertex1, 0 ) == D3D_OK )
            {
              Lyrics_Vertex1[0].Vertex.x = Lyrics[L].ScreenX + Delta;
                Lyrics_Vertex1[0].Vertex.y = Lyrics[L].ScreenY;
                Lyrics_Vertex1[0].Diffuse = Diffuse1;
              Lyrics_Vertex1[1].Vertex.x = Lyrics[L].ScreenX + 256.0f + Delta;
                Lyrics_Vertex1[1].Vertex.y = Lyrics[L].ScreenY;
                Lyrics_Vertex1[1].Diffuse = Diffuse1;
              Lyrics_Vertex1[2].Vertex.x = Lyrics[L].ScreenX + Delta;
                Lyrics_Vertex1[2].Vertex.y = Lyrics[L].ScreenY + 64.0f;
                Lyrics_Vertex1[2].Diffuse = Diffuse1;
              Lyrics_Vertex1[3].Vertex.x = Lyrics[L].ScreenX + 256.0f + Delta;
                Lyrics_Vertex1[3].Vertex.y = Lyrics[L].ScreenY + 64.0f;
                Lyrics_Vertex1[3].Diffuse = Diffuse1;
              
              Lyrics_Vertex1[4].Vertex.x = Lyrics[L].ScreenX - 0.4f * 256.0f + 3.0f * Delta;
                Lyrics_Vertex1[4].Vertex.y = Lyrics[L].ScreenY - 0.4f * 64.0f;
                Lyrics_Vertex1[4].Diffuse = Diffuse2;
              Lyrics_Vertex1[5].Vertex.x = Lyrics[L].ScreenX + 1.4f * 256.0f + 3.0f * Delta;
                Lyrics_Vertex1[5].Vertex.y = Lyrics[L].ScreenY - 0.4f * 64.0f;
                Lyrics_Vertex1[5].Diffuse = Diffuse2;
              Lyrics_Vertex1[6].Vertex.x = Lyrics[L].ScreenX - 0.4f * 256.0f + 3.0f * Delta;
                Lyrics_Vertex1[6].Vertex.y = Lyrics[L].ScreenY + 1.4f * 64.0f;
                Lyrics_Vertex1[6].Diffuse = Diffuse2;
              Lyrics_Vertex1[7].Vertex.x = Lyrics[L].ScreenX + 1.4f * 256.0f + 3.0f * Delta;
                Lyrics_Vertex1[7].Vertex.y = Lyrics[L].ScreenY + 1.4f * 64.0f;
                Lyrics_Vertex1[7].Diffuse = Diffuse2;
              
              Lyrics_VertexBuffer1->Unlock();
             }

          // --- Render.
          Direct3DDevice->SetStreamSource( 0, Lyrics_VertexBuffer1, sizeof( LYRICS_VERTEX1 ));
          Direct3DDevice->DrawPrimitive( D3DPT_TRIANGLESTRIP, 0, 2 );
          Direct3DDevice->DrawPrimitive( D3DPT_TRIANGLESTRIP, 4, 2 );
         }

    // --- Cleanup.
    Direct3DDevice->SetTexture( 0, NULL );

    Direct3DDevice->SetRenderState( D3DRS_ZENABLE, TRUE );
    Direct3DDevice->SetRenderState( D3DRS_ALPHABLENDENABLE, FALSE );
    Direct3DDevice->SetRenderState( D3DRS_SRCBLEND, D3DBLEND_ONE );
    Direct3DDevice->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_ZERO );
   }

void Lyrics_Cleanup( void )
  {
    for ( int L=0; L<LyricsNum; L++ )
      if ( Lyrics[L].Texture ) Lyrics[L].Texture->Release();
    if ( Lyrics_VertexBuffer1 ) Lyrics_VertexBuffer1->Release();
   }