{$N+,A+,G+,F+,D-,E+,L-,R-,S-,Q-,Y-}
{
Classic ROTOZOOMER effect, optimized for 80486, MS-DOS.

A version of the routine with line-by-line rasterization
and an additional texture rotated by 90 degrees
(to compensate for the CPU cache miss issue).

Use Borland Pascal 7.0 (DOS) for compilation this programm ;)

Code: bitl/7dump

}
procedure set60hz;
begin
    port  [$3D4]:= $11;
    port  [$3D5]:= port[$3D5] and $7F;
    port  [$3C2]:= $E3;
    portw [$3D4]:= $0B06;
    portw [$3D4]:= $3E07;
    portw [$3D4]:= $C310;
    portw [$3D4]:= $8C11;
    portw [$3D4]:= $8F12;
    portw [$3D4]:= $9015;
    portw [$3D4]:= $0B16;
end;

procedure HirezTimer(ON:byte);
begin { freq to 1/291.3 sec.}
if ON=1 then
asm
mov al, 34h
out 43h, al
mov al, 4096 and 0ffh  {1193180/freq}
out 40h, al
mov al, 4096 shr 8
out 40h, al
end
else
asm { freq to 1/18.2 sec.}
mov al, 34h
out 43h, al
mov al, 65535 and 0ffh
out 40h, al
mov al, 65535 shr 8
out 40h, al
end;
end;

Procedure WaitVR; Assembler;
ASM
  mov  dx, 3DAh
@w1:
    in   al, dx
    test al, 8h
  jnz  @w1
@w2:
    in   al, dx
    test al, 8h
  jz   @w2
End;

Procedure LoadTga(TgaName:string; size:longint; where:word);
Var
InF: File of byte;
n: word;
pal:array[0..767] of byte;
begin
  Assign(Inf,TgaName);
  Reset(Inf);
  seek(Inf, 18);
  for n:=0 to 767 do read(Inf,pal[n]);
  for n:=0 to size-1 do read(Inf, mem[where:n]);
  Close(Inf);
  port[$3C8]:=0;
  n:=0;
  while n<767 do {set palette}
    begin
      port[$3C9]:=pal[n+2] shr 2;
      port[$3C9]:=pal[n+1] shr 2;
      port[$3C9]:=pal[n]   shr 2;
      n:=n+3;
    end;
end;

procedure Rotozoomer(CenterX, CenterY:integer; Angle, Scale:single; texture, output:word);
var
xr, yr,tcos,tsin, xsin,xcos, ycos, ysin:integer;
y,vdi:word;
begin

Tcos := round(cos(angle)*scale *256);
Tsin := round(sin(angle)*scale *256);

xcos := Tcos*(-centerX);
xsin := Tsin*(-centerX);

ysin := Tsin*(-centerY);
ycos := Tcos*(-centerY);

xr:= xcos + ysin;
yr:= xsin - ycos;

asm
  push ds
  mov es, output
  mov ds, texture

{-----------self-modyfing--------------}
  mov ax, Tsin
  mov bx, Tcos

  imul dx, Tcos, 320 {Tsin - Tcos*15}
  sub ax, dx
  mov cs:[offset @tsin+2], ax

  imul dx, Tsin, 320 {Tcos + Tsin*15}
  add bx, dx
  mov cs:[offset @tcos+2], bx
  jmp @clear_prefetch; @clear_prefetch:
{--------------------------------------}

  mov si, Tsin

  mov vdi, 64000-320-4      -320*4 {< --- vertical align}

  mov cx, xr
  mov dx, yr

  mov y, 192
  @y: {for y:=0 to 191 do begin}

{-----------self-modyfing--------------}
  mov ax, vdi
  mov cs:[offset @di1+4], ax
  sub ax, 4
  mov cs:[offset @di2+4], ax
  jmp @clear_prefetch2; @clear_prefetch2:
{--------------------------------------}

  mov di, 320

  push bp
  mov bp, Tcos

  @x: {for x:=0 to 319 do begin}
      mov bl, ch
      mov bh, dh
      add cx, bp
      add dx, si
      mov ah, ds:[bx]

      mov bl, ch
      mov bh, dh
      add cx, bp
      add dx, si
      mov al, ds:[bx]

      db $66; shl ax, 16

      mov bl, ch
      mov bh, dh
      add cx, bp
      add dx, si
      mov ah, ds:[bx]

      mov bl, ch
      mov bh, dh
      add cx, bp
      add dx, si
      mov al, ds:[bx]

      @di1: db $66; mov es:[di+1234h], ax

      mov bl, ch
      mov bh, dh
      add cx, bp
      add dx, si
      mov ah, ds:[bx]

      mov bl, ch
      mov bh, dh
      add cx, bp
      add dx, si
      mov al, ds:[bx]

      db $66; shl ax, 16

      mov bl, ch
      mov bh, dh
      add cx, bp
      add dx, si
      mov ah, ds:[bx]

      mov bl, ch
      mov bh, dh
      mov al, ds:[bx]
      @di2: db $66; mov es:[di+1234h], ax

      add cx, bp
      add dx, si

      sub di, 8
      jnz @x

  {xr := xr+Tsin;}
  @Tsin: add cx, 1234h
  {yr := yr-Tcos;}
  @Tcos: sub dx, 1234h

  pop bp
  sub vdi, 320

  dec y
  jnz @y
  pop ds
end;
end;


var
timer: Longint ABSOLUTE $0040:$006C;
TextureSeg1, TextureSeg2, frames, T1:word;
PTexture1, PTexture2:pointer;
elapsed_time, old_time, fix_range, output, texture:word;
angle, angle_, scale_speed, rotate_speed, rotate,scale, pi180:real;
SetMode60hz, Vsync:byte;
x,y: integer;

begin

rotate_speed:=0.2;
scale_speed:=0.002;

SetMode60Hz:=0;

Vsync:=0;

GetMem(PTexture1, 65535);
GetMem(PTexture2, 65535);
TextureSeg1:=Seg(PTexture1^);
TextureSeg2:=Seg(PTexture2^);

asm
mov ax, 13h
int 10h
end;
if SetMode60hz=1 then set60hz;{}

LoadTga('pouet.tga', 256*256, TextureSeg1);

{Create copy texture rotated 90 degrees}
for y:=0 to 255 do for x:=0 to 255 do
mem[TextureSeg2:y + x shl 8]:=mem[TextureSeg1:x + (255-y) shl 8];

output:=$a000;
pi180:=pi/180;

frames:=0; T1:=Timer;

fix_range:=45;

angle:=0; frames:=0; T1:=Timer; old_time:=timer;

HirezTimer(1);

repeat
      elapsed_time:=(timer-old_time);
      old_time:=timer;

      angle:=angle+elapsed_time*rotate_speed;
      if angle>360 then angle:=0;

      if ((angle>90-fix_range) and (angle<90+fix_range)) or
         ((angle>270-fix_range) and (angle<270+fix_range)) then
        begin
         angle_:=angle+90;
         texture:=TextureSeg2;
        end
        else begin
         angle_:=angle;
         texture:=TextureSeg1;
        end;

rotate:= (angle_)*pi180;
scale := 1.2+cos(timer * scale_speed)*0.5;

Rotozoomer(160,100, rotate, scale, texture, output);

if Vsync=1 then WaitVR;

Inc(frames);

until port[$60]=1;

HirezTimer(0);

asm
mov ax, 03h
int 10h
end;

T1:=Timer-T1;
WriteLn(Frames/(T1/291.3) :1:2,' Frames per second');

end.