; LZSS Compressed SAP player for 16 match bits
; (c) 2020 DMSC 
;
; Player adapted for own needs by Krystone in 2025
; 
; Buffers: 256 bytes x 9 channels = 2304 bytes total
; Per-frame output: 9 bytes (one per POKEY register)
;
; Caller must define before including:
;   msx_buffers:  256 * 9 byte buffer
;   msx_song_data: compressed song data (ins directive)
;   msx_song_end:  label after song data
;
;	Example:
;
;	mwa #msx_song_end msx_song_end_ptr			; set end pointer for first song
;	mwa #msx_song_data+1 msx_song_start_ptr		; set start pointer for first song
;	mwa #msx_song_data msx_song_mask_ptr		; set mask pointer to first song
;	jsr msx_init

.proc msx_get_byte
	lda msx_song_data
	inc msx_song_ptr
	bne msx_skip
	inc msx_song_ptr+1
msx_skip:
	rts
.endp

msx_song_ptr = msx_get_byte+1

.proc msx_init_song
	mva #>msx_buffers msx_cbuf+2		; reset init buffer pointer to buffers+255
	ldx #8
	ldy #0
msx_clear:
	jsr msx_get_byte
	sta audf1,x
	sty msx_chn_copy,x
msx_cbuf:
	sta msx_buffers+255
	inc msx_cbuf+2
	dex
	bpl msx_clear
	sty msx_bptr
	sty msx_cur_pos
	rts
.endp

.proc msx_init
	mva #$01 msx_bit_data		        ; seed bit reservoir
	mwa #msx_song_data+1 msx_song_ptr	; start stream at byte 1 (mask is byte 0)
	jsr msx_init_song
	rts
.endp

.proc msx_play_frame
	lda #>msx_buffers
	sta msx_bptr+1
	ldy #0
	lda (msx_song_mask_ptr),y			; channel mask (first byte of current stream)
	sta msx_chn_bits
	ldx #8
msx_chn_loop:
	lsr msx_chn_bits
	bcs msx_skip_chn
	lda msx_chn_copy,x
	bne msx_do_copy_byte
	lsr msx_bit_data
	bne msx_got_bit
	jsr msx_get_byte
	sec 								; ensure carry = 1 before ROR to insert a 1 at high bit
	ror
	sta msx_bit_data
msx_got_bit:
	jsr msx_get_byte
	bcs msx_store
	sta msx_chn_pos,x
	jsr msx_get_byte
	sta msx_chn_copy,x
msx_do_copy_byte:
	dec msx_chn_copy,x
	inc msx_chn_pos,x
	ldy msx_chn_pos,x
	lda (msx_bptr),y
msx_store:
	ldy msx_cur_pos
	sta audf1,x
	sta (msx_bptr),y
msx_skip_chn:
	inc msx_bptr+1
	dex
	bpl msx_chn_loop
	inc msx_cur_pos
	rts
.endp

.proc msx_restart_if_end
	lda msx_song_ptr+1
	cmp msx_song_end_ptr+1
	bne msx_rif_wait
	lda msx_song_ptr
	cmp msx_song_end_ptr
	bne msx_rif_wait
	; Song ended; restart the same song
	mva #$01 msx_bit_data					; reset bit reservoir (CRITICAL!)
	mwa msx_song_start_ptr msx_song_ptr
	jsr msx_init_song
msx_rif_wait
	rts
.endp
