	opt l-

.enum	@dmactl
	blank	= %00
	narrow	= %01
	standard= %10
	wide	= %11
	missiles= %100
	players	= %1000
	lineX1	= %10000
	lineX2	= %00000
	dma	= %100000
.ende

scr48 = @dmactl(wide|dma|players|missiles|lineX1)		; screen 48b
scr40 = @dmactl(standard|dma|players|missiles|lineX1)	; screen 40b
scr32 = @dmactl(narrow|dma|players|missiles|lineX1)		; screen 32b

.enum	@pmcntl
	missiles= %1
	players	= %10
	trigs	= %100
.ende

.enum	@gtictl
	prior0	= %0
	prior1	= %1
	prior2	= %10
	prior4	= %100
	prior8	= %1000
	ply5	= %10000		; Fifth Player Enable
	mlc		= %100000		; Multiple Color Player Enable
	mode9	= %01000000
	mode10	= %10000000
	mode11	= %11000000
.ende

* -------	OS

ramlo	=	$04		; (2) RAM vector for the memory size test
warmst	=	$08		; warm start flag
boot?	=	$09		; boot pre-read flag
dosvec	=	$0A		; (2) disk program start vector
dosini	=	$0C		; (2) initialization vector after disk load
rtclok	=	$12		; (3) real-time clock
lmargin	=	$52
rmargin	=	$53
rowcrs	=	$54		; cursor row
colcrs	=	$55		; (2) cursor column
keydef	=	$79		; (2) keyboard code to ATASCII conversion table
vdslst	=	$0200	; (2) display list NMI vector
timcnt3	=	$021C	; third system timer
vvblki	=	$0222	; (2) immediate VBI NMI vector
vvblkd	=	$0224	; (2) deferred VBI NMI vector
timflg3	=	$022a	; flag set when TIMCNT3 resets

colpf0s	=	$02C4	; shadow register COLPF0
colpf1s	=	$02C5	; shadow register COLPF1
colpf2s	=	$02C6	; shadow register COLPF2
colpf3s	=	$02C7	; shadow register COLPF3
colbaks	=	$02C8	; shadow register COLBAK

dsctln	=	$02D5	; (2) Disk sector size register; default of 128 ($80) bytes
dvstat	=	$02EA	; (4) device status

crsinh	=	$02F0	; cursor visibility flag
chact	=	$02F3	; shadow register CHRCTL
chbas	=	$02F4	; shadow register CHBASE

atachr	=	$02Fb	; color number for PLOT/DRAW (ATASCII of the character)
kbcodes	=	$02Fc	; code of the last key pressed; $ff if none (KBCODE)
fildat	=	$02Fd	; color number for FILL
chart	=	$02F3	; shadow of the character display control register (CHRCTL)

ddevic	=	$0300	; Device Control Block, device identifier
dunit	=	$0301	; Device number; for disk drives the drive number
dcmnd	=	$0302	; Command for the device
dstats	=	$0303	; Before calling SIO set the operation type here ($40 read, $80 write, $C0 write+read, $00 no data transfer); on return it holds the operation status (error code)
dbufa	=	$0304	; (2) Buffer address; for simultaneous read/write (DSTATS = $C0) the read buffer shares the same location as the write buffer
dtimlo	=	$0306	; Device response timeout; usually 7
dunuse	=	$0307	; Unused byte reserved for future use
dbyt	=	$0308	; (2) Buffer size; must match the transmitted block size; zero means 64 KB
daux1	=	$030A	; First auxiliary byte; for disks, low byte of sector number
daux2	=	$030B	; Second auxiliary byte; for disks, high byte of sector number
casflg	=	$030F	; When set to zero, the current operation is a standard SIO operation; when non-zero, it is a cassette operation

hatabs	=	$031A	; handler vector table

iocb	=	$0340	; IOCB 0..7 ($340, $350, $360 ...)
iocom	=	iocb+2	; Command for IOCB
ioadr	=	iocb+4	; (2) Buffer address for IOCB
ioaux1	=	iocb+10	; Auxiliary byte 1 for IOCB
ioaux2	=	iocb+11	; Auxiliary byte 2 for IOCB

icchid	=	$0340
icdno	=	$0341

iccmd	=	$0342	; command code for I/O operation
icstat	=	$0343	; status of I/O operation
icbufa	=	$0344	; (2) data buffer address for I/O
icputb	=	$0346	; (2) address of data transfer routine
icbufl	=	$0348	; (2) length of data buffer for I/O
icax1	=	$034A	; auxiliary register for I/O
icax2	=	$034B	; auxiliary register for I/O
icax3	=	$034C	; auxiliary register for I/O
icax4	=	$034D	; auxiliary register for I/O
icax5	=	$034E	; auxiliary register for I/O
icax6	=	$034F	; auxiliary register for I/O

casbuf	=	$0400	; cassette buffer
casben	=	$047F	; end of cassette buffer

setvbv	=	$E45C
xitvbv	=	$E462
ciov	=	$E456	; vector to CIOMAIN
jsioint	=	$E459	; vector to SIO
jdskint	=	$E453	; vector to disk driver

* -------	KEY ($d209)

key_esc		= 28
key_space	= 33

key_a		= 63
key_b		= 21
key_d		= 58
key_m		= 37
key_n		= 35
key_v		= 16
key_o		= 08
key_p		= 10
key_s		= 62
key_w		= 46

* -------	GTIA

hposp0	=	$D000	; horizontal position of player 0 (W)
hposp1	=	$D001	; horizontal position of player 1 (W)
hposp2	=	$D002	; horizontal position of player 2 (W)
hposp3	=	$D003	; horizontal position of player 3 (W)
hposm0	=	$D004	; horizontal position of missile 0 (W)
hposm1	=	$D005	; horizontal position of missile 1 (W)
hposm2	=	$D006	; horizontal position of missile 2 (W)
hposm3	=	$D007	; horizontal position of missile 3 (W)
sizep0	=	$D008	; horizontal size of player 0 (W)
sizep1	=	$D009	; horizontal size of player 1 (W)
sizep2	=	$D00A	; horizontal size of player 2 (W)
sizep3	=	$D00B	; horizontal size of player 3 (W)
sizem	=	$D00C	; horizontal size of missiles (W)
grafp0	=	$D00D	; graphics data for player 0 (W)
grafp1	=	$D00E	; graphics data for player 1 (W)
grafp2	=	$D00F	; graphics data for player 2 (W)
grafp3	=	$D010	; graphics data for player 3 (W)
grafm	=	$D011	; graphics data for missiles (W)
colpm0	=	$D012	; color register for player/missile 0 (W)
colpm1	=	$D013	; color register for player/missile 1 (W)
colpm2	=	$D014	; color register for player/missile 2 (W)
colpm3	=	$D015	; color register for player/missile 3 (W)
colpf0	=	$D016	; playfield color register 0 (W)
colpf1	=	$D017	; playfield color register 1 (W)
colpf2	=	$D018	; playfield color register 2 (W)
colpf3	=	$D019	; playfield color register 3 (W)
colpf4	=	$D01A
colbak	=	$D01A	; background color register (W)

color0	=	colpf0
color1	=	colpf1
color2	=	colpf2
color3	=	colpf3

kolm0pf	=	$D000	; missile 0 vs playfield collision (R)
kolm1pf	=	$D001	; missile 1 vs playfield collision (R)
kolm2pf	=	$D002	; missile 2 vs playfield collision (R)
kolm3pf	=	$D003	; missile 3 vs playfield collision (R)
kolp0pf	=	$D004	; player 0 vs playfield collision (R)
kolp1pf	=	$D005	; player 1 vs playfield collision (R)
kolp2pf	=	$D006	; player 2 vs playfield collision (R)
kolp3pf	=	$D007	; player 3 vs playfield collision (R)
kolm0p	=	$D008	; missile 0 vs player collision (R)
kolm1p	=	$D009	; missile 1 vs player collision (R)
kolm2p	=	$D00A	; missile 2 vs player collision (R)
kolm3p	=	$D00B	; missile 3 vs player collision (R)
kolp0p	=	$D00C	; player 0 vs player collision (R)
kolp1p	=	$D00D	; player 1 vs player collision (R)
kolp2p	=	$D00E	; player 2 vs player collision (R)
kolp3p	=	$D00F	; player 3 vs player collision (R)
trig0	=	$D010	; joystick 0 trigger state (R)
trig1	=	$D011	; joystick 1 trigger state (R)
trig3	=	$D013	; cartridge detect flag (R)
pal	=		$D014	; TV system flag (R) PAL = 1, NTSC = 15

gtictl	=	$D01B	; GTIA control register
gtiactl	=	gtictl

vdelay	=	$D01C	; vertical delay counter for players/missiles
pmcntl	=	$D01D	; player/missile control register
hitclr	=	$D01E	; collision register clear
consol	=	$D01F	; console key status

* -------	POKEY

irqens	=	$0010	; shadow register IRQEN
irqstat	=	$0011	; shadow register IRQST

audf1	=	$d200	; frequency divider for channel 1 (W)
audc1	=	$d201	; audio control for channel 1 (W)
audf2	=	$d202	; frequency divider for channel 2 (W)
audc2	=	$d203	; audio control for channel 2 (W)
audf3	=	$d204	; frequency divider for channel 3 (W)
audc3	=	$d205	; audio control for channel 3 (W)
audf4	=	$d206	; frequency divider for channel 4 (W)
audc4	=	$d207	; audio control for channel 4 (W)

audctl	=	$D208	; sound generator control register (W)
stimer	=	$D209	; strobe to reset timers (W)
kbcode	=	$D209	; code of the last key pressed (R)
skstres	=	$D20A	; serial status reset register (W)
random	=	$D20A	; random number register (R)
serout	=	$D20D	; serial output register (W)
serin	=	$D20D	; serial input register (R)
irqen	=	$D20E	; IRQ enable register (W)
irqst	=	$D20E	; IRQ status register (R)
skctl	=	$D20F	; serial port control register (W)
skstat	=	$D20F	; serial port status register (R)

* -------	PIA

porta	=	$D300	; PIA port A
portb	=	$D301	; PIA port B
pactl	=	$D302	; port A control register
pbctl	=	$D303	; port B control register

* -------	ANTIC

dmactl	=	$D400	; DMA control register
chrctl	=	$D401	; character display control register
dlptr	=	$D402	; ANTIC display list pointer
hscrol	=	$D404	; horizontal scroll register
vscrol	=	$D405	; vertical scroll register
pmbase	=	$D407	; player/missile base address
chbase	=	$D409	; character set base address
wsync	=	$D40A	; wait for horizontal sync strobe
vcount	=	$D40B	; vertical line counter
lpenh	=	$D40C	; light pen horizontal position
lpenv	=	$D40D	; light pen vertical position
nmien	=	$D40E	; NMI enable register
nmist	=	$D40F	; NMI status register

* -------	HARDWARE

nmivec	=	$FFFA	; NMI interrupt vector
resetvec=	$FFFC	; RESET interrupt vector
irqvec	=	$FFFE	; IRQ interrupt vector

	opt l+
