; Vintage Computing Christmas Challenge 2025 - v2
; Jose Moreno Prieto 'Xeleh' - 03/12/2025

main:
            org     100h
            mov     dh,-9           ; initial row
.row        mov     dl,-9           ; initial column
.col        cmp     dl,9            ; right side overflow?
            jg      .space          ; yes -> print space
            test    dl,dl           ; central column?
            je      .star           ; yes -> print * char
            test    dh,dh           ; central row?
            je      .star           ; yes -> print * char
            mov     al,dh           ; al = row
            imul    dh              ; al = row * row
            mov     cl,al           ; cl = row * row
            mov     al,dl           ; al = column
            imul    dl              ; al = column * column
            mov     bh,al           ; bh = column * column
            add     al,cl           ; al = (col * col) + (row * row)
            js      .space          ; if diagonal excedent -> print space
            cmp     cl,bh           ; diagonal?
            je      .star           ; yes -> print * char
            mov     di,data         ; set data pointer
            mov     cl,end-data     ; set data length
            repne   scasb           ; find determinant in data
            je      .star           ; found? -> print * char
.space      mov     al,' '          ; space char
            jmp     .print          ; print
.star       mov     al,'*'          ; '*' char
.print      int     29h             ; print char in al
            inc     dl              ; next column
            cmp     dl,80-9         ; end column?
            jne     .col            ; no -> loop
            inc     dh              ; next row
            cmp     dh,9+1          ; end row?
            jne     .row            ; no -> loop

%ifdef      debug
            waitkey
            ret
%endif

data        db      17,29,50,61,68,74
end: