; Coded on Samichlaus day 2025 by Saturnus the Invincible of
; The Mega-Mighty Swiss Cracking Association. Code size = 64
; 1) Drag .prg to VICE      2) Clear screen       3) SYS 270

		ORG	$F7		; unused top of zero page

TMP		EQU	2
PNT		EQU	$D1		; pointer to current line
SETPNT		EQU	$E9F0		; set PNT to screen line X

CENTER_X	EQU	19
CENTER_Y	EQU	10		; don't change


CRYSTALLISE
MOD_Y1		LDX	#CENTER_Y	; moves upwards
		JSR	GROW
MOD_Y2		LDX	#CENTER_Y	; moves downwards
GROW		JSR	SETPNT		; preserves Y
		LDA	#'*'		; snowflake!
		STA	(PNT),Y
		RTS

Y_LOOP		LDY	#CENTER_X+8	; Y is our x-axis
X_LOOP		LSR	FLAKE+9		; get next bit of flake pattern
		BCS	NO_SNOW

		DFB	$2C		; BIT $XXXX: ignore next LDY

	; Entry point

MAIN		LDY	#CENTER_X+9	; center line is wider than the rest
		JSR	CRYSTALLISE	; from right to middle
		STY	TMP
		LDA	#CENTER_X+19+1	; +1 because carry is clear
		SBC	TMP
		TAY
		JSR	CRYSTALLISE	; from left to middle
		LDY	TMP
NO_SNOW
		DEY
		CPY	#CENTER_X
		BPL	X_LOOP

		DEC	X_LOOP+1
		INC	MOD_Y2+1	; one line down
		DEC	MOD_Y1+1	; one line up
		BNE	Y_LOOP

		RTS


	; A quarter of the snowflake as an inverted bit field
	; to get the vertical line for free by shifting out "bit 9"

FLAKE		DFB	%11111111	; Hurra, Hurra, Flake!
		DFB	%10111111
		DFB	%01110101
		DFB	%11110011
		DFB	%10110001
		DFB	%01101111
		DFB	%11011111
		DFB	%10110110
		DFB	%01101101

	; The byte at $137 is nomally 0, so we don't need to include
	; it in our file. This brings the total code size to 64 bytes.
	;	DFB	%00000000
