;         *
;       * * *    
;  * *   ***   * *
;   **    *    **
;  ***  * * *  ***     
;     *  ***  *
;      *  *  *
; *  *  * * *  *  *
;  *  *  ***  *  *
;*******************
;  *  *  ***  *  *
; *  *  * * *  *  *
;      *  *  *
;     *  ***  *
;  ***  * * *  ***     
;   **    *    **
;  * *   ***   * *
;       * * *    
;         *

; =============================================================================
; Vintage Computing Christmas Challenge 2025 (VCCC 2025)
; Z80 assembly for Amstrad CPC - Snowflake
; works with pasmo or winape
; size. 77 bytes
; author. issalig
; =============================================================================
;write "vc3.bin"
        ORG     #8000

PRINT_CHAR      EQU     #BB5A

START:
        ; Initialize Y counter to -9 (Top of the grid)
        LD      C, -9                  

Y_LOOP:
        ; Initialize X counter to -9 (Left of the grid)
        LD      B, -9                  

X_LOOP:
        ; --- 1. Calculate Absolute Coordinates for Symmetry ---
        ; The snowflake is symmetric. We map (-9..9) to (9..0..9).
        ; This allows us to store data for only one quadrant.
        
        LD      A, C
        CALL    ABS
        LD      E, A                   ; E = ABS(Y) = Row Index (0-9)

        LD      A, B
        CALL    ABS
        LD      D, A                   ; D = ABS(X) = Column Index (0-9)

        ; --- 2. The Center Cross Rule ---
        ; If we are on the X axis (Y=0) or Y axis (X=0), always print '*'
        
        ; Check if D (ABS(X)) is zero
        OR      A                      ; A currently holds D from previous block
        JR      Z, STAR                ; If X=0, jump to print star
        
        ; Check if E (ABS(Y)) is zero
        LD      A, E
        OR      A                      
        JR      Z, STAR                ; If Y=0, jump to print star

        ; --- 3. Data Lookup ---
        ; We need to check the pattern for the current row E.
        ; DATA_TABLE stores patterns for rows 1 to 9.
        ; We calculate address HL = DATA_TABLE + (E - 1)
        
        LD      HL, DATA_TABLE-1       ; Base address minus 1
        ADD     A, L                   ; Add E (in A) to L
        LD      L, A                   ; HL now points to the byte for this row

        ; --- 4. Bitmask Generation ---
        ; We need to check if the bit corresponding to column D is set.
        ; We generate a mask 2^(D-1) efficiently.
        ; Example If D=1, mask=1. If D=3, mask=4.
        
        XOR     A                      ; A = 0
        SCF                            ; Set Carry Flag = 1
SHIFT:  ADC     A, A                   ; Shift Left Bit 0 gets Carry (1), others 0
        DEC     D                      ; Loop D times
        JR      NZ, SHIFT
        ; Now A contains the bitmask (e.g., 00000100)

        ; --- 5. Pixel Decision ---
        AND     (HL)                   ; Check if the bit is set in the data byte
        LD      A, ' '                 ; Default to Space
        JR      Z, PRNT                ; If result is 0, print Space
STAR:   LD      A, '*'                 ; Otherwise, load Star

PRNT:   CALL    PRINT_CHAR             ; Print the character

        ; --- 6. Loop Control (X Axis) ---
        INC     B                      ; Move to next column
        LD      A, B
        CP      10                     ; Have we reached the end (+9)?
        JR      NZ, X_LOOP             ; If not, continue row

        ; --- 7. Newline ---
        ;LD      A, 10                  ; LF (Line Feed) not needed as after CP 10 A is 10
        CALL    PRINT_CHAR
        LD      A, 13                  ; CR (Carriage Return)
        CALL    PRINT_CHAR

        ; --- 8. Loop Control (Y Axis) ---
        INC     C                      ; Move to next row
        LD      A, C
        CP      10                     ; Have we reached the bottom (+9)?
        JR      NZ, Y_LOOP             ; If not, continue grid

        RET

; --- Helper Function Absolute Value ---
; Input A (signed 8-bit)
; Output A (positive 8-bit)
ABS:    OR      A                      ; Update flags based on A
        RET     P                      ; Return if Positive (Sign bit clear)
        NEG                            ; Negate (Two's complement) if Negative
        RET

; --- Data Table ---
; Bit patterns for rows 1 to 9 (Row 0 is handled by logic).
; Each bit represents a star position.
; 73 = 01001001 -> Stars at positions 1, 4, 7

DATA_TABLE:
        DB      73, 146, 4, 9, 114, 48, 81, 2, 0

        END