//
// (c)MX^Addict
//
// Brotli dictionary reference:
// https://gist.github.com/duskwuff/8a75e1b5e5a06d768336c8c7c370f0f3#file-dictionary-bin-L7147
//

// #version 430

///////////////////////////////////////////////////////////////////////////////////////////////////

#ifdef __SHADERTOY
float t;
vec2  _gl_PointCoord;
vec3  o;

void smain();
void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    _gl_PointCoord = (vec2(fragCoord.x, iResolution.y-fragCoord.y) / iResolution.xy);
    o              = vec3(0.0);
    t              = iTime;

	smain();

    fragColor.xyz  = o;
    return;
}

#define gl_PointCoord _gl_PointCoord
#define main          smain
#else

uniform float t;
out vec3 o;

#endif

///////////////////////////////////////////////////////////////////////////////////////////////////

float Time, Dist, Fog;

mat2 r2(float a)
{ 
    float c = cos(a), s = sin(a); 
    return mat2(c, s, -s, c); 
}

float sdSmoothUnion(float d1, float d2, float k)
{
    float h = clamp(0.5 + 0.5 * (d2 - d1) / k, 0.0, 1.0);
	return mix(d2, d1, h) - k * h * (1.0 - h);
}

// Scene
float df(vec3 p)
{
    float i, s;
    float tor = 1e6;
    for (i = 0.0; i < 8.0; i++)
    {
        s   = sin(Time + i) * 0.5 + 1.0;
        tor = sdSmoothUnion(tor, length(vec2(length(vec2(p.y + sin(0.32 * Time + i * 1.2) + 0.5, p.z + sin(0.51 * Time + i * 1.1) * 3.0)) - s * 0.5, (p.x + sin(0.15 * Time + i * 1.3) * 3.0) + sin(2.0 * Time + i))) - s, 1.5) + (sin(2.0 * p.x + Time) * cos(p.y + Time)) * 0.1 - 0.1;			
    }
    
	// Composition
    return sdSmoothUnion(sdSmoothUnion(sdSmoothUnion(abs(dot(sin(p), cos(p.zxy))) - 0.5, tor - 0.5, -0.2), -tor, -0.2) + ((asin(sin(p.x * 50.0)) + asin(sin(p.y * 90.0)) + asin(sin(p.z * 50.0))) * 0.005), p.y+1.0 + sin(dot(p.xz, p.zx) * 0.5 + Time) * 0.01, 0.5);    
}

vec3 render(vec3 rayOrg, vec3 rayDir, out vec3 v)
{
    vec3 eps = vec3(0.005, 0.0, 0.0);
    vec3 p   = rayOrg;
    
    // Cast DF
	for (Dist = 0.; eps.z++ < 200. && Dist < 50.0; Dist+= df(p) * 0.5,p = rayOrg + rayDir * Dist);

    // Calculate normal
    eps.z = df(p);
    v     = normalize(vec3(eps.z - df(p - eps.xyy), eps.z - df(p - eps.yxy), eps.z - df(p - eps.yyx)));

    // Calculate final mix   
    return (mix(vec3(0.5, 0.0, 0.2), vec3(0.6, -0.1, -0.3), pow(dot(v, rayDir), 2.0)) + mix(vec3(0.5, 0.3, 0.5), vec3(2.0, 0.5, 0.7), pow(dot(v, rayDir), 7.0))) *  // Color
            pow((.1*(v.x*v.x-v.y*v.y)+.7*-.15*v.z*v.z+.7-.26*-.15+.84*-.11*v.x*v.y+.4*v.x*v.z+.84*-.3*v.y*v.z+-.3*v.x+.4*v.y+-.3*v.z), 2.0);                        // Lighting
}

// Entry
void main()
{
    // Time & UV
          Dist = t * 0.5;
          Time = Dist + sin(Dist * 0.5);
    vec3  uv   = vec3((gl_PointCoord - 0.5) * 2.0, 0.0);

    // Camera track & transform
    vec3 rayOrg     = vec3(5.0, 1.5 + sin(Dist) * 2.0, 7.0);
         rayOrg.xz *= r2(cos(Dist) * 0.5);
         rayOrg.xz *= r2(floor(Dist * 0.5) * 5.0);

	vec3 axisZ      = normalize(vec3(0.5, 0.5 + sin(Dist) * 0.25, 0.0) - rayOrg);
	vec3 rayDir     = (axisZ + uv.x * vec3(-axisZ.z, 0,axisZ.x) +  uv.y * cross(axisZ, vec3(-axisZ.z, 0,axisZ.x)));
    vec3 normal;

    o       = render(rayOrg, rayDir, normal);
    Fog     = min(1.0, 0.1 * Dist);
    rayOrg += rayDir * Dist + normal * 0.005;
    o       = mix(mix(render(rayOrg, reflect(rayDir, normal), normal).yzx, o, clamp(rayOrg.y + Dist * 0.15, 0.75, 1.0)), vec3(0.3, 0.5, 0.6) * dot(rayDir, rayDir) + pow(fract(t*0.25),5.0), Fog*Fog);
    o      *= o;
}
