/*
 * Decompiled with CFR 0.152.
 */
package org.kd.anniversaries;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.audio.Music;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import java.util.ArrayList;
import java.util.List;
import org.kd.anniversaries.Scene1c64;
import org.kd.common.C64Helper;

public abstract class Year {
    public static final long DEFAULT_DURATION = 600L;
    protected final List<String> messages;
    protected final BitmapFont zxSpectrumFont;
    protected final BitmapFont c64Font;
    protected final String statementPath;
    protected final long startingFrame;
    protected long endFrame;
    private boolean alreadySaid = false;
    private final Music statement;

    protected Year(String statementPath, long startingFrame) {
        this.startingFrame = startingFrame;
        this.endFrame = this.startingFrame + 600L;
        this.statementPath = statementPath;
        this.statement = Gdx.audio.newMusic(Gdx.files.internal(statementPath));
        this.zxSpectrumFont = C64Helper.createFont(32, "zx-spectrum.ttf");
        this.c64Font = C64Helper.createFont(15, "C64_Pro_Mono-STYLE.ttf");
        this.messages = new ArrayList<String>(1);
    }

    public void sayItOnce() {
        if (!this.alreadySaid) {
            this.statement.play();
            this.alreadySaid = true;
        }
    }

    public void writeMessage(SpriteBatch batch, String message, float x, float y) {
        this.c64Font.draw((Batch)batch, message, x, y);
    }

    abstract void draw(long var1, Scene1c64 var3);

    public long getStartingFrame() {
        return this.startingFrame;
    }

    public long getEndFrame() {
        return this.endFrame;
    }
}

