; Speccy 53c ATR (SCR) Viewer on BK0010. 
; Pal, bits 7..0: Blink / Bright / 3x BG / 3x FG. Color components, bits 0..2: BRG


	br Start
RndEnum:.word 0
Rnd=.+1		; Full-range RND (12dw)
	clr r0
RndMsk=.+1	; Masked RND
	mov r0,-(r6)	; Mask
	mov #RndEnum,r0	; Std enumerator
	asl (r0)	; Shift Selected enumerator
	beq 0
	bcc 1		; Carry out - activate invertors
0:	xor r7,(r0)	; Inversion
1:	mov (r0),r0	; out new RND itteration	!!!    1:    533(10)
	bic (r6)+,r0
Exit:	mov (r6)+,r7
Start:
	tst @#122	; Args > 0
	bne 0
	mov #DefList,r0
	call @#LdFile
	beq NewList	; Show Default List
	mov #Hello,r1	; print 'Hello'
	clr r2
	emt 20
0:	clr r0		; Get FileName from Kbd Input
NextLd:	call @#LdFile
	bne Next	; Next for List or Exit for single File
ChkExt:	mov #346,r1	; Ext. check
	mov #ExtList,r2	; Knowing exts
0:	cmpb #32.,-(r1)	; Skip all < '!'
	bcc 0
	inc r1
;	clr r4		; Type No	       
Ext2Chk:
	mov r1,r3	; ext parse
0:	movb -(r3),r0	; next char
	cmpb #32.,r0	; < '!'
	bcc 2		; Mismatch
	cmpb #96.,r0	; from 'a'
	bcc 1
	cmpb #122.,r0	; till 'z'
	bcs 2		; Mismatch
	bic #177440,r0	; to Caps
1:	cmpb r0,(r2)+
	bne 2		; Mismatch
	cmpb #46.,r0	; '.'
	bne 0
	br NewList
2:	cmpb #46.,(r2)+	; search '.' - feed to next Ext
	bne 2
;	inc r4		; Type No	       
	cmp #ExtListEnd,r2
	bpl Ext2Chk
		; No List File
	mov #768.,r4
	cmp @#266,r4	; Check ATR: Size=768
	beq Prepare
	cmp @#266,#6912.; Check SCR: Size=768+32*24*8
	bne Next
	mov @#264,r1	; Remove graphics
	mov r1,r2
	add #6144.,r2
3:	movb (r2)+,(r1)+; mov Attribs to the begin of the file
	sob r4,3
Prepare:	; Prep. color schema
	mov @#LdAddr,r1		; Src Attribs
	mov #PttAddr,r2		; Dst Addrs
	mov #BlinkMod,r3	; Blink Modify Bf
	mov #1400,r4		; 768 Attribs
0:	movb (r1)+,r0		; Get color attribute
		; Conv. an Attrib byte R0 to Pattern Addr R0
	mov r0,-(r6)		; store Blink Flag
	bic #177600,r0		; just 7 bits
	swab r0			; x32
	asr r0
	asr r0
	asr r0
	mov r0,r5		; Blink Mod
	add #Patterns+40,r0
	mov r0,(r2)+		; Store Pattern Addr
	tstb (r6)+		; Get Blink Flag
	bmi 1 			; no Blink
	clr r5
1:	movb r5,(r3)+		; Blink Mod
	sob r4,0

ViewLp:	mov (r7)+,(r7)+	; Copy DefTime to CurTime
DefTime:.word 0
CurTime:.word 0
RepView:call @(r7)+	; View proc by format
ViewPrc:.word View53c
	dec @#CurTime
	bmi ViewLp
	bne RepView
Next:	mov (r7)+,r0	; Next FileName in Slides List
ListPos:.word DataArea
	movb (r0),r1	; Get Time
	bne 0
	ret		; Exit
0:	bic #177417,r1
	sub #16.,r1
	beq NextLd	; Use Default / Prev Time
	; Time mod here
	mov r1,@#DefTime 
;MainLp:
	br NextLd
ListDone:
	asr r1		; Align Up
	adc r1
	asl r1
	mov r1,@#LdAddr
	br Next

NewList:	;   ,   
	tst @#DefTime	; Set Time to show files from List
	bne 0
	mov #160.,@#DefTime
0:	mov #DataArea,r1	; Set List 
	mov r1,@#ListPos
	mov @#264,r2	; Addr of Loaded List
	inc @#266	; List Len
	clr r5		; Mode: New Item
ParseList:
;while r2<r3:
	dec @#266	; List Len
	beq Item	; Set Last Item and End
	bmi ListDone
;  if r5==0:		# New Item, R5  0,   
;    r4,r5,s[r1],p,r1=r1,1,0,0,r1+1
	tst r5
	bne GetChr
	mov r1,r3	; ~ Item Len
	mov r1,r4	; Len var Addr
	mov #BefItem,r5
	clrb(r1)+	; Len var
;  r0,r2=bf[r2],r2+1	# Get Chr
GetChr:	clr r0
	bisb (r2)+,r0
	mov r5,r7	; Jump Mode
;  if r5==1:		# Skip spaces at begin
;    if r0>32:
;      r5=2 #  
BefItem:cmp #32.,r0
	bpl ParseList
	mov #ChkName,r5
;  if r5==2:		# Probably File Name
ChkName:
;    if r0==44:		# Timer
;      r5,t=3,0 #  
	cmp #44.,r0
	bne Chk0
	clr @#DefTime
ChkTL:	mov #GetTime,r5
	br ParseList
;    elif r0==35:	# Comment
;      r5=4 #  
Chk0:	cmp #35.,r0
	bne Chk1
ChkCL:	mov #Comment,r5
	br ParseList
;    elif r0<32:		# EOL
;      r5=5 #  
;    elif r0==32:	# Spaces in name?
;      pass
Chk1:	cmp #32.,r0
	beq 0
	bpl Item
;    else:
;      p,r1,s[r1]=r1,r1+1,r0	# Text
	mov r1,r3	; ~ Len
0:	movb r0,(r1)+	; Item FileName
	br ParseList
;  if r5==3:		# Get Time
;    if (r0<48)or(r0>57):
;      r5=4 #  .   
;    else:
;      t=t*10+r0-48
GetTime:sub #48.,r0	; < 48 ? !!! *16
	bmi ChkCL
	cmp #9.,r0	; > 57 ? !!! *16
	bmi ChkCL
	asl r0
	asl r0
	asl r0
	asl r0
	asl @#DefTime
	mov @#DefTime,r5
	asl r5
	asl r5
	asl r5
	asl r5
	add r0,r5
	add r5,@#DefTime
	br ChkTL
;  if r5==4:		# Comment
;    if r0<32:
;      r5=5 #  ?
Comment:cmp #31.,r0	; Comment While Text
	bmi ParseList
;  if r5==5:
;    if p==0:
;      r1=r4
;    else:
Item:	sub r4,r3	; Len = 0 ? No Name data
	bne 0
	mov r4,r1	; Reset Dst Pos
	br 3
;      if p>16:
;        p=16
;      s[r4]=p-1 #+t
0:	cmp #16.,r3
	bpl 1
	mov #16.,r3
1:	dec r3		; Len-1
	tstb @#DefTime+1
	beq 2
	mov #240.,r5
	mov r5,@#DefTime
2:	mov @#DefTime,r5
	add r5,r3
	movb r3,(r4)
;    r5=0
3:	clr r5
	br ParseList

;------ subs -----------------

LdFile:	mov #320,r1		; Tape param. block
	mov r1,r3
	mov #3,(r3)+		; Cmd: Load File
	mov @#LdAddr,(r3)+	; Load Addr
	clr (r3)+		; Len
	tst r0			; Src = Kbd
	bne 0
	mov r1,r5
	mov r3,r1
	mov #5020,r2		; 16 chr, Enter
	emt 10
	mov r1,r3
	mov r5,r1
	tst r2
	beq 4			; all 16 chr
	dec r3
	br 2
0:	movb (r0)+,r2		; Len-1 + Time*16
	bic #-20,r2
	inc r2
1:	movb (r0)+,(r3)+
	sob r2,1
	mov r0,@#ListPos
	br 3
2:	movb #40,(r3)+		; Fill with spaces
3:	cmp #345,r3
	bpl 2
4:	emt 36			; File I/O
	tstb @#321		; Err code
	ret

View53c:
	mov @#Ptn2Gen,r0
0:	call @#PtnGen
	sob r0,0
	mov #1,@#Ptn2Gen
	incb @#Scroll
	incb @#Scroll
	mov (r7)+,@(r7)+	; Roll Screen
Scroll:	.word 1320,177664
	add #200,@#Line1
	bpl 0
	mov #40000,@#Line1
0:	mov (r7)+,r1		; 1st line
Line1:	.word 37600
	mov #PttAddr,r2		; Src
	mov #25.,r5		; Image 32x24 + Border
;  	clr r0
	mov #100,r4
0:	mov r0,(r1)+
	sob r4,0
	mov #37,r0		; test & roll
	sub #100,r1
	br 4
1:	mov #32.,r4
2:	mov (r2),r3		; Pattern Addr
	mov -(r3),(r1)+		; Get Pattern from End to Begin
	mov -(r3),76(r1)
	bit r0,r3		; Wrap around
	bne 3
	add #40,r3
3:	mov r3,(r2)+
	sob r4,2
4:	add #1100,r1		; Y-delta
	bpl 5
	sub #40000,r1
5:	sob r5,1
	dec (r7)+
BlnkCnt:.word 10
	bpl 1
	mov #10,@#BlnkCnt
	mov #PttAddr,r1
	mov #BlinkMod,r2
	mov #1400,r3
0:	clr r4
	bisb (r2)+,r4
	xor r4,(r1)+
	sob r3,0
1:	mov (r6)+,r7

PtnGen:		; Regenerate next Pattern
	mov r5,-(r6)
	mov r4,-(r6)
	mov r3,-(r6)
	mov r2,-(r6)
	mov r1,-(r6)
	mov r0,-(r6)
	clr r0
	mov (r7)+,r1		; Pattern Addr
PtnUpd:	.word Patterns
	mov #20,r2
	mov r1,r3
0:	mov r0,(r3)+		; Clear Pattern & get next Pattern
	sob r2,0
	mov (r7)+,r2
AttrN:	.word 0
	incb @#AttrN
	bpl 1
	clr @#AttrN
	mov #Patterns,r3	; Attrib=0
1:	mov r3,@#PtnUpd
	mov #ColCnt,r3
	mov #6,r5
2:	movb (r3)+,r4		; ZX Color bit costs
	asr r2
	bcc 3
	add r4,r0		; 3-bit High-color RGB value
3:	sob r5,2
	asr r2
	bcc 4
	asl r0
4:		; Draw pixels: 
	mov #1403,r2	; Color in Loop: lo()=Color, hi()=CheckMask=3
	mov r0,-(r6)	; pixels Counters
	mov r2,r3
	br 6
5:	mov (r6),r0
	asr r0
	asr r0
	asr r0
	mov r0,(r6)
6:	bic #-10,r0	; Pixels to Draw
	movb PxCnt(r0),r5
	beq 10
	clr r4
7:	mov #-10,r0	; Step in bytes, 0..7
	call @#RndMsk
	inc r0
	sub r0,r4
	bpl 8
	add #40,r4
8:	mov r1,r0
	add r4,r0
	bitb r3,(r0)	; Empty?
	bne 7
	swab r3
	bisb r3,(r0)	; Pixel
	asl r3
	asl r3
	bcc 9
	mov r2,r3
9:	swab r3
	sob r5,7
10:	decb r2		; Next Color
	bne 5
	tst (r6)+
	mov (r6)+,r0
	mov (r6)+,r1
	mov (r6)+,r2
	mov (r6)+,r3
	mov (r6)+,r4
	mov (r6)+,r5
	mov (r6)+,r7

;-----------------------------
Ptn2Gen:.word 200
ColCnt:	.byte 100,1,10,100,1,10		; Color Cost: BRG => BGR in type: 0-1-2-4
Hello:	.byte 214,214
	.asciz /53c Viewer v1/<12>/File Name:/
PxCnt:	.byte 0,20.,30.,0,42.		; Gamma correction: Counters for 0-1-2-(3)-4-(5). * 3 & 5 unused
DefList:.asciz <11>/SLIDES.LST/		; Default List File
ExtList:.ascii /TSL.TXT./		; Supported extensions
ExtListEnd:
DataArea=Patterns+10000
LdAddr:	.word DataArea+2	; Addr to Load File
PttAddr:			; Buffer for unpack Atr-image to Addr-image
BlinkMod=PttAddr+3000		; Values to Mod Pattern Addresses
Patterns=((BlinkMod+1400 +37)/40)*40	; 4kB 128x32 Patterns
