;// Uhh this is like set up for linking into C modules.  Rip as you like
;// I use GUS.CPP now becuase it is just as fast.. 
;// i mean outp(x,y) =
;// mov dx, x
;// mov al, y
;// out dx, al
;// and thats all gus code is. port writes.
;// by FireLight

LOCALS
MODEL large
.286

;//Ŀ
;//                            PUBLIC FUNCTIONS                               
;//

public _GUSPeek                    ;// reads 1 byte from GUS dram
public _GUSPoke                    ;// writes 1 byte to GUS dram
public _GUSFindMem                 ;// returns the amount of avail GUS dram
public _GUSSetVolume               ;// sets volume of a voice
public _GUSSetBalance              ;// sets balance of a voice
public _GUSSetFreq                 ;// sets frequency of a voice
public _GUSPlayVoice               ;// plays voice with specified parameters
public _GUSReset                   ;// resets the GUS and prepares for play
public _GUSStopVoice               ;// stops a voice dead
public _GUSRamp                    ;// ramps a voice.. doesnt work
public _GUSUpload                  ;// uploads a <64kb buffer into dram FAST

public _Base
public _gusdram
public _mute
public _volume

; // UltraSound Ports
StatusPort              Equ 6h
SelectVoice             Equ 102h
CommandPort             Equ 103h
DataLowPort             Equ 104h
DataHighPort            Equ 105h
DRAMIOPort              Equ 107h

; // UltraSound Commands

SetVoiceFreq            Equ 01h         ; // Value=Freq/Divisor
VolRampRate             Equ 06h
VolRampStart            Equ 07h
VolRampEnd              Equ 08h
SetVolume               Equ 09h
SampleStartLo           Equ 0Ah
SampleStartHi           Equ 0Bh
VoiceBalance            Equ 0Ch
VoicesActive            Equ 0Eh
DMACtrl                 Equ 41h
DRAMAddrLo              Equ 43h
DRAMAddrHi              Equ 44h
TimerCtrl               Equ 45h
SampleCtrl              Equ 49h
Initialize              Equ 4Ch

;//Ŀ
;//                              GLOBAL DATA                                  
;//
dataseg
     _Base        dw  ?
     _gusdram     dd  ?
     _mute        db  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
     _volume      db  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
     GUSvol       dw 01500h
		  dw 0A0DEh,0AB52h,0B2BDh,0B87Eh,0BD31h,0C12Bh,0C49Ch,0C7A5h
		  dw 0CA5Dh,0CCD2h,0CF10h,0D120h,0D309h,0D4D1h,0D67Bh,0D80Bh
		  dw 0D984h,0DAE9h,0DC3Bh,0DD7Dh,0DEB0h,0DFD6h,0E0EFh,0E1FCh
		  dw 0E2FFh,0E3F8h,0E4E8h,0E5D0h,0E6AFh,0E788h,0E859h,0E924h
		  dw 0E9E9h,0EAA9h,0EB63h,0EC18h,0ECC8h,0ED73h,0EE1Ah,0EEBDh
		  dw 0EF5Ch,0EFF7h,0F08Fh,0F123h,0F1B5h,0F242h,0F2CDh,0F356h
		  dw 0F3DBh,0F45Eh,0F4DEh,0F55Bh,0F5D7h,0F650h,0F6C7h,0F73Ch
		  dw 0F7AEh,0F81Fh,0F88Eh,0F8FBh,0F967h,0F9D0h,0FA38h,0FA9Eh

;    GUSrates     dw 41160,38587,36317,34300,32494,30870,29400,28063,26843
;                 dw 25725,24696,23746,22866,22050,21289,20580,19916,19293

;//Ŀ
;//                                 MACROS                                    
;//
GUSDELAY        macro
	push dx
	push ax
	mov  dx, [_Base]
	add  dx, DRAMIOPort
	in   al, dx
	in   al, dx
	in   al, dx
	in   al, dx
	in   al, dx
	in   al, dx
	in   al, dx
	in   al, dx
	pop  ax
	pop  dx
endm

;//Ŀ
;//                            CODE STARTS HERE                               
;//
codeseg

RShift          PROC
	   mov  bx,cx
	   shr  ax,7
	   shr  cx,7
	   shl  bx,9
	   or   ax,bx
	   ret
RShift          ENDP

;//Ŀ
;// unsigned char GUSPeek(long int Loc) {                                                       
;//
_GUSPeek        PROC  Loc:dword
		push bp
		mov  bp,sp

		mov  dx, [_Base]
		add  dx, CommandPort
		mov  al, DRAMAddrLo
		out  dx, al

		inc  dx
		mov  ax, word ptr [Loc]
		out  dx, ax
		dec  dx
		mov  al, DRAMAddrHi
		out  dx, al
		add  dx, 2
		mov  al, byte ptr [Loc+2]
		out  dx, al

		add  dx, 2
		in   al, dx

		pop  bp
		ret
_GUSPeek        ENDP


;//Ŀ
;// void GUSPoke(dword Loc, char B) {
;//
_GUSPoke        PROC  Loc:dword, B:byte
		push bp
		mov  bp, sp

		mov  dx, [_Base]
		add  dx, CommandPort
		mov  al, DRAMAddrLo
		out  dx, al
		inc  dx                                         ;// now base+104
		mov  ax, word ptr [Loc]
		out  dx, ax

		dec  dx                         ;// now base+103
		mov  al, DRAMAddrHi
		out  dx, al
		add  dx, 2                      ;// now base+105
		mov  al, byte ptr [Loc+2]
		out  dx, al

		add  dx, 2                      ;// now base+107
		mov  al, B
		out  dx, al

		pop  bp
		ret
_GUSPoke        ENDP


;//Ŀ
;// void GUSUpload(dword Loc, char *buffer, word length, byte signuns) {
;//
_GUSUpload     PROC Loc:dword, buffer:dword, buflength:word, signuns:byte
		push bp
		mov  bp, sp

		cli
		push ds
		push si
		mov  cx, buflength
		mov  si, word ptr [Loc+2]
		les  di, buffer
		mov  bx, di
		mov  di, word ptr [Loc]

		mov  dx, [_Base]
		add  dx, CommandPort
		mov  al, DRAMAddrHi     ;// Dump upper byte, only do it once carry
		out  dx,al              ;// from now on.
		add  dx,2                               ;// 105h
		mov  ax, si
		out  dx,al
		sub  dx,2                               ;// now 103

MainLoop:
		mov  al,DRAMAddrLo
		out  dx,al
		inc  dx                                 ;// 104h
		mov  ax,di
		out  dx,ax              ;// write high byte
		dec  dx                 ;// 103h
DumpByte:
		add  dx,4                               ;// 107h
		mov  al,[es:bx]
		xor  al, signuns
		inc  bx
		out  dx,al                              ;// actually write the byte
		sub  dx,4                               ;// 103h
		add  di,1
		jnc  DoLoop

		inc  si
		mov  al, DRAMAddrHi
		out  dx,al
		add  dx,2                               ;// 105h
		mov  ax,si
		out  dx,al
		sub  dx,2                               ;// 103h
DoLoop:
		loop MainLoop
		sti

		pop  si
		pop  ds
		pop bp
		ret
_GUSUpload              ENDP


;//Ŀ
;// void GUSReset(byte NumVoices) {
;//
_GUSReset       PROC    NumVoices:byte
	push bp
	mov  bp,sp
	pusha

	;// FIRST MAKE SURE IF <= 14 SET NUMVOICES TO 14
	cmp  NumVoices, 14
	jg       notless14
	mov  NumVoices, 14
notless14:
	;// disable line out
	mov  dx, [_Base]
	mov  al, 2
	out  dx, al

	;// Poke a 0 to dram position 0
	xor  ax, ax
	push ax
	push ax
	push ax
	call _GUSPoke
	pop  ax
	pop  ax
	pop  ax

	;// clear end bit - master reset
	mov  dx, [_Base]
	add  dx, CommandPort    ;// 103h
	mov  al, Initialize
	out  dx, al
	add  dx, 2                              ;// 105h
	mov  al, 0
	out  dx, al
	;// wait for a bit
	mov  cx, 10
delayloop1:
	GUSDELAY
	loop delayloop1
	;// now set end bit - master run
	sub  dx, 2                              ;// 103h
	mov  al, Initialize
	out  dx, al
	add  dx, 2                              ;// 105h
	mov  al, 1
	out  dx, al

	;// Reset the MIDI IRQ port
	sub  dx, 5                              ;// 100h
	mov  al, 3                              ;// toggle high
	mov  cx, 10
delayloop2:
	GUSDELAY
	loop delayloop2
	;// reset
	mov  al, 0                              ;// toggle low
	out  dx, al

	;// CLEAR INTERRUPTS
	add  dx, 3                              ;// 103h
	mov  al, DMACtrl
	out  dx, al
	add  dx, 2                              ;// 105h
	mov  al, 0
	out  dx, al

	sub  dx, 2                      ;// 103h
	mov  al, TimerCtrl
	out  dx, al
	add  dx, 2                              ;// 105h
	mov  al, 0
	out  dx, al

	sub  dx, 2                      ;// 103h
	mov  al, SampleCtrl
	out  dx, al
	add  dx, 2                              ;// 105h
	mov  al, 0
	out  dx, al

	;// SET NUMBER OF VOICES
	mov  dx, [_Base]
	add  dx, CommandPort
	mov  al, VoicesActive
	out  dx, al
	add  dx, 2                              ;// 105h
	mov  al, NumVoices
	dec  al
	or   al, 0C0h
	out  dx, al

	;// CLEAR IRQ's - reading status port clears them
	mov  dx, [_Base]
	add  dx, StatusPort
	in   al, dx                             ;// read the gf1 irq status port

	mov  dx, [_Base]
	add  dx, CommandPort    ;// 103h
	mov  al, DMACtrl
	out  dx, al
	add  dx, 2                              ;// 105h
	in   al, dx                             ;// read dma control IRQ

	sub  dx, 2                              ;// 103h
	mov  al, 49h
	out  dx, al
	add  dx, 2                              ;// 105h
	in   al, dx                             ;// read sample control irq

	sub  dx, 2                              ;// 103h
	mov  al, 8Fh
	out  dx, al
	add  dx, 2                              ;// 105h
	in   al, dx                             ;// read irqv

	;// from loop through 32 voices
	mov  cx, 32
VoiceClearLoop:
	;// select voice (cx-1)
	mov  dx, [_Base]
	add  dx, SelectVoice    ;//102h
	mov  al, cl
	dec  al
	out  dx, al

	;// stop voice
	inc  dx                                 ;// 103h
	mov  al, 0                              ;// set control
	out  dx, al
	add  dx, 2                              ;// 105h
	mov  al, 3                              ;// voice stopped + stop voice
	out  dx, al
	;// stop volume ramp
	sub  dx, 2                              ;// 103h
	mov  al, 0Dh                    ;// set volume control
	out  dx, al
	add  dx, 2                              ;// 105h
	mov  al, 3                              ;// ramp stopped + stop ramp
	out  dx, al

	GUSDELAY

	loop VoiceClearLoop

	;// read irq port
	mov  dx, [_Base]
	add  dx, 6                              ;// Base+6
	in   al, dx

	mov  dx, [_Base]
	add  dx, CommandPort    ;// 103h
	mov  al, DMACtrl
	out  dx, al
	add  dx, 2                              ;// 105h
	in   al, dx

	sub  dx, 2                              ;// 103h
	mov  al, SampleCtrl
	out  dx, al
	add  dx, 2                              ;// 105h
	in   al, dx

	sub  dx, 2                              ;// 103h
	mov  al, 8Fh
	out  dx, al
	add  dx, 2                              ;// 105h
	in   al, dx

	;// RESET AND ENABLE DACS
	sub  dx, 2                              ;// 103h
	mov  al, Initialize
	out  dx, al
	add  dx, 2                              ;// 105h
	mov  al, 7
	out  dx, al

	;// enable line out
	mov  dx, [_Base]
	mov  al, 0
	out  dx, al

	popa
	pop  bp
	ret
_GUSReset       ENDP

;//Ŀ
;// dword GUSFindMem() {
;//
_GUSFindMem     PROC
	push    bp
	mov     bp,sp

	sub     sp,4

	;// first reset the GUS to 14 channels, the dram gets corrupted sometimes
	;// if you dont, ie if you run ST3, then fmod.  Well it doesnt now :)
	;// I used 14 channels for now, dont worry the GUS will be reset later
	;// with GUSReset() after the true number of channels is found.
	mov     ax, 14
	push    ax
	call    _GUSReset
	pop     ax
	mov  dx, [_Base]        ;// disable line out
	mov  al, 2
	out  dx, al

	mov     al, 0AAh
	push    ax
	mov     ax,4
	xor     dx,dx
	push    ax
	push    dx
	call    far ptr _GUSPoke
	add     sp,6

	mov     ax,4
	xor     dx,dx
	push    ax
	push    dx
	call    far ptr _GUSPeek
	pop     cx
	pop     cx
	cmp     al, 0AAh
	je      short @1@86
	mov     word ptr [bp-2],3
	mov     word ptr [bp-4],65535
	jmp     short @1@254
@1@86:

	mov     al, 0AAh
	push    ax
	mov     ax,8
	xor     dx,dx
	push    ax
	push    dx
	call    far ptr _GUSPoke
	add     sp,6

	mov     ax,8
	xor     dx,dx
	push    ax
	push    dx
	call    far ptr _GUSPeek
	pop     cx
	pop     cx
	cmp     al,170
	je      short @1@142
	mov     word ptr [bp-2],8
	mov     word ptr [bp-4],65535
	jmp     short @1@254

@1@142:
	mov     al,170
	push    ax
	mov     ax,12
	xor     dx,dx
	push    ax
	push    dx
	call    far ptr _GUSPoke
	add     sp,6

	mov     ax,12
	xor     dx,dx
	push    ax
	push    dx
	call    far ptr _GUSPeek
	pop     cx
	pop     cx
	cmp     al,170
	je      short @1@198
	mov     word ptr [bp-2],12
	jmp     short @1@226
@1@198:

	mov     word ptr [bp-2],15
@1@226:
	mov     word ptr [bp-4],65535
@1@254:

	mov     dx,word ptr [bp-2]
	mov     ax,word ptr [bp-4]
	jmp     short @1@282
@1@282:

	mov     sp,bp
	pop     bp
	ret
_GUSFindMem     ENDP

;//Ŀ
;// void GUSSetVolume(byte Voice, byte Volume) {
;//
_GUSSetVolume  PROC  Voice:byte, Volume:byte
	push bp
	mov  bp,sp
	push es
	push bx

	mov  bx, word ptr Voice
	mov  al, [_mute+bx]                     ;// check for muted channel
	cmp  al, 0
	je   nomute
	mov  Volume, 0                          ;// if it is set the channels volume to 0
nomute:
	mov  dx, [_Base]
	add  dx, SelectVoice
	mov  al, Voice
	out  dx, al                                     ;// SELECT VOICE

	inc  dx
	mov  al, SetVolume
	out  dx, al                                     ;// SELECT SET VOLUME FUNCTION

	inc  dx
	mov  bx, word ptr Volume        ;// put requested volume in here
	shl  bx, 1                                      ;// we are looking up a word table, so *2
	mov  ax, [GUSvol+bx]            ;// now reference the right GUS volume.

	out  dx, ax                                     ;// SET THE VOLUME
	GUSDELAY
	out  dx, ax                                     ;// DO IT AGAIN

	pop  bx
	pop  es
	pop  bp
	ret
_GUSSetVolume  ENDP

;//Ŀ
;// void GUSSetBalance(unsigned char Voice, unsigned char Balance) {
;//
_GUSSetBalance  PROC  Voice:byte, Balance:byte
	push bp
	mov  bp,sp

	mov  dx, [_Base]
	add  dx, SelectVoice
	mov  al, Voice
	out  dx, al
	inc  dx                                         ;// Base + 103h
	mov  al, VoiceBalance
	out  dx, al

	add  dx, 2                  ;// Base + 105h
	mov  al, Balance
	shr  al, 4                  ;// panval / 16 0=0; 0xff = 0xf
	out  dx, al
	pop  bp
	ret
_GUSSetBalance ENDP


;//Ŀ
;// void GUSSetFreq(unsigned char Voice, int Freq) {
;//
_GUSSetFreq     PROC  Voice:byte, Freq:word
	push bp
	mov  bp,sp

	mov  dx, [_Base]
	add  dx, SelectVoice
	mov  al, Voice
	out  dx, al
	inc  dx
	mov  al, SetVoiceFreq
	out  dx, al
	inc  dx
	mov  ax, Freq
	out  dx, ax

	pop  bp
	ret
_GUSSetFreq     ENDP

;// thanks to Brad Thomas for this bugfix (even though ripped from ultradox :)
;//Ŀ
;// void GUSStopVoice(unsigned char Voice) {
;//
_GUSStopVoice   PROC    Voice:byte
	push bp
	mov  bp,sp

	mov  dx, [_Base]
	add  dx, SelectVoice
	mov  al, Voice
	out  dx, al

	inc  dx                         ;//103h
	mov  al,80h
	out  dx, al           
	add  dx,2                       ;//105h
	in   al,dx
	mov  bh,al

	sub  dx,2                       ;//103h
	xor  al,al
	out  dx,al                      ;// write 0 to Base+103
	add  dx,2                       ;//105h
	mov  al,bh
	and  bh,0dfh
	or   al,3
	out  dx,al

	GUSDELAY

	sub  dx,2
	xor  al,al
	out  dx,al
	add  dx,2
	mov  al,bh
	and  bh,0dfh
	or   al,3
	out  dx,al

	pop  bp
	ret
_GUSStopVoice   ENDP


;//Ŀ
;// void GUSRamp(unsigned char Voice) {
;//
;// WARNING - THIS FUNCTION DOES NOT WORK
_GUSRamp                PROC    Voice:byte, Mode:byte
	push bp
	mov  bp, sp

	mov  dx, [_Base]
	add  dx, 0103h                  ;//CommandPort 103h
	mov  al, VolRampRate
	out  dx, al
	add  dx, 2                                      ;// Base+0x105
	mov  al, 63                                     ;// fastest possible (granularity 0, step 63)
	out  dx, al                                     ;// SET RAMP RATE

	sub  dx, 2                  ;// Base+0x103
	mov  al, VolRampStart
	out  dx, al
	add  dx, 2                  ;// Base+0x105
	mov  ax, 01500h                         ;// set to our gustable value of volume 0..
	shr  ax, 4
	out  dx, ax                                     ;// SET RAMP START

	sub  dx, 2                                      ;// Base+0x103
	mov  al, VolRampEnd
	out  dx, al
	add  dx, 2                  ;// Base+0x105
	mov  bx, word ptr Voice
	mov  ax, word ptr [_volume+bx]          ;// find out current Voice's volume
	shl  ax, 1                                      ;// we are looking up a word table, so *2
	mov  bx, ax
	mov  ax, [GUSvol+bx]            ;// now reference the right GUS volume.
	shr  ax, 4
	out  dx, ax                                     ;// SET RAMP END

	sub  dx, 2                  ;// Base+0x103
	mov  al, 0dh
	out  dx, al
	add  dx, 2                  ;// Base+0x105
	mov  al, Mode                           ;// ramp up, or ramp down
	out  dx, al                                     ;// SET MODE
	GUSDELAY                                        ;// WAIT
	sub  dx, 2                  ;// Base+0x103
	mov  al, 0dh
	out  dx, al
	add  dx, 2                  ;// Base+0x105
	mov  al, Mode                           ;// ramp up, or ramp down
	out  dx, al                                     ;// SET MODE AGAIN

	pop  bp
	ret
_GUSRamp           ENDP

;//Ŀ
;//void GUSPlayVoice(byte Voice,byte Mode,dword VBegin,dword VStart,dword VEnd) {
;//
_GUSPlayVoice  PROC  Voice:byte, Mode:byte, VBegin:dword, VStart:dword, VEnd:dword
	push bp
	mov  bp, sp

	mov  dx, [_Base]
	add  dx, SelectVoice
	mov  al, Voice
	out  dx, al

	;// first ramp the voice down
;       mov  ah, 01000000b                              ;// ramp down
;       mov  al, Voice
;       push ax
;       call _GUSRamp                                   ;// ramp down the volume first
;       pop  ax

	;// now stop the voice
	mov  ax, word ptr Voice
	push ax
	call _GUSStopVoice              ;// stop the voice
	pop  ax

	mov  dx, [_Base]
	add  dx, 0103h                          ;//CommandPort 103h

	;//VSTART
	mov  al, 2
	out  dx, al
	inc  dx                                 ;//DataLowPort 104h
	mov  ax, Word Ptr [VStart]
	push cx
	mov  cx, Word Ptr [VStart+2]
	call RShift
	pop  cx
	out  dx, ax

	dec  dx                                 ;//CommandPort 103h
	mov  al, 3
	out  dx, al
	inc  dx                                 ;//DataLowPort 104h
	mov  ax, Word Ptr [VStart]
	shl  ax, 9
	out  dx, ax

	;// VBEGIN;
	dec  dx                                 ;//now CommandPort 103h
	mov  al, SampleStartLo          ;//0Ah
	out  dx, al
	inc  dx                         ;//DataLowPort 104h
	mov  ax, Word Ptr [VBegin]      ;//high part in ax
	push cx
	mov  cx, Word Ptr [VBegin+2]    ;//low part in cx
	call RShift
	pop  cx
	out  dx, ax

	dec  dx                                 ;//CommandPort 103h
	mov  al, SampleStartHi
	out  dx, al
	inc  dx                         ;//DataLowPort 104h
	mov  ax, Word Ptr [VBegin]
	shl  ax, 9
	out  dx, ax

	;//VEND
	dec  dx                         ;//CommandPort 103h
	mov  al, 4
	out  dx, al
	inc  dx                         ;//DataLowPort 104h
	mov  ax, Word Ptr [VEnd]
	push cx
	mov  cx, Word Ptr [VEnd+2]
	call RShift
	pop  cx
	out  dx, ax

	dec  dx                         ;//CommandPort 103h
	mov  al,5
	out  dx,al
	inc  dx                         ;//DataLowPort 104h
	mov  ax,Word Ptr [VEnd]
	shl  ax,9
	out  dx,ax

	;// MODE
	dec  dx                         ;// now 103h
	mov  al, 0
	out  dx, al
	add  dx, 2                      ;// now 105h
	mov  al, Mode
	out  dx, al

;rampwait:
;       sub  dx, 2
;       mov  al, 08dh
;       out  dx, al
;       add  dx, 2
;       in   al, dx
;       and  al, 1
;       cmp  al, 1
;       je   rampwait                                   ;// wait for ramp to finish
;
;       mov  ah, 0                                              ;// now ramp up
;       mov  al, Voice
;       push ax
;       call _GUSRamp
;       pop  ax

	pop  bp
	ret
_GUSPlayVoice  ENDP

end
