#include "scene.h"
#include "keyframer.h"
#include "object.h"
#include "track.h"

he3d_CKeyframer::~he3d_CKeyframer()
{
	if( ptRotation )
		delete ptRotation;

	if( ptScale )
		delete ptScale;

	if( ptPosition )	
		delete ptPosition;
	
}

void he3d_CKeyframer::Transform( FLOAT _frame, he3d_CMtxStack& stack )
{
	he3d_CMatrix				mtx = stack.GetTop();
	he3d_CPositionTrack*		track = (he3d_CPositionTrack*)ptPosition;

	mtxFrame	= IdentMtx();
	frame		= _frame;	

	if( ptScale )
		mtxFrame *= ptScale->FrameMtx( frame );

	if( ptRotation )
		mtxFrame *= ptRotation->FrameMtx( frame );

	if( ptPosition )				
		mtxFrame *= ptPosition->FrameMtx( frame );	

	mtxFrame *= mtx;

	if( poKeyframerOwner )
		poKeyframerOwner->UpdateFrame( this );	

	if( pkfSub )
	{
		stack.Push( mtxFrame );
		pkfSub->Transform( frame, stack );
		stack.Pop();
	}

	if( pkfNext )
		pkfNext->Transform( frame, stack );	
}
