// Timer.h: interface for the CTimer class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_TIMER_H__008DC1E1_6F98_11D5_AD0F_E06357C10000__INCLUDED_)
#define AFX_TIMER_H__008DC1E1_6F98_11D5_AD0F_E06357C10000__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

class CTimer  
{
protected:
	
	BOOL				m_bInitialized;
	BOOL				m_bPause;

public:

	CTimer()
	{
	}

	virtual ~CTimer()
	{
	}

	// operations
	virtual VOID Init() = 0;
	virtual VOID Start() = 0;
	virtual VOID Pause() = 0;
	virtual VOID Resume() = 0;

	// status
	virtual FLOAT GetElapsedSec() = 0;
	virtual DWORD GetElapsedTime() = 0;

	virtual FLOAT GetAbsoluteSec() = 0;
	virtual DWORD GetAbsoluteTime() = 0;

	virtual FLOAT GetCurrentSec() = 0;
	virtual DWORD GetCurrentTime() = 0;
};

class CPerformanceTimer : public CTimer
{
private:

	LONGLONG				m_liResolution;
	LONGLONG				m_liStartTime;
	LONGLONG				m_liPauseTime;
	LONGLONG				m_liLastScanTime;

public:
	
	// operations
	virtual VOID Init();
	virtual VOID Start();
	virtual VOID Pause();
	virtual VOID Resume();

	// status
	virtual FLOAT GetElapsedSec();
	virtual DWORD GetElapsedTime();

	virtual FLOAT GetAbsoluteSec();
	virtual DWORD GetAbsoluteTime();

	virtual FLOAT GetCurrentSec();
	virtual DWORD GetCurrentTime();
};

class CMultimediaTimer : public CTimer
{
private:

	DWORD				m_dwStartTime;
	DWORD				m_dwPauseTime;
	DWORD				m_dwLastScanTime;

public:

	// operations
	virtual VOID Init();
	virtual VOID Start();
	virtual VOID Pause();
	virtual VOID Resume();

	// status
	virtual FLOAT GetElapsedSec();
	virtual DWORD GetElapsedTime();

	virtual FLOAT GetAbsoluteSec();
	virtual DWORD GetAbsoluteTime();

	virtual FLOAT GetCurrentSec();
	virtual DWORD GetCurrentTime();
};

#endif // !defined(AFX_TIMER_H__008DC1E1_6F98_11D5_AD0F_E06357C10000__INCLUDED_)
