; ======================================-=====================================
; Singen68k - A 14 byte sine generator for M68k by Superogue / Marquee Design
; ============================================================================
; X68000 Example
; ============================================================================
_SUPER		        equ	    $ff20 
_CRTMOD             equ     $10 
_B_CUROFF           equ     $1f         ; Turn off the text cursor
_G_CLR_ON           equ     $90         ; Clear screen and init graphics.
_G_SETMOD           equ     $91         ; Set graphic screen mode
_PSET               equ     $b6

sintab 	equ $100000
SIZE 	equ 256
						
start:
	; Supervisor mode
	clr.l   -(a7)
	dc.w     _SUPER

	lea sintab,a5
	; Sine generator (14 bytes, d1 is inited at 0)
	moveq  #127,d2			;2b 
singen:
	subq 	#2,d2			;2b
	move.w	d1,(a5)+		;2b
	sub.w	d1,(SIZE-4,a5)	;4b
	add.w	d2,d1			;2b
	bne.b	singen			;2b
    
	; Set 256x256 256-color mode (10)
	moveq #10,d1    
	moveq #_CRTMOD,d0
	trap #15 

	; Cursor off
        moveq #_B_CUROFF,d0
        trap #15

	; set graphics mode on
	move.w #_G_CLR_ON,d0
	trap #15    

update:
	
	; Draw sinewave
	lea sintab,a5       ; screen buffer
	move.w #255,d7
drawloop:	
	; Read sine value and scale back for plotting
	move.w (a5)+,d6	
	asr.w #6,d6	
	add.w #128,d6

	; plot point
	lea params,a1
	move.w #255,4(a1)
	move.w d6,2(a1)
	move.w d7,(a1)
	move.w #_PSET,d0
    trap #15

  dbra d7,drawloop
 bra update
	
params:
 