; ======================================-=====================================
; Singen68k - a 14 byte sine generator for M68k by superogue / marquee design|
; ============================================================================
; Sinclair QL Example
; ============================================================================

sintab equ $2BC00
SIZE equ 256

	lea sintab,a5

	; Sine generator (14/16 bytes)
	moveq #0,d1			;2b (can be removed if any reg is 0 at this point)
	moveq  #127,d2			;2b 
singen:
	subq 	#2,d2			;2b
	move.w	d1,(a5)+		;2b
	sub.w	d1,(SIZE-4,a5)	;4b
	add.w	d2,d1			;2b
	bne.b	singen			;2b

	; clear screen
	lea     $20000,a0       ; screen buffer	
	move.l  a0,a1
	move.w  #128*256/4,d0
.clr: 
    clr.l   (a1)+
	dbf     d0,.clr

update:
  
	; Draw sinewave
	lea sintab,a5       ; screen buffer
	move.w #255,d7
drawloop:	
	; Read sine value and scale back for plotting
	move.w (a5)+,d6	
	asr.w #6,d6	
	add.w #128,d6

	; plot point
	move d7,d0
	move d6,d1
	move #7,d2
	jsr plot
  dbra d7,drawloop
 bra update


; a0 = screen,  d0 = x, d1 = y, d2 = index(0..7)
plot:
	lsl.w   #6,d1           ; y byte
	moveq   #3,d3           ; x pixel shift
	and.w   d0,d3
	add.w   d3,d3
	asr.w   #2,d0           ; x byte
	add.w   d0,d1           ; total bytes
	add.w   d1,d1           ; to word offset

	lsl.b   #6,d2
	bcc     .noGreen
	add.w   #$8000,d2
.noGreen:
	lsr.w   d3,d2           ; shift scrambled color to px pos
	or.w    d2,(a0,d1)
	rts 
