
   #include "mode7.h"

   #include "Map/bg2.map.c"
   #include "Map/bg2.raw.c"
   #include "Map/bg3.map.c"
   #include "Map/bg3.raw.c"
   #include "Map/main0.map.c"
   #include "Map/main0.raw.c"
   #include "Map/main1.map.c"
   #include "Map/main1.raw.c"
   #include "Map/main2.map.c"
   #include "Map/main2.raw.c"
   #include "Map/main3.map.c"
   #include "Map/main3.raw.c"
   #include "Map/main4.map.c"
   #include "Map/main4.raw.c"
   #include "Map/maintitle.map.c"
   #include "Map/maintitle.raw.c"
   #include "Map/mainclouds.map.c"
   #include "Map/mainclouds.raw.c"
   #include "Map/mainblank.map.c"
   #include "Map/mainblank.raw.c"
   #include "Map/mainover.map.c"
   #include "Map/mainover.raw.c"
   #include "Map/master.pal.c"

   #include "intro.c"

#define M_BGXSCRLY_SET(bgno, yoff)        ACCESS_16(MEM_IO + 0x12 + (bgno<<2)) = yoff;

   void bkgInit(void){
     	map_fragment_info_ptr BackGroundMap;

      ham_bg[2].ti = ham_InitTileSet( (void*)&bg2_Tiles, SIZEOF_16BIT(bg2_Tiles), 1, 1 );
      ham_bg[2].mi = ham_InitMapEmptySet( 2, 1 );

      ham_bg[3].ti = ham_InitTileSet( (void*)&bg3_Tiles, SIZEOF_16BIT(bg3_Tiles), 1, 1 );
      ham_bg[3].mi = ham_InitMapEmptySet( 2, 1 );

      BackGroundMap = ham_InitMapFragment( (void*)&bg2_Map, 64, 64, 0, 0, 64, 64, 1 );
      ham_InsertMapFragment( BackGroundMap, 2, 0, 0 );
      ham_DeInitMapFragment ( BackGroundMap );

      BackGroundMap = ham_InitMapFragment((void*)&bg3_Map, 64, 64, 0, 0, 64, 64, 1);
      ham_InsertMapFragment(BackGroundMap, 3, 0, 0);
      ham_DeInitMapFragment ( BackGroundMap );


      M_BG2CNT_WRAP_SET_ON;
      M_BG3CNT_WRAP_SET_ON;
      ham_InitBg(2, 1, 2, 1);
      ham_InitBg(3, 1, 3, 1);

      ham_LoadBGPal((void *)&master_Palette, SIZEOF_16BIT(master_Palette));
      TOOL_SET_BG_PAL_256(0, 0, 0, 0);

      heroship.X = 120;
      heroship.Y = 80;
      bkg.Y = heroship.Y-80;
      bkg.Yold = bkg.Y+1;
   }

   void picInit(u8 bg){
      u8 pic = 7;
      const unsigned char *ts_src = introPic[pic].ts_src;
      const unsigned char *mf_src = introPic[pic].mf_src;
      u16 size_u16 = introPic[pic].size_u16;

     	map_fragment_info_ptr BackGroundMap;
      ham_bg[bg].mi = ham_InitMapEmptySet( 1, 1 );
      ham_bg[bg].ti = ham_InitTileSet( (void *)ts_src, size_u16, 1, 1 );

      BackGroundMap = ham_InitMapFragment( (void *)mf_src, 30, 20, 0, 0, 30, 20, 1);
      ham_InsertMapFragment(BackGroundMap, bg, 0, 0);
      ham_DeInitMapFragment ( BackGroundMap );

      ham_InitBg(bg, 1, bg, 1);
   }

   void picShow(u8 pic, u8 bg){

      const unsigned char *ts_src = introPic[pic].ts_src;
      const unsigned char *mf_src = introPic[pic].mf_src;
      u16 size_u16 = introPic[pic].size_u16;

     	map_fragment_info_ptr BackGroundMap;

      ham_DeInitTileSet( ham_bg[bg].ti );
      // ham_DeInitMapSet( ham_bg[3].mi );
      ham_bg[bg].ti = ham_InitTileSet( (void *)ts_src, size_u16, 1, 1 );

      BackGroundMap = ham_InitMapFragment( (void *)mf_src, 30, 20, 0, 0, 30, 20, 1);
      ham_InsertMapFragment(BackGroundMap, bg, 0, 0);
      ham_DeInitMapFragment ( BackGroundMap );

      ham_InitBg(bg, 1, bg, 1);
   }

   void picDeInit(u8 bg){
      ham_DeInitTileSet( ham_bg[bg].ti );
      ham_DeInitMapSet( ham_bg[bg].mi );
   }

   void paletteInit(u8 no){
         if (no==0){
            ham_LoadBGPal((void *)&master_Palette, SIZEOF_16BIT(master_Palette));
            //TOOL_SET_BG_PAL_256(0, 0, 0, 0);
         } else if (no==1){ // all black
            u16 i=256;
            while(i--) ACCESS_16(MEM_PAL_COL_PTR(i)) = 0;
         } else if (no==2){ // all white
            u16 i=256;
            while(i--) ACCESS_16(MEM_PAL_COL_PTR(i)) = 0x7fff;//255;
         }
   }


   void mode7ScrollUpdate(void){
      bkg.waveCurMark++;
      bkg.Y = heroship.Y-80;
      if (bkg.Y < -40) bkg.Y = -40;
      else if (bkg.Y > 40) bkg.Y = 40;
   }

   MEM_FUNC_IN_IWRAM void mode7Scroll(void){
      bkg.bkg2X+=768;
      bkg.bkg3X+=512;

      if ( bkg.Yold != bkg.Y ){
         bkg.Yold = bkg.Y;
         u8 j = bkg.Y+40;
         REG_BG3Y = j<<9;
         REG_BG2Y = (j<<8)+(j<<7);
      }

      // 0 scanline //
      u16  i = ((-79*bkg.Y)>>6)+0x100;
      REG_BG2PA = i;
      REG_BG3PA = i;
      REG_BG2PD = i;
      REG_BG3PD = i;
      i<<=7;
      REG_BG2X = bkg.bkg2X-i;
      REG_BG3X = bkg.bkg3X-i;

   }

   MEM_FUNC_IN_IWRAM void hblGameFunc(void){
      u16 i = F_VCNT_CURRENT_SCANLINE;
      if (i < 159 ){
         i = (((i-79)*bkg.Y)>>6)+0x100;
         REG_BG2PA = i;
         REG_BG3PA = i;
         REG_BG2PD = i;
         REG_BG3PD = i;
         i<<=7;
         REG_BG2X = bkg.bkg2X-i;
         REG_BG3X = bkg.bkg3X-i;
      }
   }
   

   void mode7main(void){
      u8 i = F_VCNT_CURRENT_SCANLINE;
//      REG_BG3X = (bkg.Y<<10)-rnd[i]%(bkg.Y<<11);
      REG_BG2X = (bkg.Y<<9)-rnd[i]%(bkg.Y<<10);

   }
   
   
   void dummyFunc( void ){
   }

   /* END OF FILE */
