#ifndef MATH_H
#define MATH_H

#include "main.h"

#define FP 8
#define int2fp(x) ((x) << FP)
#define fp2int(x) ((x) >> FP)
#define fp2float(x) (((double)(x)) / (1 << FP))
#define float2fp(x) ((s32)(((double)(x)) * (1 << FP)))
#define fp2float(x) (((double)(x)) / (1 << FP))
#define fpHalf (1 << (FP - 1))
#define fpOne (1 << FP)
#define fpThird (fpDiv(fpOne, int2fp(3)))
#define fpFourth (1 << (FP - 2))
#define fpMul(x, y) (((x) * (y)) >> FP)
#define fpDiv(x, y) (div((x) << FP, (y)))
#define abs(x) ((x) < 0 ? -(x) : (x))

extern s32 sqrt(s32) IN_IWRAM;
extern s32 div(s32, s32) IN_IWRAM;
extern void Irq() IN_IWRAM;

#endif
