#include "rotris.h"

.GLOBAL rotateSet
.GLOBAL spinIn
.GLOBAL spinOut

rotateSet:
	stmfd sp!,{lr}
	ldr r0,=rotparam
	add r1,r11,#OFFSET_REG_BG2AFFINE
	mov r2,#1
	swi SWI_NO_BG_AFFINE_SET<<16
	ldmfd sp!,{pc}

spinIn:
	stmfd sp!,{lr}
	ldr r4,=rotparam
	mov r5,#0xA000   @ r5=theta
	mov r9,#256>>4
	mov r6,#16384<<4 @ r6=ratio
	mov r10,#233
	bl spin
	mov r9,r9,lsl #4
	strh r9,[r4,#12]
	strh r9,[r4,#14]
	mov r5,#0
	strh r5,[r4,#16]
	bl rotateSet		
	ldr r0,=DISP_MODE_1|DISP_BG0_ON|DISP_BG1_ON|DISP_BG2_ON
	strh r0,[r11,#OFFSET_REG_DISPCNT]	
	ldmfd sp!,{pc}

spinOut:
	stmfd sp!,{lr}
	ldr r4,=rotparam
	mov r5,#0        @ r5=theta
	ldr r9,=0x3DA
	mov r6,#256<<4 @ r6=ratio
	mov r10,#280
	bl spin
	ldr r0,=DISP_MODE_1|DISP_BG0_ON|DISP_BG2_ON
	strh r0,[r11,#OFFSET_REG_DISPCNT]	
	ldmfd sp!,{pc}

spin:
	stmfd sp!,{lr}
_spinLoop:
	swi SWI_NO_VBLANK_INTR_WAIT<<16	
#ifndef SMALL	
	bl songUpdate
	bl wavRefresh
#endif	
	mul r6,r10,r6
	mov r6,r6,lsr #8
	mov r8,r6,lsr #4
	strh r8,[r4,#12]
	strh r8,[r4,#14]
	add r5,r5,#0x800
	strh r5,[r4,#16]
	bl rotateSet
	cmp r9,r6,lsr #8
	bne _spinLoop	
	ldmfd sp!,{pc}
