;ENTRY_52.ASM	12-02-1998	      HUGI sort filter coding entry = 34h = 52d
				.RADIX 16
;
ONLY	SEGMENT
			ASSUME CS:ONLY,SS:ONLY,DS:ONLY,ES:ONLY
				ORG 100
;******************************************************************************
;*			 Copyright (C) Lawrence E. Boothby 1998		      *
;*			Contract programming <boothbyl@reed.edu>	      *
;* ASSUMPTIONS:								      *
;*		Entry SP=FFFE (full segment available to load program)	      *
;*		BX=0000 = sti, [SP]=0000 -->CS:0000 INT 20, DF=up	      *
;*		OFFSET BUFFER <= DX=CS <= end of segment - (100h +2*input)    *
;*		Input is redirected and at least one CR,LF pair		      *
;******************************************************************************
START:		MOV	AH,3F
		MOV	CX,SP		;>= 30k
		INT	21
		XCHG	CX,AX		;get CX=total bytes
		;JC	safe		;read failure
		;JCXZ	safe		;if zero length file
		MOV	DI,DX		;(=CS)
		MOV	AX,020A		;function AH=02 and AL=LF
	;--------------------------------------------------------------:
	; Build list of pointers to lines on stack		       :
	;--------------------------------------------------------------:
MORE_INPUT:	PUSH	DI		;-->line
		REPNZ	SCASB
		JCXZ	NXT_LINE
		CALL	MORE_INPUT
	;--------------------------------------------------------------:
	; Pop next pointer to a line off stack. Compare line it points :
	; to to all remaining to be done, exchanging this pointer with :
	; any on stack that are earlier in sort order.		       :
	;--------------------------------------------------------------:
NXT_LINE:	MOV	BX,SP
		POP	SI		;assume at least one line to output
NXT_CMP:	ADD	BX,0004
		JZ	CHR_OUT
		MOV	DI,[BX]
		PUSH	SI
		MOV	CL,0FF		;(CH=00)  00FF = max length to compare
		REPZ	CMPSB		;comparing 2 lines
		POP	SI
		JBE	NXT_CMP
		XCHG	SI,[BX]		;exchange pointers to these lines
		JMP	SHORT NXT_CMP
	;--------------------------------------------------------------:
	; Having found pointer to minimum remaining line, output it.   :
	;--------------------------------------------------------------:
CHR_OUT:	MOV	DL,[SI]
		INC	SI
		INT	21	       ;returns AL=DL (at least under DOS 6.22)
		CMP	AL,0A		;one byte less than CMP DL,0A
		JNZ	CHR_OUT
safe:		RET
;******************************************************************************
BUFFER	LABEL	BYTE
ONLY	ENDS
	END START
