;      BGE

        device  zxspectrum128

        INCLUDE "../local.asm"  ; for varios localisations

        INCLUDE "../KerBGE.asm"
        INCLUDE "../NumGUI.asm"

        ORG #6128
        INCLUDE "../GuiVar.asm"



        ORG PgnAdr

START   LD (RETAD+1),HL
        LD (spp),SP

        CALL SV_UNDO
Start   CALL LOADSCR
        CALL ERASE_ALLW
        LD A,%1111
start   LD SP,0
spp     EQU $-2
        LD IX,SPR_WIN
        LD (IX+6),A
        CALL IniVar
         call normAMwin
        LD A,Win
        CALL GUI
        CP #FF
        JP Z,RETURN
        PUSH AF
        CALL AddRam
        POP AF
        LD BC,TABjp
        JP TAB_JP

TABjp   DW Cut
        DW Look
        DW Delete
        DW Out
        DW Format
        DW New
        DW LoadSPR
        DW SaveSPR
        DW SaveCOD
        DW Compile
        DW DRIVE

        DW StartANI
        DW set_delay
        DW Ch_AMode
        DW set_ani
        DW set_bg

        DW INFO
        DW ABOUT

New     CALL ASK
        JP C,noclose
        CALL Create
        JP noclose

WAITKEYM LD A,WAITKEY
         JP GUI
NOKEYM  LD A,NOKEY
        JP GUI

SORTspr DB #01,"SPR",#FF

LoadSPR LD HL,SORTspr
        CALL FilerE
        JP C,noclose
        LD A,(SEC_LEN)
        LD B,A
        LD HL,#8000
        LD DE,#C000
        LD IX,(START_SEC)
        LD A,4
        LD C,#05
        EX AF,AF'
        LD A,SL_BANK
        CALL GUI
        LD DE,SCRNAME
        CALL ToName
        JP noclose

AddRam  LD A,AddPage
        JP RAM

SCRNAME DB "NoName  SPR"
CODNAME DB "NoName  COD"

SaveSPR ; LD A,(All)
        call IDL
        ld a,(All)
        AND A
        JP Z,NoSpr
       ; CALL IDL
        LD HL,SCRNAME
        CALL FNEdit
        JP C,noclose
        LD HL,SCRNAME
        CALL FromName
        CALL AddRam
        LD HL,(Float)
        LD DE,#C000
        AND A
        SBC HL,DE
        PUSH HL
        POP IX
        DEC HL
        INC H
        LD B,H
        LD HL,#8000
        LD DE,#C000
        LD A,AddPage
        LD C,11
        EX AF,AF'
        LD A,SL_BANK
        CALL GUI
        JP noclose

SaveCOD ; LD A,(All)
        call IDL
        ld a,(All)
        AND A
        JP Z,NoSpr
       ; CALL IDL
        LD HL,CODNAME
        CALL FNEdit
        JP C,noclose
        LD HL,CODNAME
        CALL FromName
        CALL AddRam
        LD HL,(Float)
        LD DE,Sprites
        SBC HL,DE
        PUSH HL
        POP IX
        DEC HL
        INC H
        LD B,H
        LD HL,#8000
        LD DE,Sprites
        LD A,AddPage
        LD C,11
        EX AF,AF'
        LD A,SL_BANK
        CALL GUI
        JP noclose

Create  CALL AddRam
        LD HL,Head
        LD DE,Head+1
        LD BC,16343
        LD (HL),0
        LDIR
        LD HL,head
        LD DE,Head
        LD BC,4
        LDIR
        XOR A
        LD (All),A
        LD (teksp),A
        LD HL,TABLICA
        LD (FloatTab),HL
        LD HL,Sprites
        LD (Float),HL
Ret     RET

DRIVE   CALL Driver
        JP noclose

Format  LD A,%1111
format  LD IX,FOR_WIN
        LD (IX+6),A
        LD A,Win
        CALL GUI
        CP #FF
        JP Z,clstart
        LD BC,TABFOR
        JP TAB_JP

TABFOR  DW Atrib
        DW SSize

SSize   LD A,(Fsize)
        CP 4
        JR Z,onsi
        LD A,4
        LD (Fsize),A
        XOR A
        LD (FSIZE),A
        JR fjp

onsi    CALL LOADSCR
        CALL AddRam
        CALL SelOne
        LD A,3
        LD (Fsize),A
        LD A,1
        LD (FSIZE),A
        LD A,(IX+2)
        LD (XSIZE),A
        LD A,(IX+3)
        LD (YSIZE),A
        JP Start

Atrib   LD A,(Fatr)
        CP 3
        JR Z,ona
        LD A,3
        LD (Fatr),A
        LD A,1
fff     LD (bite),A
fjp     LD A,%1101
        JR format
ona     LD A,4
        LD (Fatr),A
        XOR A
        JR fff
bite    DB 0

FOR_WIN DB 6,8,10,6,6*8,6,%1111,0
        DW TFOR
        DW SFOR
        DW #FFFF

; x, y,  ,  (#00/#FF)

TFOR                       ; DB "",13
        MSG_Params : DB 13
        MSG_Attrs          ; DB " ",4,13
Fatr    DB 4,13            ; EQU $-2
        MSG_Size           ; DB "   ",4,0
Fsize   DB 4,0             ; EQU $-2

SFOR    DB 1,3,8,1,%11
        DB 1,4,8,1,%11
        DB #FF

SPR_WIN DB 4,2,14,23,7*8,7,%1111,0       ; 4,4,12,17,7*8,7,%1111,0
        DW TSPR
        DW SSPR
        DW #FFFF

;TSPR    DB " 1.o5",13
;        DB "",13
;        DB "",13
;        DB "",13
;        DB "",13
;        DB "_",13
;        DB " SPR",13
;        DB " SPR_",13
;        DB " SPR_",13
;        DB " CODE_",13
;        DB " SPR_",13
;        DB "",13
;        DB "",13
;        DB " ",0

TSPR     MSG_Title : DB 13
         MSG_Cut : DB 13
         MSG_Look : DB 13
         MSG_Delete : DB 13
         MSG_Put : DB 13
         MSG_Format : DB 13
         MSG_NewSPR : DB 13
         MSG_OpenSPR : DB 13
         MSG_SaveSPR : DB 13
         MSG_SaveCODE : DB 13
         MSG_SaveASM : DB 13
         MSG_DiskSel : DB 13,15,13
         MSG_Animat  : DB 13
         MSG_Delay : DB 13
         MSG_Mode : DB 13
.cirkl    DB "000--END",13,15,13       ; "***-***"
         MSG_Info : DB 13
         MSG_About : DB 13
          DB #16,9,16
.delay    DB "000 ",13,#16,8,18,"BG: #"
.bg       DB "07 ",13,#16,8,17
.mode     DB "Pendulum"   ; 8 chars only : "Pendulum" or " Replay " / " "  "  "
         DB 0

SSPR    DB 1,3,12,1,%11
        DB 1,4,12,1,%11
        DB 1,5,12,1,%11
        DB 1,6,12,1,%11
        DB 1,7,12,1,%11
        DB 1,8,12,1,%11
        DB 1,9,12,1,%11
        DB 1,10,12,1,%11
        DB 1,11,12,1,%11
        DB 1,12,12,1,%11
        DB 1,13,12,1,%11

        DB 1,15,12,1,%11
        DB 1,16,12,1,%11
        DB 1,17,12,1,%11
        DB 1,18,5,1,%11
        DB 8,18,5,1,%11

        DB 1,20,12,1,%11
        DB 1,21,12,1,%11
        DB #FF
TReplay      MSG_Replay      ; 8 chars
TPendulum    MSG_Pendulum    ; 8 chars
TFragment    DB "000--END"   ; 8 chars


About   DB 6,8,22,8,5*8,5,%1111,0
        DW TAbout
        DW #FFFF

TAbout  DB "Burial Sprite Cutter v1.o5*",13
        DB "Based on the source code of the",13
        DB "  Burial Sprite Cutter v1.o4",13
        DB "  (c) Sinn/Delirium Tremens",13
        DB "     from Freedom'1999-o1"
        DB 0

ABOUT   LD IX,About
        LD A,Window
        CALL GUI
        CALL NOKEYM
        CALL WAITKEYM
        JP clstart

Out     CALL IDL
        LD A,(All)
        AND A
        JP Z,NoSpr

out     CALL CLS
        LD HL,Start
        CALL SelSpr
        CALL LOADSCR
        CALL AddRam
        CALL Recoord

        LD A,(teksp)
        CALL Search
        LD (IX+2),B
        LD (IX+3),C

        XOR A
        CALL Ramka8
        JP C,Start

        LD A,(teksp)
        CALL Search
        LD (IX+2),B
        LD (IX+3),C
        CALL LoadW

        CALL SAVESCR
        CALL NOKEYM
        JP out

ramka   DB 0,0,1,1,0

calc    CALL GET_LEN
        LD DE,(Float)
        ADD HL,DE
        JP C,OutMem
        RET

Cut     CALL IDL_      ;IDL
        LD A,(All)
        CP #FF
        JP Z,OutMem
        CALL LOADSCR
        CALL AddRam
Loop1   LD A,(All)
        CP #FF
        JP Z,OutMem
        CALL SelOne
        CALL TakeSpriteSA
        JR Loop1

TakeSpriteSA
        CALL AddRam
        CALL calc
        LD DE,(Float)
        CALL SaveW
        LD HL,(FloatTab)
        PUSH DE
        PUSH HL
        EX DE,HL
        LD DE,Sprites
        SBC HL,DE
        EX DE,HL
        POP HL
        LD (HL),E
        INC HL
        LD (HL),D
        INC HL
        LD A,(IX+2)
        LD (HL),A
        INC HL
        LD A,(IX+3)
        LD (HL),A
        INC HL
        LD A,(bite)
        LD (HL),A
        INC HL
        LD (FloatTab),HL
        POP DE
        LD (Float),DE
        LD A,(All)
        INC A
        LD (All),A
        RET

Delete  CALL NOKEYM
        CALL IDL
        LD A,(All)
        AND A
        JP Z,NoSpr

        CALL CLS
        LD HL,Start
        CALL SelSpr

        LD A,(teksp)
        CALL Search
        LD (toHL),HL
        LD (toDE),DE
        LD A,(teksp)
        INC A
        CALL Search
        LD (fromHL),HL
        LD (fromDE),DE

        LD IX,(toHL)
        CALL GET_LEN
        LD (decsm),HL

        LD A,(teksp)
        INC A
        LD B,A
        LD A,(All)
        CP B
        JP Z,lastdec

        LD HL,#FFFF
        LD DE,(fromDE)
        SBC HL,DE
        PUSH HL
        POP BC ;  

        LD HL,(fromDE)
        LD DE,(toDE)
        LDIR

        LD HL,Sprites
        LD DE,(fromHL)
        SBC HL,DE
        PUSH HL
        POP BC

        LD HL,(fromHL)
        LD DE,(toHL)
        LDIR

        LD HL,(toHL)
        LD A,(teksp)
        LD B,A
        LD A,(All)
        SUB B
        LD B,A
dcl1    PUSH BC
        LD E,(HL)
        INC HL
        LD D,(HL)
        DEC HL
        EX DE,HL
        LD BC,(decsm)
        SBC HL,BC
        EX DE,HL
        LD (HL),E
        INC HL
        LD (HL),D
        LD BC,4
        ADD HL,BC
        POP BC
        DJNZ dcl1
        JR decall

lastdec LD A,(teksp)
        DEC A
        LD (teksp),A

decall  LD A,(All)
        DEC A
        LD (All),A

        LD HL,(Float)
        LD BC,(decsm)
        SBC HL,BC
        LD (Float),HL
        LD HL,(FloatTab)
        LD BC,5
        SBC HL,BC
        LD (FloatTab),HL

        LD A,(All)
        AND A
        CALL Z,Create
        JP Start

toHL    DW 0
toDE    DW 0
fromHL  DW 0
fromDE  DW 0
decsm   DW 0
;...................................
;. :                           .
;.  A  -   (0-255)     .
;. :                          .
;.  HL - adress in TABLICA         .
;.  BC - width, high               .
;.  DE - adress in RAM             .
;.  A  -                     .
;...................................

;Search: LD HL,TABLICA
;        AND A
;        JR Z,FirSpSch

;        LD B,A
;        LD DE,5
;sloop   PUSH DE
;        PUSH HL
;        LD E,(HL)
;        INC HL
;        LD D,(HL)

;        PUSH HL
;        EX DE,HL
;        LD DE,Sprites
;        ADD HL,DE
;        EX DE,HL
;        POP HL

;        LD (adrrsp+1),DE
;        POP HL
;        POP DE
;        ADD HL,DE
;        DJNZ sloop
;adrrsp  LD DE,0

Search      ld hl,TABLICA
            ld de,Sprites
            or a
          jr z,consrch
            dec a
            ld l,a
            ld h,0
            ld c,l
            ld b,h
            add hl,hl
            add hl,hl  ; (num-1)*4
            add hl,bc  ; (num-1)*5
            ld bc,TABLICA
            add hl,bc  ; TABLICA+5*(num-1)
            ld c,(hl)
            inc hl
            ld b,(hl)
            ex de,hl
            add hl,bc
            ex de,hl       ; de - adress in RAM
            ld bc,4
            add hl,bc      ; hl - adress in TABLICA

consrch PUSH HL
        INC HL
        INC HL
        LD B,(HL)
        INC HL
        LD C,(HL)
        INC HL
        LD A,(HL)
        POP HL
        RET

;FirSpSch:
;        LD DE,Sprites
;        JR consrch

rmx     DB 0,0,0,0,1

GET_LEN:
        LD A,(IX+3)
        ADD A,A
        ADD A,A
        ADD A,A
        LD B,A
        LD HL,0
        LD D,0
        LD E,(IX+2)
        ADD HL,DE
        DJNZ $-1
        LD A,(IX+4)
        AND A
        RET Z
        LD A,(IX+3)
        LD B,A
        LD D,0
        LD E,(IX+2)
        ADD HL,DE
        DJNZ $-1
        RET

;   

SINFO   DB 6,20,20,4,5*8,5,%0010,0
        DW DL
        DW #FFFF

; DL      DB "000: 000 x 000 :  ",13
; SM      DB " 00000  00000",0

DL       DB "000: "
.sx      DB "000 x "
.sy      DB "000 "
         MSG_DL_atr : DB " "
.fl      DB " ",13

SM       MSG_SM_disp : DB " "
.ofset   DB "00000 "
         MSG_SM_len : DB " "
.len     DB "00000"
         DB 0

Sinfo   AND A
        JR Z,sinoa
        LD A,3;"["
        JR obsi

sinoa   LD A,4;"]"
obsi    ld (DL.fl),a ; LD (DL+25),A

        LD A,(IX+2)
     ;   EX AF,AF'
        LD DE,DL.sx       ; DL+5
     ;   LD C,0
     ;   LD A,GET_NUM
     ;   CALL GUI
        call CONV

        LD A,(IX+3)
     ;   EX AF,AF'
        LD DE,DL.sy       ; DL+11
     ;   LD C,0
     ;   LD A,GET_NUM
     ;   CALL GUI
        call CONV

        LD A,(teksp)
      ;  EX AF,AF'
        LD DE,DL
      ;  LD C,0
      ;  LD A,GET_NUM
      ;  CALL GUI
        call CONV

        LD HL,(smi)
        LD DE,Sprites
        SBC HL,DE
        LD DE,SM.ofset   ; SM+9
      ;  LD C,1
      ;  LD A,GET_NUM
      ;  CALL GUI
        call C1NV

        CALL GET_LEN
        LD DE,SM.len     ; SM+21
      ;  LD C,1
      ;  LD A,GET_NUM
      ;  CALL GUI
        call C1NV

        LD A,(IX+3)
        CP 21
        JR C,norm
        LD A,%0010
        JR okr
norm    LD A,%0000
        JR okr

okr     PUSH IX
        LD IX,SINFO
        LD (IX+6),A
        LD A,Window
        CALL GUI
        POP IX
        RET

Look    CALL NOKEYM
        CALL IDL
        LD A,(All)
        AND A
        JP Z,NoSpr
        LD HL,Start
        CALL SelSpr
        JP Start

;SelSpr  LD (brka+1),HL
SelSpr    xor a
          ld (DNSPR.first),a
SelSpr_  ; ld (brka+1),hl
           ld (brka_),hl
        LD IX,rmx
        XOR A
        LD (IX+0),A
        LD (IX+1),A
        CALL CLSani
        CALL AddRam
        PUSH IX
        LD A,%0010
        LD IX,SINFO
        LD (IX+6),A
        LD A,Window
        CALL GUI
        POP IX

         ld a,5
         ld (key_numpr),a
         ld a,8
         ld (key_delay.set),a
         xor a
         ld (key_delay),a

loopen  LD A,(teksp)
        CALL Search
        LD (smi),DE
        LD (IX+2),B
        LD (IX+3),C
        LD (IX+4),A
        HALT
        PUSH AF
        CALL LoadW
        POP AF
        CALL Sinfo



;dloop  CALL DIRSCN
dloop   PUSH IX
        POP HL
        LD DE,bufix
        LD BC,5
        LDIR
        HALT

        XOR A
        CALL BREAK
;brka    JP C,0
       jr c,e_break
        LD A,DIRSCN
        CALL GUI
        LD A,(DIRECT)
        AND A
      ;  JR Z,1F  ; dloop
       jr nz,1F
         ld a,8
         ld (key_delay.set),a
         ld a,5
         ld (key_numpr),a
         xor a
       jr z,2F
1        ld c,a
key_delay  EQU $+1 : ld a,16   ;  
         or a
        jr z,3F
         dec a
2        ld (key_delay),a
        jr dloop
3        ld a,8   ;   
.set  EQU $-1
         ld (key_delay),a
key_numpr  EQU $+1 : ld a,5    ;     
         or a
        jr nz,5F
         ld a,(key_delay.set)
         sub 4
        jr nc,4F
         xor a
4        inc a
         ld (key_delay.set),a
         ld a,6
5        dec a
         ld (key_numpr),a

         ld a,c
        BIT 2,A
        JR NZ,UPSPR
        BIT 3,A
        JR NZ,DNSPR
        BIT 4,A
      ;  RET NZ
       jp nz,retBorder
        JR loopen

e_break  call retBorder
brka_   EQU $+1 : jp 0


UPSPR   LD A,(teksp)
        INC A
        LD B,A
        LD A,(All)
        CP B
        JP Z,dloop
        LD A,B
loopgo  LD (teksp),A
        PUSH IX
        LD IX,bufix
        CALL CLSW
        LD A,(IX+3)
        CP 21
        JP C,nOrm
        LD IX,SINFO
        LD A,Window
        CALL GUI
nOrm    POP IX
        JP loopen

DNSPR   LD A,(teksp)
        AND A
        JP Z,dloop
.first   EQU $+1 :  cp 0
                   jp z,dloop
        DEC A
        JP loopgo

CLSW    CALL CLSVV
       ; LD A,7
         ld a,(Bground)
        CALL setv
        RET

smi     DW 0
bufix   DS 5

; A -  /

LoadW   PUSH AF
        CALL LoadWS
        POP AF
        AND A
        RET Z
        CALL LoadWA
        RET

SaveW   CALL SaveWS
        LD A,(bite)
        AND A
        RET Z
        CALL SaveWA
        RET
;......................
FSIZE   DB 0
XSIZE   DB 1
YSIZE   DB 1

SelOne  LD IX,ramka
        CALL Recoord

        LD A,(bite)
        LD (IX+4),A
        LD A,(FSIZE)
        AND A
        JR NZ,ysi
        LD A,1
        LD (IX+2),A
        LD (IX+3),A
        CALL R8Sel
        JP C,Start
        CALL NOKEYM
        RET

ysi     LD A,(XSIZE)
        LD (IX+2),A
        LD A,(YSIZE)
        LD (IX+3),A

        LD A,32
        LD B,(IX+2)
        SUB B
        Amul8
        LD (ARWXMX),A
        LD A,24
        LD B,(IX+3)
        SUB B
        Amul8
        LD (ARWYMX),A

        LD B,4
        HALT
        DJNZ $-1

        XOR A
        CALL Ramka8_
        JP C,Start

        LD A,(IX+0)
        LD B,(IX+2)
        ADD A,B

        EX AF,AF'
        LD A,(ARWXMX)
        LD B,A
        SRL B
        SRL B
        SRL B
        EX AF,AF'
        INC B
        CP B

        JR NC,corrx
        LD A,(IX+0)
        LD B,(IX+2)
        ADD A,B
        Amul8
        LD (ARW_X),A
        RET

corrx   XOR A
        LD (ARW_X),A
        LD A,(IX+1)
        LD B,(IX+3)
        ADD A,B

        EX AF,AF'
        LD A,(ARWYMX)
        LD B,A
        SRL B
        SRL B
        SRL B
        EX AF,AF'
        INC B
        CP B
        JR NC,corry

        LD A,(IX+1)
        LD B,(IX+3)
        ADD A,B
        Amul8
        LD (ARW_Y),A
        RET

corry   XOR A
        LD (ARW_Y),A
        RET

Recoord LD A,(ARW_X)
        SRL A
        SRL A
        SRL A
        LD (IX+0),A
        LD A,(ARW_Y)
        SRL A
        SRL A
        SRL A
        LD (IX+1),A
        RET

clstart CALL CLOSE
noclose LD A,%1101
        JP start
;.......................................
err      LD IX,errorw
;         JR errout_
         ld hl,terr.db
         xor a
         ld (hl),a
         ld a,b
         or a
        jr z,errout_
         ld (hl),13
         ld ix,errorw_
         ld (ix+6),%1111
         ld a,Win
         call GUI
         push af
         call CLOSE
         call NOKEYM
         pop af
         or a
        jp nz,noclose
        jp New

OutMem  LD IX,freew
        LD A,Window
        CALL GUI
        CALL NOKEYM
        CALL WAITKEYM
        JP Start

NoSpr   LD IX,nospr
errout_ LD A,Window
        CALL GUI
        CALL NOKEYM
        CALL WAITKEYM
        JP clstart

INFO_WIN
        DB 7,7,18,7,5*8,5,%1111,0
        DW TINF
        DW #FFFF

; TINF    DB " SPR :",13
; SPRLN   DB " SPR ......... 00000",13
; CODLN   DB " CODE ........ 00000",13
; SPNUM   DB " ............ 000",0

TINF     MSG_InfoT : DB 13
SPRLN    MSG_SPR_Len
.num     DB "00000",13
CODLN    MSG_CODE_Len
.num     DB "00000",13
SPNUM    MSG_SPR_Nums
.num     DB "000",0

INFO    CALL IDL

        LD HL,(Float)
        LD DE,#C000
        SBC HL,DE
        LD DE,SPRLN.num      ; SPRLN+20
      ;  LD C,1
      ;  LD A,GET_NUM
      ;  CALL GUI
        call C1NV

        LD HL,(Float)
        LD DE,Sprites
        SBC HL,DE
        LD DE,CODLN.num      ; CODLN+20
      ;  LD C,1
      ;  LD A,GET_NUM
      ;  CALL GUI
        call C1NV

        LD A,(All)
        LD DE,SPNUM.num      ; SPNUM+22
     ;   LD C,0
     ;   EX AF,AF'
     ;   LD A,GET_NUM
     ;   CALL GUI
        call CONV

        LD IX,INFO_WIN
        LD A,Window
        CALL GUI
        CALL NOKEYM
        CALL WAITKEYM
        JP clstart

freew   DB 9,9,14,5,5*8,5,%1111,0
        DW tfreew
        DW #FFFF
tfreew  MSG_Attent : DB 13   ; DB " !",13
        MSG_LittMem : DB 0   ; DB " ",0

nospr   DB 9,9,14,5,5*8,5,%1111,0
        DW tnospr
        DW #FFFF
tnospr  MSG_Attent : DB 13   ; DB "  !",13
        MSG_NoSPR : DB 0     ; DB " ",0

errorw  DB 9,7,15,5,5*8,5,%1111,0
        DW terr
        DW #FFFF

errorw_ DB 9,7,15,8,5*8,5,%1111,0
        DW terr
        DW serr
        DW #FFFF

terr    MSG_Attent : DB 13           ; DB "   !",13
        MSG_NoFile                   ; DB " ",0
.db     DB 13 ; 13 or 0
        MSG_CreateF : DB 13,13," "   ;       SPR ?
        MSG_No : DB 13,22,10,6," " : MSG_Yes
        DB 0

serr    DB 10,6,3,1,%11
        DB 1,6,3,1,%11
        DB #FF


;IDL     CALL AddRam
IDL_     ld a,1
        jr 1F
IDL      xor a
1        push af
         call AddRam
         pop bc
        LD HL,Head
        LD A,(HL)
        CP "S"
        JP NZ,err
        INC HL
        LD A,(HL)
        CP "P"
        JP NZ,err
        INC HL
        LD A,(HL)
        CP "R"
        JP NZ,err
        INC HL
        LD A,(HL)
        CP "-"
        JP NZ,err
        RET

;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
;-    DB
errsp   CALL CLOSE
        LD SP,0
Sp      EQU $-2
        JP noclose

WWait   DB 9,8,14,5,2*8+7,7,%1111,0
        DW TWait
        DW #FFFF
TWait   MSG_Attent : DB 13   ; DB "   !",13
        MSG_Process : DB 0   ; DB " _",0

Compile
        call IDL
        LD A,(All)
        AND A
        JP Z,NoSpr
      ;  CALL IDL

        LD HL,FNAME
        CALL FNEdit
        JP C,noclose

        LD IX,WWait
        LD A,Window
        CALL GUI

        LD (Sp),SP
retry   LD A,LOAD_CAT
        CALL GUI
        JR C,errsp

        LD C,#0A
        LD A,DOS_FUNC
        CALL GUI
       ; JR Z,nokds
       ; JR okds
       jr c,okds
nokds   LD A,2
        CALL GET_MSG
        AND A
        JR Z,retry
        JR errsp
okds    LD HL,0
        LD (total),HL
        LD (FR_FLUSH),HL
        LD HL,(END_DISK)
        LD (TEK_SEC),HL
        CALL INI_BUFF

        LD A,0
cont    PUSH AF
        CALL SSpr
        POP AF
        INC A
        LD HL,All
        CP (HL)
        JR NZ,cont
        XOR A           ;   
        CALL ADD_BYTE
        CALL Flush      ;   

ClFile  LD HL,FNAME
        LD DE,23773
        LD BC,11
        LDIR
        LD HL,#4000
        LD DE,(total)
        PUSH DE
        DEC DE
        INC D
        LD B,D
        POP DE
        LD C,#FF
        LD A,DOS_FUNC
        CALL GUI
        JP errsp

FNAME   DB "NoName  WRD"
;------------------------
;   
SSpr    PUSH AF
        LD DE,name+3
        CALL CONV
        LD HL,name
        LD B,6
        CALL ADD_BYTES
        POP AF

        CALL Search
        LD (yesrgb),A
        LD (GADR+1),DE
        LD (nach),DE
        LD A,B
        LD (b0),A
        LD A,C
        LD (c0),A
        LD A,0

        LD C,1
c0      EQU $-1
dnz4
        LD B,0
b0      EQU $-1
dnz3    PUSH BC
        LD HL,dbsym
        LD B,4
        CALL ADD_BYTES
        LD B,7
dnz2    PUSH BC
        CALL GADR
        LD A,(HL)
        LD DE,bytsym1
        PUSH DE
        CALL CONV
        POP HL
        LD B,4
        CALL move
        CALL ADD_BYTES
        POP BC
        DJNZ dnz2
        CALL GADR
        LD A,(HL)
        LD DE,bytsym2
        PUSH DE
        CALL CONV
        POP HL
        LD B,4
        CALL move
        CALL ADD_BYTES
        POP BC
        DJNZ dnz3
        DEC C
        JR NZ,dnz4

        LD A,0
yesrgb  EQU $-1
        AND A
        RET Z

        LD HL,0
nach    EQU $-2

        LD A,(c0)
        LD C,A
dnz11   LD A,(b0)
        Amul8
        LD B,A
dnz10   INC HL
        DJNZ dnz10
        DEC C
        JR NZ,dnz11

        LD A,(c0)
        LD C,A
dnz13   LD A,(b0)
        LD B,A
dnz12   PUSH BC
        PUSH HL
        LD A,(HL)
        LD DE,bytsym3
        PUSH DE
        CALL CONV
        LD HL,dbsym1
        LD B,4
        CALL ADD_BYTES
        POP HL
        LD B,5
        CALL move
        CALL ADD_BYTES
        POP HL
        INC HL
        POP BC
        DJNZ dnz12
        DEC C
        JR NZ,dnz13
        RET
;-----------------------
move    LD B,4
        LD A,(HL)
        CP "0"
        JR NZ,ok1
        INC HL
        DEC B
ok1     LD A,(HL)
        CP "0"
        RET NZ
        INC HL
        DEC B
        RET

GADR    LD HL,#C000
        PUSH HL
        INC HL
        LD (GADR+1),HL
        POP HL
        RET

ADD_BYTES
dnz1    PUSH BC
        PUSH HL
        LD A,(HL)
        CALL ADD_BYTE
        POP HL
        INC HL
        POP BC
        DJNZ dnz1
        RET

ADD_BYTE
        LD HL,(badr)
        LD (HL),A
        INC HL
        LD (badr),HL
        LD HL,(total)
        INC HL
        LD A,H
        OR L
        JP Z,BIG_FILE
        LD (total),HL
        LD HL,(bbyte)
        INC HL
        LD (bbyte),HL
        LD DE,lbuff
        AND A
        SBC HL,DE
        CALL Z,FLUSH
        RET

Flush   LD HL,(bbyte)
        LD A,H
        OR L
        RET Z
FLUSH   LD HL,(FR_FLUSH)
        LD B,0
        LD C,high lbuff
        ADD HL,BC
        LD (FR_FLUSH),HL

        LD HL,(FREE_SEC)
        LD DE,(FR_FLUSH)
        AND A
        SBC HL,DE
        JP C,OFF_DISK

        LD HL,buffer
        LD DE,(TEK_SEC)
        LD B,high lbuff
        LD C,#06
        LD A,DOS_FUNC
        CALL GUI
        JP C,errsp
INI_BUFF:
        LD HL,buffer
        LD (badr),HL
        LD HL,0
        LD (bbyte),HL
        RET

FR_FLUSH DW 0

OFF_DISK
        LD IX,WOff
        JR mess

BIG_FILE
        LD IX,WBig
mess    LD A,Window
        CALL GUI
        LD A,NOKEY
        CALL GUI
        LD A,WAITKEY
        CALL GUI
        CALL CLOSE
        JP errsp

WOff    DB 9,8,14,5,2*8+7,7,%1111,0
        DW TOff
        DW #FFFF
TOff    MSG_Attent : DB 13   ; DB " !",13
        MSG_DiskFull : DB 0  ; DB " _",0

WBig    DB 9,7,14,6,2*8+7,7,%1111,0
        DW TBig
        DW #FFFF
TBig    MSG_Attent : DB 13   ; DB "    !",13
        MSG_BigData          ; DB "  ",13
        DB 0                 ; DB "    _",0

CONV    LD C,0
        EX AF,AF'
        LD A,GET_NUM
        JP GUI

C1NV     ld c,1
         ld a,GET_NUM
        jp GUI

;-----------------------------------------------------
;           *** SpriteCut Animator ***
;-----------------------------------------------------

bghex01        and #0F
               ld c,48 ; "0"
               cp 10
              jr c,1F
               ld c,55 ; "A"-10
1              add a,c
               ld (hl),a
               inc hl
              ret

normAMwin    ;     
               call AddRam
               ld a,(Delay_)     ; delay
               or a
              jr nz,1F
               inc a
               ld (Delay_),a
1              ld de,TSPR.delay
               call CONV

               ld a,(Bground)    ; Bground
               ld hl,TSPR.bg
               ld b,a
               rrca
               rrca
               rrca
               rrca
               call bghex01
               ld a,b
               call bghex01

               ld hl,TReplay
               ld de,TSPR.mode
               ld a,(Mode_)
               ld bc,8
               or a
              jr z,1F
               add hl,bc
1              ldir
               ld hl,TFragment
               ld de,TSPR.cirkl
               ld c,8     ; b also ==0
               push de
               ldir
               pop de
               ld a,(AniType)
               or a
              jr nz,1F
.n_            xor a
               ld (AniStart),a
               ld a,(All)
               dec a
               ld (AniEnd),a
              ret
1              ld a,(All)
               or a
              jr z,.n_
               dec a
              jr z,.n_
               ld c,a
               ld a,(AniStart)
               cp c
              jr c,1F
               xor a
               ld (AniStart),a
1              ld b,a     ; (AniStart)
               inc c      ; (All)
               ld a,(AniEnd)
               cp c
              jr c,1F
               ld a,c
               dec c
               ld (AniEnd),a
1              cp b
              jr c,.n_
              jr z,.n_
               ld de,TSPR.cirkl+5
               push bc
               call CONV
               pop bc
               ld a,b
               ld de,TSPR.cirkl
              jp CONV

Ch_AMode      ;      
             ld a,(Mode_)
             cpl
             and 1
             ld (Mode_),a
            jr set_delay.noclose

set_delay     ;  
             ld hl,TSPR.delay
             ld de,#0910
             ld b,3
             xor a
             ex af,af'
             ld a,EDIT
             call GUI
           jr c,.noclose
             ld hl,TSPR.delay
             xor a
             ld (TSPR.delay+3),a   ;    v 3.o5
             ld bc,#FFFF
             ld a,ASCII
             call GUI
             ld a,32
             ld (TSPR.delay+3),a
            jr c,.noclose
             ld a,l
             ld (Delay_),a
.noclose    jp noclose

set_bg
              call PRGB2
              call GetATR
              ld (Bground),a
             jp noclose

set_ani       ;  
             ld hl,Wset_ani
             call pupmnu
.l0          ld a,%1110
.l1          ld ix,Wset_ani
             ld (ix+6),a
             ld a,Win
             call GUI
             push af
             call CLOSE
             call NOKEYM
             pop af
             cp #FF
            jr z,.exit
             or a
            jr nz,.selframe
.setall_     ld (AniType),a   ; 0
.exit       jp noclose
.selframe    call IDL
             ld a,(All)
             or a
            jp z,NoSpr
             dec a
             ld b,a
             cp 2
            jr c,.setall_
             push bc
             xor a
             ld (teksp),a
             ld hl,Start
             call SelSpr
             call NOKEYM
             call CLS
             ld b,25
1            halt
            djnz 1B
             pop bc
             ld a,(teksp)
             ld c,a
             cp b
            jr z,.exit2
             ld (AniStart),a
             inc a
             cp b
            jr z,1F
             ld (DNSPR.first),a
             ld (teksp),a
             push bc
             ld hl,Start
             call SelSpr_
             call NOKEYM
             pop bc
             ld a,(teksp)
1            ld (AniEnd),a
             ld a,1
             ld (AniType),a
.exit2      jp Start

Wset_ani    DB 0,0,12,4,6*8,6,%1110,0
; Bit 0 -   /
; Bit 1 - ""  /
; Bit 2 -     /
; Bit 3 -   -     (CANCEL)
    DW .txt        ; -
    DW .sel       ; - ()
    DW Nil         ;  
    DW #FFFF

.txt     MSG_Allsprts  : DB 13  ; All sprites
         MSG_SelFrag   : DB 13  ; Select a fragment
         DB 0

.sel     DB 1,1,10,1,%11
         DB 1,2,10,1,%11
        DB #FF


CLS_       ld hl,#4000
           ld de,#4001
           ld (hl),l
           ld bc,6144
           ldir
           ld a,(Bground)
           ld (hl),a
           ld bc,767
           ldir
          ret
CLSani     call CLS_
           rrca
           rrca
           rrca
           and #07
1          out (#FE),a     ; set border at Bground paper
          ret
retBorder  ld a,(BORDER)
           jr 1B

StartANI    ;  

            call NOKEYM
            call IDL
            ld a,(All)
            or a
           jp z,NoSpr
            dec a
           jp z,noclose

            ld a,(Mode_)         ;    ?
            or a
            ld a,#C3  ; JP nn
           jr z,1F
            ld a,1    ; ld bc,nn
1           ld (PenduRet),a

            ld c,0
AniStart EQU $-1 ; number of start position
            ld a,255
AniEnd   EQU $-1; number of end position
            sub c
           jp c,noclose
            inc a
            push af        ;   >1
            ld (cadres),a
            cp 3
           jr nc,1F
            ld a,#C3   ; JP nn
            ld (PenduRet),a  ;  
1           dec a : dec a
            ld (cadres_),a
            call CLSani
            ld (rmx),bc   ; bc=0 after CLSani
            ld a,(AniStart)
            call Search
             ex af,af'
             ld a,b
             ld (old_size),a
             ld a,c
             ld (old_size+1),a
             pop af
             ld ix,buffer  ;    :>  [ DW AddrSpr : DB dx,dy,fl ]
1            ex af,af'
             ld (ix+0),e
             inc ix
             ld (ix+0),d
             inc ix         ; addres in RAM
             ld (ix+0),b
             inc ix
             ld (ix+0),c
             inc ix         ; width , height
             ld (ix+0),a
             inc ix         ; format

             ld e,(hl)
             inc hl
             ld d,(hl)
             ld bc,Sprites
             ex de,hl
             add hl,bc
             ex de,hl      ;de - next addr in ram
             ld bc,4
             add hl,bc     ; hl - new TABLICA
             push hl
             inc hl
             inc hl
             ld b,(hl)
             inc hl
             ld c,(hl)
             inc hl
             ld a,(hl)
             pop hl

             ex af,af'   ; number
             dec a
            jr nz,1B
             halt
             ld ix,rmx
AniRUN
             ld hl,buffer
             ld b,0       ; 0=256
cadres    EQU $-1
1            ld e,(hl)
             inc hl
             ld d,(hl)
             inc hl
             ld a,(hl)
             ld (rmx+2),a
             inc hl
             ld a,(hl)
             ld (rmx+3),a
             inc hl
             ld a,(hl)
             ld (rmx+4),a
             inc hl
             call AniOut_
            jr nz,endAni_
            djnz 1B

PenduRet     jp AniRUN       ; [jp AniRUN] or [ld bc,AniRUN]

              ld bc,#FFFB   ; bc=-5
              add hl,bc

             ld b,254
cadres_    EQU $-1
1            dec hl
             ld e,(hl)
             dec hl
             ld a,(hl)
             ld (rmx+3),a
             dec hl
             ld a,(hl)
             ld (rmx+2),a
             ld a,e
             ld (rmx+4),a
             dec hl
             ld d,(hl)
             dec hl
             ld e,(hl)
             call AniOut_
            jr nz,endAni_
            djnz 1B
            jp AniRUN

endAni_    ld a,(BORDER)
           out (#FE),a
          jp Start

AniOut_      push hl,bc
             call LoadAni   ;  
            ;  
             ld bc,(old_size)
             ld hl,(rmx+2)
             ld a,c       ; x
             dec a
             sub l
            jr c,.y_
             inc a
             push bc,hl
             ld h,0
             ld c,a
             call WClean
             pop hl,bc

.y_          ld a,b ;  y
             dec a
             sub h
            jr c,.e_
             inc a
             ld l,0
             ld b,a
             call WClean

.e_          ld hl,(rmx+2)
             ld (old_size),hl
             ld b,8
Delay_   EQU $-1     ;  
1            halt
             push bc
             ld a,BUTTON
             call GUI
             pop bc
             or a
            jr nz,2F
            djnz 1B
2            pop bc,hl
           ret

;-----------------------------------------------------
old_size   DB 0,0
Mode_      DB 0    ;  0 -   (Replay), 1 -   (Pendulum)
AniType    DB 0    ; animation type 0 - complete, 1 - start-end position
;-----------------------------------------------------
AdrHL8       ld a,h     ; HL -  /DA
             rrca
             rrca
             rrca
             and #E0
             or l
             ld l,a
             ld a,h
             and #18
rasch        or #40
             ld h,a
            ret

;    : L - x , H - y ; C - sx , B - sy
WClean        push de
              ld a,h
              rrca
              rrca
              rrca
              and #E0
              or l
              ld l,a
              ld a,h
              and #18
              or #40
              ld h,a        ; HL - 
              push hl
              ld a,b
              ex af,af'
              ld d,b
1             ld e,4
2             ld b,c
              xor a
3             ld (hl),a
              inc l
             djnz 3B
              inc h
              ld b,c
4             dec l
              ld (hl),a
             djnz 4B
              inc h
              dec e
             jr nz,2B
              ld a,l
              add a,32
              ld l,a
             jr c,5F
              ld a,h
              sub 8
              ld h,a
5             ld a,h
              cp #58
             jr nc,6F
              dec d
             jr nz,1B
6             pop hl
              ld a,h
              rra : rra : rra
              and 3
              or #58
              ld h,a    ; hl -   
              ex af,af' ; a - sy
              ld d,a
.cla_
1             ld b,c
              ld e,l
2             ld (hl),7   ;   
Bground     EQU $-1       ; color of screen for animation ( border= [Bground/8] and 7 )
              inc l
             djnz 2B
              ld a,32
              add a,e
              ld l,a
             jr nc,3F
              inc h
3             ld a,h
              cp #5B
             jr nc,4F
              dec d
             jr nz,1B
4             pop de
             ret

; A -  /

LoadAni    push af
           call LoadWS
           pop af
           or a
          jp nz,LoadWA
           ;   
           push de
           ld bc,(rmx+2)
           ld d,b
           ld hl,#5800
          jr WClean.cla_


;-----------------------------------------------------

name    DB "SPR"
        DB "000"
lbuff   EQU 1024
total   DW 0             ;    
dbsym   DB #09,"DB "
bytsym1 DB "000,"
bytsym2 DB "000",13,10
dbsym1  DB #09,"DB "
bytsym3 DB "000",13,10
bbyte   DW 0
badr    DW buffer

RETURN  XOR A
RETAD   JP 0
head    DB "SPR-"

LEN=$-PgnAdr
buffer  DS 1275    ; lbuff

      DISPLAY "SpriteCut len :",/a, LEN
       ASSERT  $ < #C000

         ORG #C000
Head     DS 4
All      DB 0
FloatTab DW TABLICA
Float    DW Sprites
teksp    DB 0
TABLICA  DS 1275; next(2),x(1),y(1),flag(1)
Sprites  NOP

      ;   ORG BGE_RUN

         savebin "spriter.add",START,LEN

         LabelList     ; LABELSLIST  "spriter.l"

