;        Main file of Burial Graphics Editor v4.0--            ;
;                         (2020-2022)                          ;
;                                                              ;
; Assembler: SjASMPlus Z80 Cross-Assembler v1.20.3             ;
;            (https://github.com/z00m128/sjasmplus)            ;
; OS:        Linux and Wine                                    ;
; Emulators: Xpeccy, Fuse, Unreal Speccy, RVM                  ;
;                                                              ;
; Included modified GUI sources                                ;
;                                                              ;
;                  based of                                    ;
;                                                              ;
;                                                              ;
;                Sources Burial Gfx Editor v.3.o5              ;
;                            (2ooo-2oo1)                       ;
;                                                              ;
;                      Open Sources for PHAT01                 ;
;                          Official releaze                    ;
;                       (without Supreme-GUI)                  ;
;                                                              ;
; Assembler: Alasm 4.42                                        ;
; Computer : Kay 1o24 (64pages)                                ;
;                                                              ;
; (c) Copyright Delirium Tremens from Freedom                  ;
; (c) Copyright Sinn from Delirium Tremens                     ;
;                                                              ;
;..............................................................;


; COMPILE EQU 1 ; flag 0 - for edit compilation  ;; not used /DA
;               ; flag 1 - for full compilation  ;; only used
;...............................................................
;  BurGE 3.xx
;
   DISPLAY "Compile BGE v4.0 (2022)"
   DISPLAY "Based of Burial Gfx Editor v.3.o5 and Supreme-GUI"
   DISPLAY "(c) Copyright Delirium Tremens from Freedom"
   DISPLAY "(c) Copyright Sinn from Delirium Tremens"
   DISPLAY "(2ooo-2oo1)"
   DISPLAY " "

        device  zxspectrum128




BeginGUI EQU #C800
SCREEN   EQU #C000
UNDOSCR  EQU #C000+6912
ScrPage  EQU 0
SuxPage  EQU 1
GUIPage  EQU 3
AddPage  EQU 4
PgnPage1 EQU 6
PgnPage2 EQU 7
RamPage  EQU 7
PgnAdr   EQU #A500
AddAdr   EQU #C000
Buffer   EQU #C000-#400
SCRSPR   EQU #C000
ATRSPR   EQU SCRSPR+6144
SCRBGE   EQU #C000+6912
A_PGN1   EQU #C000  ;   
A_PGN2   EQU #DB00  ;   
LEN_PGN  EQU 6912   ; .  
MINPAGE  EQU 255    ; .   BGE256

SysBuff  EQU #DB00+6912 ;   2560    0 (ScrPage)
                        ;    
                        ;        (25x20  4500 ),
                        ;    
                        ;  NEWCAT   2048 
                        ;         
;...............................................................





    INCLUDE "Version.asm"

    page    GUIPage
    ORG #C000
    INCLUDE "local.asm"    ; Load Font and Local Resurces
    INCLUDE "local_.asm"   ; Set Define ID LOCAL

         ;   add/LOCAL/

            LUA PASS1
            -- trim implementations /from https://www.folkstalk.com/2022/09/lua-trim-with-code-examples.html
            function trim1(s)
                return (s:gsub("^%s*(.-)%s*$", "%1"))
            end
            -- from PiL2 20.4
            ENDLUA

            MACRO INCBIN_ADD_L p00000001
              LUA ALLPASS
               local stra = "add/"..trim1(sj.get_define("LOCAL")).."/"
               local strb = trim1(sj.get_define("p00000001",true))
               if (sj.file_exists(stra..strb))
                  then sj.insert_define("_p0000002",stra..strb)
                  elseif (sj.file_exists("add/"..strb))
                      then sj.insert_define("_p0000002","add/"..strb )
                  elseif (sj.file_exists("add/en/"..strb))
                      then sj.insert_define("_p0000002","add/en/"..strb)
                  elseif (sj.file_exists("add/ru/"..strb))
                      then sj.insert_define("_p0000002","add/ru/"..strb)
               end
              ENDLUA
              IFDEF _p0000002
               INCBIN _p0000002
               UNDEFINE _p0000002
              ENDIF
            ENDM

    ORG #6000
    INCLUDE "PGNJP.asm"
    DISPLAY " End PGNJP adr : ",$

          ASSERT  $ < #6101
          ORG #6100
BGE_SYS_VERSION  DB "B", BGE_SYSVERSION   ; "B" + 7 bytes for identify BGE version in plagins /DA v4.0


; ---------- window x8/x1 variables ------------

TEKNALOZ  DB 0       ;    
.x8       DB 0
.x1       DB 0

WinX8                ; positions of the selected window x8 /    x8
.cx       DB 0  ;+0
.cy       DB 0  ;+1
.csx      DB 32 ;+2
.csy      DB 24 ;+3

WinX1                ; positions of the selected window x1 /    x1
.x        DB 0
.y        DB 0
.sx       DB 255
.sy       DB 191

WinXU               ; positions of the currently saved window /    
                    ; used when copying, converting x8<->x1 and in 'Modify' .
                    ; /   ,  x8<->x1   ''.
.x        DB 0  ;+0   -     x
.y        DB 0  ;+1   -     y
.csx      DB 0  ;+2   -     x
.csy      DB 0  ;+3   -     y
.dx       DB 0  ;+4   -     
.dy       DB 0  ;+5   -     y
.px       DB 0  ;+6   -     x
.py       DB 0  ;+7   -     y
.dsx      DB 0  ;+8   -     x
.dsy      DB 0  ;+9   -     y

LWinXU              ;    
                    ;   , . 
                    ; (    WinXU     )
.x        DB 0  ;+0   -     x
.y        DB 0  ;+1   -     y
.csx      DB 0  ;+2   -     x
.csy      DB 0  ;+3   -     y
.dx       DB 0  ;+4   -     
.dy       DB 0  ;+5   -     y
.px       DB 0  ;+6   -     x
.py       DB 0  ;+7   -     y
.dsx      DB 0  ;+8   -     x
.dsy      DB 0  ;+9   -     y
; ---------- end window x8/x1 variables ------------

    ASSERT  $ < #6129
    ORG #6128
    INCLUDE "GuiVar.asm"

    ASSERT  $ < #61C1
    ORG #61C0              ; RAM-driver for extended memory    /v3.12
PG_NOTUSED DB 0      ;       ( >7 )  0
EXRAM_DRV  DS 64     ; place for ram_driver 64 Bytes max

    ;     
ExtMem_  DB 0        ; setup extend mem
ExtMem   DB 0        ; extend memory flag
ExtPage  DB 0        ;   

;RSCT -  64   
; ,  
; RamDisk' (256 ).
RSCT    EQU     23296    ; #5B00

; RPAGE  TKARD 
; Ram Disk'
RPAGE   DB      0 ;     RAM- -   v3.12
TKARD   DB      0 ;   RAM-

           DB 0
TABL_PG    DS 64
           DB 0

ONPAGE   push bc    ; c : HL,DE,BC
         push hl
         ld c,a
         ld b,0
         ld hl,TABL_PG
         add hl,bc
         ld a,(hl)
         pop hl
         pop bc
;     A
EX_RAM  DI
         push hl
         push de
         push bc
         push af
         call EXRAM_DRV
         pop af
         pop bc
         pop de
         pop hl
         ei
        ret

;        

ExtPgns  DB 0      ;      

VAerosol   ;      VAerosol.type
.xy     DB 13,2    ; x,y 
.type   DB 0      ;  0-dithering , 1-pixeling
.s_i    DB 4,2
.mods   DB 2,0
;.bt2    DB 0


ramDRVname DB "bgeRAMdrram",0

        INCLUDE "ResGUI.asm"
        INCLUDE "Disk1.asm"
        INCLUDE "Coord1.asm"

;ESA        :[ Commits Delated ] /DA v3.12


RUN
.a_

; ---------------------------------------
; -    -    :[ Commits Delated ] /DA v3.12
; ---------------------------------------

.b
; ---------------------------------------
Main    LD SP,0
SPP     EQU $-2

main_l    CALL LOADSCR

main      ld sp,(SPP)
          call ERASE_ALLW
;          ld a,Fire2Cancel_Y  ;ArrCancel_Y   ;  cancel  fire2 /DA
;          call GUI
          call Fire2Cancel_Y_
        CALL IniVar
        LD IX,MWin

        LD (IX+6),%1000    ;A
        CALL Win_
         push af
         ld a,SuxPage|#10
         call Ram
         ld a,(Fl_hide_menu)
         or a
         call nz,MWin_Int.ld_winall ;   ,  
         call RAM_N
         pop af
         CP #FF
        JR Z,lookde2_
        LD BC,TBMain
        call TAB_JP
       jr main

lookde2_
        LD A,(BRK)
        BIT 1,A
        JP Z,lookde2
        LD IX,WC
        CALL POPUP

        CALL Win_

        CALL CLOSE_
        CP #FF
        JP Z,main
        LD BC,TBPup
        JP TAB_JP

ReWin
        call LoadScr_CLW
.i      CALL IniVar
        LD IX,MWin
        LD A,%1000  ; %1001
        LD (IX+6),A
        CALL Window_
        RET

LoadScr_CLW   call ERASE_ALLW
             jp LOADSCR

main_   CALL CLOSE_ALLW
        JP main

Main_SV CALL SAVESCR

       jr lookdel.m

lookdel CALL LOADSCR
.e      CALL NOKEY_
.m      JP Main

lookde2 CALL LOADSCR
        CALL NOKEY_
         xor a
         ld (LAST_KEY),a
        CALL WAITKEY_
         ld a,(LAST_KEY)  ;       /DA
         cp "L"
        jr z,1F
         cp "l" ; "l"
        jr nz,2F
1        call SCram.a ;SwapSCRS
       jr lookde2
2      ;  CALL NOKEY_
         sub "1"          ;     
        jr c,3F
         cp 5
        jr nc,3F
         call SetSlot_n
        jr lookde2
3        call SAVESCR  ;   ( FUSE) -  -   /DA
       jr lookdel.e

TBPup   DW EMgn
        DW SCRAM
        DW UNDO
        DW dldscr
        DW dsvscr
        DW EMgn

WC      DB 0,0,8,7,5*8,5,%1110,0
        DW Twc
        DW Swc
        DW #FFFF
Twc
  ;  if rus
  ;      DB #8B, #E3, #AF, #A0, 13; 
  ;      DB #8E, #A1, #AC, #A5, #AD, #EF, #E2, #EC, 13; 
  ;      db #8a,#ae,#e0,#a7,#a8,#ad,#a0,13;DB "",13
  ;      db #8e,#e2,#aa,#e0,#eb,#e2,#ec,13;DB "",13
  ;      DB #91, #AE, #E5, #E0, #A0, #AD, #A8, #E2, #EC, 0; ;DB "",13
  ;  else
  ;      DB "Magnify",13
  ;      DB "Exchange",13
  ;      db "Undo",13
  ;      db "Load",13
  ;      DB "Save",0
  ;  endif
           MSG_pMGN : DB 13
           MSG_ExSCR_Exch : DB 13
           MSG_pUndo : DB 13
           MSG_DISK_Load : DB 13
           MSG_DISK_Save : DB 0



Swc
        DB 1,1,6,128+5,%11
        DB #FF


;-----------------

IniVar
        ld a,ARW_DEFAULT   ;   
        call GUI
        LD HL,Ret
        LD DE,Ret
        CALL SInt1
        LD HL,Main_IntP
        LD A,PUT_INT
        CALL GUI
        LD HL,Main_IntG
        LD A,GET_INT
        CALL GUI
        LD HL,COOR_N
        LD (COOR_P+1),HL
        LD A,ARW_OLD
        CALL GUI
        CALL NormSpd
        XOR A
        LD (ARWXMN),A
        LD (ARWYMN),A
        DEC A
        LD (ARWXMX),A
        LD A,191
        LD (ARWYMX),A
        RET

NormSpd LD HL,STEPN
        LD DE,STEP
        LDI
        LDI
        LDI
        RET

STEPN   DEFB 6
LEVELN  DEFB 10
SPEEDN  DEFB 1

SInt1   LD (IntP1),HL
        LD (IntG1),DE
        RET

TBMain  DW EDisk
        DW EPgns
        DW EWin8
        DW EWin1
        DW EBox
        DW ERGB
        DW EMgn
        DW EScreens
        DW EFill
        DW EObjects
        DW Ebrushes
        DW Eaerosol
        DW Esprites
        DW EMisc
        DW UNDO
        DW lookdel
        DW EObjects



Exit_DOS
         call ScrRam
         ld hl,#0000
         push hl
        jp #3D21


;EChBut  LD HL,(manbut)
;    ;    CPHL0
;        LD A,H
;        OR L
;        JR Z,chbut2
;        AND A
;        SBC HL,HL
;chbut0  LD (manbut),HL
;        JP Main
;chbut2  LD HL,BUTTONS
;        JR chbut0

EChBut     ld hl,(manbut)
           ld a,h
           or l
           ld hl,BUTTONS
          jr z,1F
           ld hl,#0000
1          ld  (manbut),hl
          jr 1F   ; SUNDO .1

SUNDO     CALL SV_UNDO
1        JP Main

;EMask   LD A,3

;         call SWPGN2
;         call BMask
;       jp exitSWpgn


EWin8
         xor a
.ovr     ld (OVR_proc),a
         ld a,WinMenu_Num  ; 4
    ;    jr JPclSWP1
JPclSWP1  jp callSWP1
EWin1    ld a,1
         jr EWin8.ovr


LOUPE    call ERASE_ALLW     ;     (   ) /DA
         ld hl,(SPP)
         ld (ELOUPE.spp),hl
         ld (SPP),sp
         ld hl,ELOUPE
        jr EMgn.a
EMgn
        ld hl,exitMGN.mgn
.a      ld (exitMGN.adr),hl
        ld a,Mgn_Num
exeSWP1   call SWPGN1   ;     /DA
1       jp PgnAdr
exeSWP2   call SWPGN2   ;     /DA
        jr 1B

callSWP1  call exeSWP1
exitSWpgn call retSWpgn        ;        /DA
          jp Main

EBox      LD A,Box_Num   ; 1
          call exeSWP1
        jr retSWpgn

EBoxU     ld a,Box_Num           ;     ; v3.12 /DA
          call SWPGN1
          call EBOX_u
         jr exitSWpgn

EMisc   xor a    ;  ld a,Misc_Num ; 0
       jr callSWP2

ECOORD    ld a,Cxy_Num   ; 9
         jr callSWP1    ; v4.0 ,v 3.12 /DA

EFill     ld a,Fill_Num  ; 2
callSWP2 call SWPGN2   ;     /DA
         call PgnAdr
        jr exitSWpgn


EScreens  ld a,MScreen_Num  ; 3
          call SWPGN1
          call MScreen

exitMGN
          call SV_ADEF.arr
          call retSWpgn       ;  /DA  exitMGN.adr
         jp 0
.adr  EQU $-2
.mgn     ld sp,(SPP)
         jp Main
ELOUPE   ld sp,(SPP)
         ld hl,0
.spp    EQU $-2
         ld (SPP),hl
         ret

EObjects   ld a,Objects_Num  ; 8

jpSWP2    call exeSWP2
        jr retSWpgn


Esprites      ld a,3
             jr 1F
Eaerosol      ld a,1
1             ld (StartOVR.num),a
             jp StartOVR
Ebrushes      ld a,2
             jr 1B


SWPGN1       ld b,PgnPage1       ; /DartAlver
wpgn         ld c,a
             push bc             ;          (      )
             call retSWpgn       ;       
             pop bc
wpgn_t     ;  ld a,c
             call pgn_dt_    ; pgn_dt
         ;    or #10
             ld (swpgnPG),a
             call Ram
             ld (sw_pHL),hl
             ld (sw_pBC),bc
           ; jp SWP_HLDEBC   ; LD_UNDO.K_6
            jr tsw_HLDEBC

SWPGN2       ld b,PgnPage2
            jr wpgn

retSWpgn    ld a,0
swpgnPG  EQU $-1
            or a
            ret z
            call Ram
            xor a
            ld (swpgnPG),a
            ld hl,0
sw_pHL  EQU $-2
            ld bc,0
sw_pBC  EQU $-2
            ld de,PgnAdr
tsw_HLDEBC jp SWP_HLDEBC   ; LD_UNDO.K_6


;pgn_dt_ ld a,c
;pgn_dt  push bc       ;  a -    ,
;        ld bc,TBPgns  ;  hl -  .  , bc -  , de = #A500    , a =  b ()
;        add a,a
;        add a,a
;        ld h,0
;        ld l,a
;        add hl,bc
;        DEFHL1
;        push DE
;        DEFHL1
;        push DE
;        pop BC
;        pop HL
;        ld de,PgnAdr
;        pop af
;        ret

pgn_dt_        ld a,c       ;  c -    , b -  
               ld de,TBPgns ;  hl -  .  , bc -  , de = #A500   
               add a,a      ; a - 
               add a,a
               ld l,a
               ld h,0
               ld a,b
               or #10
               add hl,de
               ld e,(hl)
               inc hl
               ld d,(hl)
               inc hl
               ld c,(hl)
               inc hl
               ld b,(hl)
               ex de,hl
               ld de,PgnAdr
              ret




CALLSWPhl  ld a,#FF          ;     -    
CALLSWPhlA ld (.Param),hl    ;        HL     A
           ld (.Proc),de     ;  DE -  , HL - , B - , C -  
           ld (callSWAPbc_.ramA),a      ; A -   
           call pgn_dt_           ;   ix,    /  
           push hl,de,bc,af

           call callSWAPbc_

           ld hl,0
.Param    EQU $-2
           ld (ReWinOUT_.sp),sp
           call Ret
.Proc     EQU $-2
           pop af,bc,de,hl

           call SWAP_bc
          jp RAM_N


ReWinOUT_        ;       WinCutLoupe  'Boxes.asm'
           ld (.sp1),sp
           ld sp,#0000
.sp  EQU $-2
           pop af,bc,de,hl
           ld sp,#0000
.sp1  EQU $-2
           push hl,de,bc,af
           call SWAP_bc
           call WinClipping.outWinBoof_
           pop af,bc,de,hl
callSWAPbc_  call SWAP_bc
.ramA  EQU $+1 :  ld a,0
           cp #FF
          ret z
          jp Ram_



;TBPgns  DW MiscPgn,LMisc   ; [00]
;        DW BoxPgn,LBox     ; [01]
;        DW FillPgn,LFill   ; [02]
;        DW CnkPgn,LCnk     ; [03]
;       ; DW WinPgn,LWin8
;        DW WinMenuPgn,LWinMenu   ; [04]
;       ; DW WinP,LWin1      ; [05]
;        DW COLORpgn,LColor  ; [05]  RGB 
;        DW TexturePgn,LTexture ; [06] ;FntPgn,LFnt ;ChrPgn,LChr
;    ;dw ChrPgn,LChr
;        DW MgnPgn,LMgn     ; [07]
;        DW ObjectsPgn,LObjects  ; BoxPgn,LBox  ;FntPgn,LFnt     ; [08]
;        DW CxyPgn,LCxy        ;  DW DithCanPGN,LDithCan ; BrsPgn,LBrs     ; [09]
;        DW CxyPgn,LCxy     ; [10]
;     ;  DW HackPgn,LHack   ; [11]    ;      /DA
;        DW BoxPgn,LBox     ; [11] DW FILESPgn,LFCOM  ; [11]   ; /DA  ***************************************
;     ;  DW PMaskPgn,LPMask ; [12]   ; /DA
;        DW MScreenPgn,LMScreen ; [12] ; /DA

TBPgns     DW MiscPgn,LMisc         ; [00]
           DW BoxPgn,LBox           ; [01]
           DW FillPgn,LFill         ; [02]
           DW MScreenPgn,LMScreen   ; [03]
           DW WinMenuPgn,LWinMenu   ; [04]
           DW COLORpgn,LColor       ; [05]
           DW TexturePgn,LTexture   ; [06]
           DW MgnPgn,LMgn           ; [07]
           DW ObjectsPgn,LObjects   ; [08]
           DW CxyPgn,LCxy           ; [09]


Misc_Num       EQU 0
Box_Num        EQU 1
Fill_Num       EQU 2
MScreen_Num    EQU 3
WinMenu_Num    EQU 4
COLOR_Num      EQU 5
Texture_Num    EQU 6
Mgn_Num        EQU 7
Objects_Num    EQU 8
Cxy_Num        EQU 9




M_MNU   LD IX,m_mnu
        LD A,(MWin)
        LD (IX+0),A
        LD A,(MWin+1)
        LD (IX+1),A
        XOR A
        CALL Ramka8
        JP C,main
    LD A,(IX+0)
        AND A
        JP NZ,main
        LD A,(IX+1)
        CP 23
        JP NC,main
        LD A,(IX+0)
        LD (MWin+0),A
        LD A,(IX+1)
        LD (MWin+1),A
        JP Main

m_mnu   DB 0,0,32,2

   ;    
Fl_hide_menu  EQU $+1      ;    
MWin_Int      ld a,0   ; <- Fl_hide_menu
              or a
             ret z
          ld hl,(MWin)
          ld a,h
          or l
         ret nz                   ;       ,  .
          call .int_
         jp guiRAM

.int_       call SuxRam
            ld a,(ARW_Y)
            cp 24
           jp c,.ld_winall           ;   ,   
            cp 40
           jp c,.ld_win8                    ;   ,  
            cp 48
           ret c
                                ;      .

            ld a,0
.fl_mist_  EQU $-1       ;  : 0 -, 1-6 -, 7 -
            cp 7
           ret nc         ;  
            inc a
            ld (.fl_mist_),a
            dec a
           jr z,1F
            cp 6
           jr z,2F
           ret
1             ;    
             ld hl,#4000
             ld de,#C000
             call .ld_8
             ld hl,#4020
             ld de,#C020
             call .ld_8
             ld hl,#5800
             ld de,#D800
             ld bc,64
             ldir              ; 
                 ;   
             ld hl,#C020
             ld de,#4000
             call .ld_8
             ld hl,#D820
             ld de,#5800
             ld bc,32
             ldir
             call ScrRam
             ld hl,#C020
             ld de,#4020
             call .ld_8
             ld hl,#D820
             ld de,#5820
            jr 3F
2                ;    
             call ScrRam
             ld hl,#C000
             ld de,#4000
             call .ld_8
             ld hl,#D800
             ld de,#5800
3            ld bc,32
             ldir
            ret
.ld_winall    ld a,(.fl_mist_)    ;   ,   
              or a
             ret z
              ld hl,#C000
              ld de,#4000
              call .ld_8
              ld hl,#C020
              ld de,#4020
              call .ld_8
              ld hl,#D800
              ld de,#5800
              ld bc,64
              ldir
              xor a
              ld (.fl_mist_),a
             ret

.ld_win8      ld a,(.fl_mist_)    ;   ,   
              or a
             ret z
              dec a
             jr z,.ld_winall
              ld (.fl_mist_),a
              cp 6
             ret nz
              ld hl,#C020
              ld de,#4000
              call .ld_8
              ld hl,#D820
              ld de,#5800
              ld bc,32
              ldir
             ret

.ld_8        ld b,8
1            push bc
             push hl
             push de
             ld bc,32
             ldir
             pop de
             pop hl
             pop bc
             inc h
             inc d
            djnz 1B
            ret



MWin    DEFB 0,0,32,2,7*8,7,%00001000   ; 0,0,1,1,7*8,7,%00001001
; Bit 0 -   /
; Bit 1 - ""  /
; Bit 2 -     /
; Bit 3 -   -     (CANCEL)
        DEFB 0
       ; DEFW Nil          ; -
       ; DEFW Nil          ; - ()
        DW 2     ;  2- 
        DEFW HMain        ;  
manbut  DEFW BUTTONS      ; - ()
      ;  DEFW Nil          ; -
      ;  DEFW Nil          ; - 
      ;  DEFW Nil          ; 
      ;  DEFW Nil          ;   
        DW 4     ;  4- 
        DW MWin_Int     ;  DEFW Nil          ;   ""
        DEFW #FFFF

HMain   DB "C",0
         DW 5         ; 4 ; 5 ; 6 ; 7
    display "HM",HMain
        DB "K",0
         DW MainCol
        DB SS,"L"
         DW dldscr
        DB SS,"K"
         DW dsvscr
      ;  DB SS,"J"
      ;   DW ELdBLC
        DB 13,0
         DW 15       ; 17 ; 18
        DB "U",0
         DW 14       ; 16 ; 17
        DB "J",0
         DW 16       ; 18 ; 19
        DB "L",0
         DW SCRAM
        DB SS,"T"
         DW SAVERAM
        DB SS,"R"
         DW LOADRAM
        DB "W",0
         DW EWin8
        DB "S",0
         DW EWin1
        DB "M",0
         DW 6           ; 5 ; 6 ; 7 ; 8
        DB SS,"X"
         DW CLSSCRSCR
        DB SS,"C"
         DW CLSATR
        DB "G",0
         DW GRID_SW   ; DW GRIDON
      ;  DB "H",0
      ;   DW GRIDOFF
        DB SS,"H"
         DW GRIDOFF_
;        DB "N",0
;         DW ESolidE
;        DB "F",0
;         DW ETFillE
;        DB SS,"W"
;         DW ETWashE
;        DB CS,"W"
;         DW ETWashe
        DB "D",0
         DW MSCR
;        DB "B",0
;         DW ETekBox
         DB "B",0    ; B -     
          DW EBoxU
        DB "E",0
         DW EChBut
 ;       DB CS,"3"
 ;        DW LDN
 ;       DB CS,"4"
 ;        DW LUP
        DB "Y",0
         DW SUNDO
   ;     DB CS,"J"
   ;      DW JBrush
        DB CS,"I"
         DW ECOORD
        DB "X",0
         DW ETekPgn
        DB "Z",0
         DW 1   ;EPgns     ;EExe256
        DB "Z",SS
         DW ELPgn
        DB SS,"D"
         DW Driv
;        DB CS,"L"
;         DW dldimg_
        DB CS,"K"
         DW dsvimg_
        DB "V",0
         DW M_MNU
        DB CS,"5"
         DW SCROLLLEFT
        DB CS,"6"
         DW SCROLLDOWN
        DB CS,"7"
         DW SCROLLUP
        DB CS,"8"
         DW SCROLLRIGHT

        DB "1",0      ;   
         DW SetSLOT_1
        DB "2",0
         DW SetSLOT_2
        DB "3",0
         DW SetSLOT_3
        DB "4",0
         DW SetSLOT_4
        DB "5",0
         DW SetSLOT_5
        DB "R",0
         DW SwpCurrSLOT


        DB #FF


dsvimg_ CALL dsvimg
1       JP main_
Driv    CALL Driver
       jr 1B         ; JP main_
ELPgn   CALL epgns.LPgn   ; LPgn
       jr 1B         ; JP main_

ETekPgn CALL TekPgn   ; tekpgn
       jr 1B         ; JP main_
MainCol CALL Col
       jr 1B         ; JP main_



BUTTONS  DB %01100000+2,64+0,128+0,2,2     ;    \      /DA v 4.0
.col1    DB 7,%11
         DW DISKS,PGN1S

         DB %01100000+8,64+5,128+0,2,2
.col2    DB 7,%11
         DW WIN8S,WIN1S,BOXS,RGBS,MGFS,EK2S,FILLS,PRIMS

         DB %01100000+5,64+22,128+0,2,2
.col3    DB 7,%11
         DW BRUSHS,DITHCANS,SPRITESS,OTHERS,UNDOS

         DB %01100000+2,%11100000+4,128+0,1,2
.col4    DB 7,%00
         DW SPACES
         DB 21,0

         DB #FF




;---------------------------------------------------------------
        INCLUDE "Screens.asm"
        INCLUDE "Add.asm"
        INCLUDE "Utils1.asm"
        INCLUDE "RGB2.asm"      ; "RGB1.asm"
        INCLUDE "Primitiv.asm"  ; "Primit1.asm"
        INCLUDE "Miniloupe.asm"
        INCLUDE "SPEdit.asm"
        INCLUDE "Selectbox.asm"                ;"FRamka.asm"
   ;     INCLUDE "ScrAdd1.asm"
        INCLUDE "DEBLC.asm"
        INCLUDE "Overlays.asm"
        INCLUDE "Pgns3.asm"       ; "Pgns2.asm"
        INCLUDE "DEHRUST@.asm"
        INCLUDE "winout.asm"
;-------------------------
;-----      
;-------------------------
        ;  :

MSave   LD SP,(SPP)           ;   magnify2.asm  /DA
        LD HL,FNameScr
        CALL FNEdit

       jr c,7F    ; jp c, bmgn.next
        CALL dsvscr_
       jr 7F      ; jp bmgn.next

MLoad   LD SP,(SPP)
        LD HL,SORTscr
        CALL FilerE
       jr c,7F    ; jp c, bmgn.next
        call SaveSCRS
        LD A,(SEC_LEN)
        LD B,A
        EXLOAD #8000,SCREEN,START_SEC,ScrPage
       jr c,7F    ; jp c, bmgn.next
        LD DE,FNameScr
        CALL ToName
7      jp bmgn.next


sOBJnorm
          call Fire2Cancel_Y_
       ;   ld a,ARW_DEFAULT  ;       /DA
      ;    call GUI
      ;    ld a,Fire2Cancel_Y   ; ArrCancel_Y
       ;  jp GUI
         jp ARW_DEFAULT_

;-------------------------------
;---     / DA
;-------------------------------
Texture  ld de,BTexture     ; ld hl,BTexture
          call Texture.exec
          call  PMask.init_
          ld hl,TxBUFF           ;   
          ld de,ITxBUFF          ;   
         ret
.exec
         ld bc,TEXTURE_PG*256+Texture_Num
         call CALLSWPhl
         call NOKEY_

         ld a,0
.fselect EQU $-1   ;  /
         ld hl,TxBUFF   ;TBUFF   ;   
         rra
         ret

;------------------------------------------
;---      
;------------------------------------------
PMask
           call .PmskSwpTx
          ld de,BTexture.Pmask  ; ld hl,BTexture.Pmask
          call Texture.exec
           call .PmskSwpTx

.exit
          call .init_
          ld hl,DMSKbuff          ;  
          ld de,PMSKBUFF          ;    
          ret

.initT    ld hl,TxBUFF
          call .init32FF
          ld a,1
.init     or a
         jr z,.exit      ;.init_
          ld hl,DMSKbuff
          call .init32FF
        jr .exit

.init32FF  ld b,32
1          ld (hl),#FF
           inc hl
          djnz 1B
          ret

.init_    ld a,TEXTURE_PG|#10
          call Ram
          ld de,PMSKBUFF
          ld hl,(DTPMASKS-1)*32+#DB00      ;   
          push hl
          ld bc,32
          push bc
          ldir
          pop bc
          pop hl
          ldir
          call RAM_N                       ;  
          ld hl,PMSKBUFF+4
          ld de,DMSKbuff+4
          call .init_01
          ld hl,ITxBUFF+4
          ld de,TxBUFF+4
.init_01
          ld b,12
1         ld a,(de)
          inc de
          and #3F
          or (hl)
          ld (hl),a
          inc hl
          ld a,(de)
          inc de
          and #FC
          or (hl)
          ld (hl),a
          inc hl
         djnz 1B
         ret

.PmskSwpTx ld hl,TxBUFF
           ld de,DMSKbuff
           ld bc,32
          jp SWP_HLDEBC   ; LD_UNDO.K_6

;--------------------  -------------------
;PERCINI LD IX,WPERC   ;      /DA
;        LD A,Window
;        CALL GUI
;        CALL TABLO
;        RET


WPERC   DB 2,8,27,5,7*8,7,%1111,0
        DW TPERC
        DW #FFFF
TPERC
;    if rus           ;  -    /DA
;        DB #8F, #E0, #AE, #E6, #A5, #E1, #E1, #5F, 13;DB "_",13
;    else
;        DB "Process_",13
;    endif
        MSG_PROCESS : DB 13
        DB 0

ADRPRCN EQU #4963
;-------
;PERC5
;.
;A - INPUT

HEIPRCN EQU 2
LENPRCN EQU 25

PRCN    LD HL,ADRPRCN+#0200
PRCN1B  LD E,A
        SRL A
        SRL A
        ADD A,low ADRPRCN+1;  
        SUB L
        JR Z,PRCN1C
        RET C
        LD C,A
        LD A,E
        AND 3
        JR NZ,PRCN2A
        DEC C
        RET Z
PRCN2A  LD A,%10101010
PRCN1D  LD B,HEIPRCN
        LD H,ADRPRCN/256+2
        LD (HL),A
        INC H
        XOR #FF
        DJNZ $-4
        INC L
        DEC C
        JR NZ,PRCN1D
PRCN1C  DEC L
        LD A,E
        AND 3
        RET Z
        ADD A,A
        LD D,0
        LD B,A
        SCF
        RR D
        DJNZ $-3
PRCN1E  LD H,ADRPRCN/256+2
        LD B,HEIPRCN
        LD A,(HL)
        AND D
        LD (HL),A
        INC H
        DJNZ $-4
        RET

PERCINI    ld ix,WPERC    ;  
           call Window_
TABLO   LD HL,ADRPRCN
        LD C,HEIPRCN+4
        SCF
TABLO1  LD B,LENPRCN
        PUSH HL
TABLO2  SBC A,A
        LD (HL),A
        INC L
        DJNZ TABLO2
        SET 7,(HL)
        POP HL
        DEC L
        SET 0,(HL)
        INC L
        INC H
        LD A,C
        CP 3
        DEC C
        JR NZ,TABLO1
        RET


Fext_nrm      ld a,(de)    ;   in: DE - addr of bufers filetype
              inc de
              cp 'B'
             jr z,1F
              inc de
              ld a,(de)
              dec de
              cp 32
             jr c,1F
              ld a,(de)
              cp 32
             ret nc
1             ld a,32
              ld (de),a
              inc de
              ld (de),a
             ret
.cpExt3_
               ld b,3
               ld de,FILE_TYPE
cpB_HlDe_                 ;     (hl)  (de)  b
1              ld a,(de)
               sub (hl)    ; sub    0
              ret nz
               inc de
               inc hl
              djnz 1B
              ret


; Mgn (loupe) variables and procedures
;-----------------------------------------------------------------
; OldGrd4     ;      4x ->   'SetUp.asm'

OldGrd4_set_fl   DB 0 ;   

Sloupe                         ;     setup
        ld a,Mgn_Num ;7
        call SWPGN1
        call Mgn_CurS
      ;  ld a,ARW_DEFAULT
      ;  call GUI
        call ARW_DEFAULT_
        call retSWpgn

       jp ReSetUp

mgn_cur  call Mgn_CurS
       jp bmgn.next

Mgn_CurS
        ld ix,Wmgn_CURSORS
        call POPUP
        ld a,%1110
1       ld (ix+6),a
        call Win_YRMB
        cp #FF
       jp z,CLOSE
        ld a,%1100
      jr  1B

MGN_set
           ld a,#C9          ; ret   ;      .next  /DA
           ld (bmgn.next ),a
           call bmgn.set_PLOT    ;      /DA
           call IntMagnify.selRMBmod ;    
           call IntMagnify.exSmooth  ;  
MGN_Fscroll ld a,(FlagsMgn_CUR.FireScroll)
            or a
            ld a,#3E   ; ld a,n
            ld c,#01   ; ld bc,nn
           jr z,1F
            ld a,#20   ; jr nz,dis
            ld c,#CD   ; call nn
1           ld (IntMagnify.MOV_COM),a
            ld a,c
            ld (IntMagnify.MOV_CALL),a
            ret


RadiMgn_CUR           ; x,y,  ,, , 
        DB 10,3,0,3,0
.CURview EQU $-1
        DW Mgn_ARW
        DB 10,9,3,3,0  ; 10,3,3,0
.CURrmb EQU $-1
        DW IntMagnify.selRMBmod
       DB #FF

FlagsMgn_CUR
    DB 10,13,6,#FF   ; 15,6,#FF
.PixSmooth EQU $-1
    DW IntMagnify.exSmooth
    DB 10,14,7,#FF   ; 16,7,#FF
.FireScroll EQU $-1
    DW MGN_Fscroll
   DB #FF

MgnCrosspr   DB #10,#10,#10,#FE,#10,#10,#10,#00,#00,#00  ;  
MgnArwspr    DUP 20 : DB #FF : EDUP                      ;     #FF


RMK     DB 0,0,1,1      ;      8x8 ( ,   ..)

SprtIX      ; BOOFER -         GUI
.x      DB 0
.y      DB 0
.sx     DB 0
.sy     DB 0
.rgb    DB 0
.flg    DB 0
.adr    DW #0000


;-------------------------------------------------------------------------------

BmBUFF    DS 34   ;     
LBmBUFF   DS 34



ECODE
LEN=ECODE-#6000

MFree     ;                               ; /DA


     DISPLAY "MFree : ",/a,MFree


;---------------------------------------------------------------
             ASSERT  $ < PMSKBUFF
    ;         ORG #A500-32-32-36-#80    ;     
             ORG #A400
LenMFree  EQU $-MFree   ;    

   DISPLAY "LenMFree : ",/a,LenMFree


PMSKBUFF    DS 32                ;     
ITxBUFF     DS 32                ;    

DMSKbuff   DS 32  ;DUP 32 : DB #FF : EDUP  ;  32   
TxBUFF     DS 32                ;   

BUFF        DS #80               ;   Fill ,     /DA
                                 ;       
ML_BUFF     EQU BUFF+128-60      ;     v4.0

;------------------- INIT PROCEDURES ---------------------------
            ORG #A500

         INCLUDE "SetUp.asm"   ;   
         savebin "bge_ovr0.Cod",PgnAdr,$-PgnAdr  ; SetUp module

;           /Dart Alver
     ;   INCLUDE "Init.asm"
         INCLUDE "InitBGE.asm"

;------------------ END INIT PROCEDURES ------------------------
; -----------------------------------------------------------------------------------------
;   

        savebin "bge_main",#6000,$-#6000

        DISPLAY "(c) Sinn^dtr^fdm^2oo1"
        DISPLAY "Length BGE     :",/a,LEN
        DISPLAY "Free for BGE   :",/a,LenMFree  ; -LenMBrs   ; DMSKbuff-ECODE
        DISPLAY " "
;------------------------------------------------------------------------------------------

; ---------- Aerosol ---------
         INCLUDE "aerosol.asm"
         ASSERT $<#C000
         savebin "bge_ovr1.Cod",PgnAdr,$-PgnAdr  ; 

; -------- Brushes ------------
         INCLUDE "brushes.asm"
         ASSERT $ < #C000
         savebin "bge_ovr2.Cod",PgnAdr,$-PgnAdr  ; 

;----------Sprite Cutter-------------
         INCLUDE "Sprites.asm"
         ASSERT $ < #C000
         savebin "bge_ovr3.Cod",PgnAdr,$-PgnAdr  ; 

; ---------- FNT -------------
     ;    INCLUDE "Fnt1.asm"
     ;    ASSERT  $ < #C000
     ;    savebin "bge_ovr4.Cod",PgnAdr,$-PgnAdr  ;  FNT

; ---------- CHR -------------
     ;    INCLUDE "Chr2.asm"
     ;    ASSERT  $ < #C000
     ;    savebin "bge_ovr5.Cod",PgnAdr,$-PgnAdr  ;  CHR

; ---------- FNT + CHR -------
         INCLUDE "FntChr.asm"
         ASSERT  $ < #C000
         savebin "bge_ovr4.Cod",PgnAdr,$-PgnAdr  ;  FNT

; --------Sprite export--------
       ;  INCLUDE "SprtExport.asm"
         INCLUDE "PgnsList.asm"
         ASSERT  $ < #C000
         savebin "bge_ovr5.Cod",PgnAdr,$-PgnAdr  ;   

; --------Disk service--------
         INCLUDE "DiskSRV.asm"         ; "SpHack.asm"
         ASSERT  $ < SpHCode           ; #C000
         savebin "bge_ovr6.Cod",PgnAdr,$-PgnAdr  ;  

; ---------- Sprite Hacker & About ---------
         INCLUDE "SpH_&_About.asm"     ; "About.asm"
         ASSERT $<#C000
         savebin "bge_ovr7.Cod",PgnAdr,$-PgnAdr  ;  

;DISKS   EQU BGE_SPR
;PGN1S   EQU DISKS+32
;PGN2S   EQU PGN1S+16
;CHRS    EQU PGN2S+16
;WIN8S   EQU CHRS+32
;WIN1S   EQU WIN8S+32
;RGBS    EQU WIN1S+32
;MGFS    EQU RGBS+32
;CNKS    EQU MGFS+32
;NALS    EQU CNKS+32
;EK2S    EQU NALS+32
;FILLS   EQU EK2S+32
;PRIMS   EQU FILLS+32
;BOXS    EQU PRIMS+32
;OTHERS  EQU BOXS+32
;UNDOS   EQU OTHERS+32
;EXITS   EQU UNDOS+32
;OFFS    EQU EXITS+32
;ONS     EQU OFFS+32
;DTRS    EQU ONS+32
;PLOTS   EQU DTRS+32
;LINES   EQU PLOTS+32
;LINES2  EQU LINES+32
;TRS     EQU LINES2+32
;SQS     EQU TRS+32
;CIRCS   EQU SQS+32
;ELPS    EQU CIRCS+32
;RAYS    EQU ELPS+32
;XORS    EQU RAYS+32
;ANDS    EQU XORS+32
;ORS     EQU ANDS+32
;NOPS    EQU ORS+32
;ERASES  EQU NOPS+32
;SETKAS  EQU ERASES+32
;RAMKAS  EQU SETKAS+32
;FILLS2  EQU RAMKAS+32
;AMASKS  EQU FILLS2+32
;NORGBS  EQU AMASKS+32
;WASHS1  EQU NORGBS+32
;BRUSHS  EQU WASHS1+32






;------------------------------------------------------------------------
; Page 3 compilation

;-----------------------------------------------------------------------
;       GUI compilation based of Sinn Supreme-GUI for BGE
;
;  GUI      alasm,  
;  .
;    ,    
;   GUI      'GUI' ( 
;  'ResGUI.asm',     BGE)
;
;     GUI,     BGE
;       '_gui' ,  '_g'
;     '_'
;       .
;
;      Supreme-GUI   .

       DISPLAY " "

        ORG #C800,GUIPage

        INCLUDE "KerGUI.asm"
        INCLUDE "ArrGUI.asm"
     ;   INCLUDE "libGUI.asm"
        INCLUDE "WinGUI.asm"
        INCLUDE "FilerGUI.asm"
        INCLUDE "SortGUI2.asm"  ; "SortGUI.asm"
      ;  INCLUDE "ConvertGUI.asm"
        INCLUDE "SysfGUI.asm"
        INCLUDE "TRdosGUI.asm"
        INCLUDE "WG_GUI.asm"
        INCLUDE "EditGUI.asm"
        INCLUDE "SwapGUI.asm"
        INCLUDE "OthersGUI.asm"
        INCLUDE "AsciiGUI2.asm"    ; "AsciiGUI.asm"
        INCLUDE "MDRV_GUI.asm"

        savebin "bge_3",#C000,$-#C000

;FBUFF  DS 516       ; bufer for files data /DA
FBUFF   EQU  NEWCAT  ;    ,      /DA

      ;--- end GUI---

        DISPLAY "GUI  [all] : ",/a,$-#C000,", [free] :",/a,CAT-$
        ASSERT  $ < CAT
;---------------------------------------------------------------
; Page 6 compilation
       DISPLAY " "

        ORG #C000,PgnPage1

        INCLUDE "Boxes.asm"
Boxes_PG EQU PgnPage1

        INCLUDE "Win.asm"         ;   /DA v3.12
WIN_PG EQU PgnPage1

        INCLUDE "Magnify9.asm"      ; "Magnify8.asm"
MAGNIFY_PG EQU PgnPage1

        INCLUDE "MScreen.asm"        ;   /DA
MScreen_PG EQU PgnPage1

        INCLUDE "Colors.asm"
Colors_PG EQU PgnPage1

        INCLUDE "CoordXY.asm"
CoordXY_PG EQU PgnPage1

P6Free   ;     6 

LenP6Free  EQU  #FFFF-P6Free+1   ;    
        DISPLAY " "
        DISPLAY "LenP6     : ",/a,P6Free-#C000
        DISPLAY "LenP6Free : ",/a,LenP6Free

    savebin "bge_6",#c000,$-#c000
        DISPLAY " "
    ;    DISPLAY "Pgns1 [all] : ",$-#C000,", [free] :",/a,#4000-($-#C000)

        ASSERT $-#C000 < #4000
    ;00c9
;---------------------------------------------------------------
;  Page 7 compilation
       DISPLAY " "

        ORG #DB00,PgnPage2
        INCBIN "bge_spr"     ;    BGE
    ;    ORG #E100            ;    48  16x16 ;  ...

       ORG #DB00+(bgeSPRTnum*32)
sprSPACES
         INCLUDE "Ssprites.asm"  ;  


         INCLUDE "Texture2.asm"    ;
TEXTURE_PG  EQU PgnPage2

        INCLUDE "Objects.asm"        ; 
OBJECTS_PG EQU PgnPage2

        INCLUDE "Misc.asm"
Misc_PG EQU PgnPage2

        INCLUDE "Fill3.asm"
FILL_PG EQU PgnPage2


    ;#025c
P7Free   ;     7 

LenP7Free  EQU  #FFFF-P7Free+1   ;    
        DISPLAY " "
        DISPLAY "LenP7     : ",/a,P7Free-#DB00
        DISPLAY "LenP7Free : ",/a,LenP7Free

    savebin "bge_7",#db00,$-#db00
        DISPLAY " "
  ;      DISPLAY "Pgns2 [all] : ",$-#DB00,", [free] :",/a,#4000-($-#C000)
        ASSERT  $-#C000 < #4000

        DISPLAY " "

;--------------------------------------------------------
;     ( ) /DA  :[ Commits Delated ] /DA v3.12


  ; 

      ;   INCLUDE "WinLoupe.asm"

        DISPLAY " "

 ; [OVB Commits & Delated]  /DA


         DISPLAY " "
;----------------------------------------------------------------------

    ;   LABELSLIST "..\us\user.l"

       ; LABELSLIST "C:/Unreal/user.l"

        LABELSLIST  "user.l"