Unit zFossil;
                                                                                {
 ## zFOSSIL v1.00 by Brian Zhou
 ## FOSSIL v5 Routines for Borland Pascal v7
 ## (C)opyright 1998 by Zoob Software.  All Rights Reserved.
 ## 100% Pure code by Brian Zhou (zoob@most-wanted.com)
 ## Feel free to improve on this code.  Email me your changes.
 ## Distribution of modified copies is not permitted.
 ###############################################################################

 Please send any bug reports, comments, or feedback to me:
 zoob@most-wanted.com

 Almost no code is commented, but if someone really needs commenting, I can
 comment the code in the next release.

 Copyright:
 Free for non-commercial use, only for people not affiliated with Microsoft
 in any way.  You may change the code below for your own use, but do not
 distribute modified versions.  If you think you have made an improvement,
 please contact me at the address shown above.
 You may not remove or modify these comments from the beginning up to "***"!

 Disclaimer:
 Use this code at your own risk!
 This code comes as "as-is", and comes with NO WARRANTY whatsoever.
 I guarantee that this code will only take up space.
 
 Files included in archive ZO-ZFOS1.ZIP:

    FILE_ID .DIZ  <-- BBS description file
    ZFOSSIL .PAS  <-- FOSSIL v5 unit

 Features:

   > Alomst 100% ASM code
   > Very fast
   > Code is small
   > Simple to implement into existing code
 
 History:

   v1.00 : >First public release.

 ***
 }

Interface

Var
  Fossil_Port : Word;

Function  Fossil_Present : Boolean;
Function  Fossil_Install(Port : Word) : Boolean;
Procedure Fossil_SetBaud(Baud : LongInt);
Procedure Fossil_Send(C : Char);
Function  Fossil_Receive : Char;
Function  Fossil_Waiting : Boolean;
Function  Fossil_Carrier : Boolean;
Procedure Fossil_fRX;
Procedure Fossil_fTX;
Procedure Fossil_DTR(State : Boolean);
Procedure Fossil_DeInstall;

Implementation

Uses DOS;

Var
  ExitSave : PoINTer;  B : Word;  BB : Byte;

Function Fossil_Present : Boolean;  Assembler;
Asm
  MOV AH, $04
  MOV DX, $00ff
  INT $14
  CMP AX, $1954
  JE @good
  MOV AL, FALSE
  JMP @fin
  @good:
  MOV AL, TRUE
  MOV AH, $04
  MOV bx, $00
  MOV DX, Fossil_Port
  INT $14
  @fin:
End;


Function Fossil_InstALl(Port : Word) : Boolean;
Begin
  Fossil_Port := Port - 1;
  If Fossil_Present Then Fossil_Install := True Else Fossil_Install := FALSE;
End;

Procedure Fossil_SetBaud(Baud : LongInt);
Begin
  Case Baud Div 100 Of
     3: BB := $43;
     6: BB := $63;
    12: BB := $83;
    24: BB := $A3;
    48: BB := $C3;
    96: BB := $E3;
   192: BB := $03;
   Else BB := $23
  End;
  Asm
    MOV AH, $00
    MOV AL, bb
    INT $14
  End;
End;

Procedure Fossil_Send(C : Char);
Begin
  BB := Ord(C);
  Asm
    MOV AH, $01
    MOV DX, Fossil_Port
    MOV AL, bb
    INT $14
  End;
End;

Function Fossil_Receive : Char;
Begin
  Asm
    MOV AH, $02
    MOV DX, Fossil_Port
    INT $14
    MOV bb, AL
  End;
  Fossil_Receive := Chr(BB);
End;

Function Fossil_Waiting : Boolean;
Begin
  Asm
    MOV AH, $03
    MOV DX, Fossil_Port
    INT $14
    MOV bb, AH
  End;
  Fossil_Waiting := (BB And $01) = $01;
End;

Function Fossil_Carrier : Boolean;
Begin
  Asm
    MOV AH, $03
    MOV DX, Fossil_Port
    INT $14
    MOV bb, AH
  End;
  Fossil_Carrier := (BB And $80) = $80;
End;

Procedure Fossil_fRX;  Assembler;
Asm
  MOV AH, $08
  MOV DX, Fossil_Port
  INT $14
End;

Procedure Fossil_fTX;  Assembler;
Asm
  MOV AH, $0a
  MOV DX, Fossil_Port
  INT $14
End;

Procedure Fossil_DTR(State : Boolean);  Assembler;
Asm
  CMP State, TRUE
  jne @lower
  MOV AL, $01
  JMP @fin
  @lower:
  MOV AL, $00
  @fin:
  MOV AH, $06
  MOV DX, Fossil_Port
  INT $14
End;

Procedure Fossil_DeInstall;  Assembler;
Asm
  MOV AH, $05
  MOV DX, Fossil_Port
  INT $14
End;

{$F+} Procedure Fossil_Exit; {$F-}
Begin
  Fossil_DeInstall;
  ExitProc := ExitSave;
End;

Begin
  ExitSave := ExitProc;
  ExitProc := @Fossil_Exit;
End.
