; ==========================================================================
; Atari "Wild"  Snowflakes
;
; Ken Jennings.   
;
; Atari 8-bits.  Built with mads assembler.
; Tested on Altirra 4.31.
; Should run on anything with 16K or more of RAM.
;
; Not the demo I was hoping for.  Just did not have the time to do more.
;
; Vertically scrolling snowflakes which are per the pattern for the 
; 2025 VCCC3.
; 
; ==========================================================================


; ==========================================================================

; Registers for POKEY
RANDOM = $D20A ; (Read) Random number

; OS Shadow Registers for GTIA
COLOR0 =  $02C4 ; COLPF0 - Playfield 0 color
COLOR1 =  $02C5 ; COLPF1 - Playfield 1 color
COLOR2 =  $02C6 ; COLPF2 - Playfield 2 color (Background for ANTIC modes 2, 3, and F)
COLOR3 =  $02C7 ; COLPF3 - Playfield 3 color (and fifth Player color)
COLOR4 =  $02C8 ; COLBK  - Playfield Background color (Border for modes 2, 3, and F)

; OS Shadow registers for ANTIC.  
SDMCTL = $022F ; DMACTL - DMA Control of ANTIC
SDLSTL = $0230 ; DLISTL - Address of Display List
CHBAS  = $02F4 ; CHBASE - character set

; Registers/defines for ANTIC.
VSCROL = $D405 ; Vertical Fine Scroll 0 to 16 scanlines.

PLAYFIELD_WIDTH_WIDE = %00000011 ; 24 characters/192 color clocks (176 visible)
ENABLE_DL_DMA        = %00100000 ; Enable running the Display List

DL_BLANK_8 = $70       ; 8 Blank Scan lines
DL_LMS     = %01000000 ; Enable Reload Memory Scan address for a graphics line
DL_VSCROLL = %00100000 ; Enable Vertical scrolling for this graphics line
DL_TEXT_7  = $07       ; 5 Color, 20 Columns X 16 Scan lines, 24 (overscan)  bytes/line
DL_JUMP_VB = $41       ; Display List jump to address and start Vertical Blank

; OS Registers 
ATRACT = $4D   ; Atari's "Attract" mode.
SETVBV = $E45C ; JSR Vector to set interrupt vectors
SYSVBV = $E45F ; JMP to end user Immediate VBI


; DOS Registers
DOS_RUN_ADDR = $02E0   ; Execute at the address tored here when file loading completes.


; ==========================================================================
; Page Zero variables.  Just one thing...

CurrentVScroll = $80     ; track vscroll for decrementing


; ==========================================================================

	ORG $4000

	; There is no time to do elegant coding to build rows randomly on the fly.
	; Simply put it all in the can and repeat.
	;
	; 24 bytes each line (horizontal overscan).  
	; 15 lines fill the screen (vertical overscan)
	; 170 lines in 4K. We won't be using all that.
	 
	; COLPF0 == 0,1,2,3,4,5,6,7,8             $10,$11,$12...
	; COLPF1 == p,q,r,s,t,u,v,w,x             $30,$31,$32...
	; COLPF2 == 0,1,2,3,4,5,6,7,8 + inverse = $90,$91,$92...
	; COLPF3 == p,q,r,s,t,u,v,w,x + inverse = $d0,$d1,$d2...
	
SCREEN_MEM 
	.by $10,$11,$12,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00 ; 1
	.by $13,$14,$15,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00 ; 2
	.by $16,$17,$18,$90,$91,$92,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00 ; 3
	.by $00,$00,$00,$93,$94,$95,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00 ; 4
	.by $00,$00,$00,$96,$97,$98,$00,$00,$50,$51,$52,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00 ; 5
	.by $00,$00,$00,$00,$00,$00,$00,$00,$53,$54,$55,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00 ; 6
	.by $00,$00,$00,$00,$00,$00,$00,$00,$56,$57,$58,$00,$00,$00,$00,$00,$00,$00,$50,$51,$52,$00,$00,$00 ; 7
	.by $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$10,$11,$12,$00,$53,$54,$55,$00,$00,$00 ; 8
	.by $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$13,$14,$15,$00,$56,$57,$58,$00,$00,$00 ; 9             
	.by $00,$00,$90,$91,$92,$00,$00,$00,$00,$00,$00,$00,$00,$00,$16,$17,$18,$00,$00,$00,$00,$00,$00,$00 ; 10
	.by $00,$00,$93,$94,$95,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00 ; 11
	.by $00,$00,$96,$97,$98,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00 ; 12
	.by $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00 ; 13
	.by $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$90,$91,$92,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00 ; 14
	.by $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$93,$94,$95,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00 ; 15

	.by $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$96,$97,$98,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00 ; 1
	.by $00,$00,$00,$00,$00,$00,$00,$00,$10,$11,$12,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00 ; 2
	.by $00,$00,$00,$00,$00,$00,$00,$00,$13,$14,$15,$00,$00,$00,$00,$00,$00,$00,$90,$91,$92,$00,$00,$00, ; 3
	.by $00,$00,$00,$00,$00,$00,$00,$00,$16,$17,$18,$00,$00,$00,$00,$00,$00,$00,$93,$94,$95,$00,$00,$00, ; 4
	.by $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$96,$97,$98,$00,$00,$00, ; 5
	.by $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00, ; 6
	.by $52,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$50,$51, ; 7
	.by $55,$00,$00,$00,$10,$11,$12,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$53,$54, ; 8
	.by $58,$00,$00,$00,$13,$14,$15,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$56,$57, ; 9             
	.by $00,$00,$00,$00,$16,$17,$18,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$90,$91,$92,$00,$00,$00,$00, ; 10
	.by $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$93,$94,$95,$00,$00,$00,$00, ; 11
	.by $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$96,$97,$98,$00,$10,$11,$12, ; 12
	.by $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$10,$11,$12,$00,$00,$00,$00,$00,$00,$13,$14,$15, ; 13
	.by $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$13,$14,$15,$00,$00,$00,$00,$00,$00,$16,$17,$18, ; 14
	.by $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$16,$17,$18,$00,$00,$00,$00,$00,$00,$00,$00,$00, ; 15
	
	.by $00,$00,$00,$00,$00,$00,$00,$10,$11,$12,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00 ; 1
	.by $00,$00,$00,$00,$00,$00,$00,$13,$14,$15,$00,$00,$00,$00,$00,$00,$00,$00,$50,$51,$52,$00,$00,$00 ; 2
	.by $00,$00,$00,$00,$00,$00,$00,$16,$17,$18,$00,$00,$00,$00,$00,$00,$00,$00,$53,$54,$55,$00,$00,$00 ; 3
	.by $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$56,$57,$58,$00,$00,$00 ; 4
	.by $51,$52,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$50 ; 5
	.by $54,$55,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$90,$91,$92,$00,$00,$00,$00,$00,$00,$00,$00,$53 ; 6
	.by $57,$58,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$93,$94,$95,$00,$00,$00,$00,$00,$00,$00,$00,$56 ; 7
	.by $90,$91,$92,$00,$00,$00,$00,$00,$00,$00,$00,$00,$96,$97,$98,$00,$00,$00,$00,$00,$00,$00,$00,$00 ; 8
	.by $93,$94,$95,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00 ; 9             
	.by $96,$97,$98,$10,$11,$12,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00 ; 10
	.by $00,$00,$00,$13,$14,$15,$00,$00,$00,$00,$00,$00,$00,$00,$00,$90,$91,$92,$00,$00,$00,$00,$00,$00 ; 11
	.by $00,$00,$00,$16,$17,$18,$00,$00,$00,$00,$00,$00,$00,$00,$00,$93,$94,$95,$00,$00,$00,$00,$00,$00 ; 12
	.by $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$96,$97,$98,$00,$00,$00,$00,$00,$00 ; 13
	.by $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$10,$11,$12,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00 ; 14
	.by $00,$00,$00,$50,$51,$52,$00,$00,$00,$00,$13,$14,$15,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00 ; 15
	
	.by $00,$00,$00,$53,$54,$55,$00,$00,$00,$00,$16,$17,$18,$00,$00,$00,$00,$00,$00,$00,$00,$10,$11,$12 ; 1
	.by $00,$00,$00,$56,$57,$58,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$13,$14,$15 ; 2
	.by $00,$00,$00,$00,$00,$00,$00,$90,$91,$92,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$16,$17,$18 ; 3
	.by $00,$00,$00,$00,$00,$00,$00,$93,$94,$95,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00 ; 4
	.by $00,$00,$00,$00,$00,$00,$00,$96,$97,$98,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00 ; 5
	.by $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00 ; 6
	.by $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$50,$51,$52,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00 ; 7
	.by $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$53,$54,$55,$00,$00,$00,$10,$11,$12,$00,$00,$00,$00 ; 8
	.by $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$56,$57,$58,$00,$00,$00,$13,$14,$15,$00,$00,$00,$00 ; 9             
	.by $00,$00,$00,$00,$00,$00,$90,$91,$92,$00,$00,$00,$00,$00,$00,$00,$00,$16,$17,$18,$00,$00,$00,$00 ; 10
	.by $00,$00,$00,$00,$00,$00,$93,$94,$95,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00 ; 11
	.by $00,$00,$00,$00,$00,$00,$96,$97,$98,$00,$d0,$d1,$d2,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00 ; 12
	.by $00,$10,$11,$12,$00,$00,$00,$00,$00,$00,$d3,$d4,$d5,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00 ; 13
	.by $00,$13,$14,$15,$00,$00,$00,$00,$00,$00,$d6,$d7,$d8,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00 ; 14
	.by $00,$16,$17,$18,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00 ; 15
	
	.by $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$10,$11,$12,$00,$00,$00,$00,$00,$00,$00,$00,$00 ; 1
	.by $50,$51,$52,$00,$00,$00,$00,$00,$00,$00,$00,$00,$13,$14,$15,$00,$00,$00,$00,$00,$00,$00,$00,$00 ; 2
	.by $53,$54,$55,$00,$00,$00,$00,$00,$00,$00,$00,$00,$16,$17,$18,$00,$00,$00,$00,$00,$00,$00,$00,$00 ; 3
	.by $56,$57,$58,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00 ; 4
	.by $00,$00,$00,$00,$00,$50,$51,$52,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00 ; 5
	.by $00,$00,$00,$00,$00,$53,$54,$55,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$90,$91,$92,$00,$00,$00 ; 6
	.by $00,$00,$00,$00,$00,$56,$57,$58,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$93,$94,$95,$00,$00,$00 ; 7
	.by $00,$00,$00,$00,$00,$00,$90,$91,$92,$00,$00,$00,$00,$00,$00,$00,$00,$00,$96,$97,$98,$00,$00,$00 ; 8
	.by $00,$00,$00,$00,$00,$00,$93,$94,$95,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00 ; 9             
	.by $00,$00,$00,$00,$00,$00,$96,$97,$98,$10,$11,$12,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00 ; 10
	.by $00,$00,$00,$00,$00,$00,$00,$00,$00,$13,$14,$15,$00,$00,$00,$00,$00,$00,$00,$00,$00,$90,$91,$92 ; 11
	.by $00,$00,$00,$00,$00,$00,$00,$00,$00,$16,$17,$18,$00,$00,$00,$00,$00,$00,$00,$00,$00,$93,$94,$95 ; 12
	.by $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$96,$97,$98 ; 13
	.by $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$10,$11,$12,$00,$00,$00,$00,$00 ; 14
	.by $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$13,$14,$15,$00,$00,$00,$00,$00 ; 15
	
	.by $00,$00,$00,$00,$00,$00,$00,$00,$00,$10,$11,$12,$00,$00,$00,$00,$16,$17,$18,$00,$00,$00,$00,$00 ; 1
	.by $00,$00,$00,$00,$00,$00,$00,$00,$00,$13,$14,$15,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00 ; 2
	.by $00,$00,$90,$91,$92,$00,$00,$00,$00,$16,$17,$18,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00 ; 3
	.by $00,$00,$93,$94,$95,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00 ; 4
	.by $00,$00,$96,$97,$98,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$50,$51,$52 ; 5
	.by $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$90,$91,$92,$00,$00,$00,$00,$00,$53,$54,$55 ; 6
	.by $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$93,$94,$95,$00,$00,$00,$00,$00,$56,$57,$58 ; 7
	.by $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$96,$97,$98,$00,$00,$00,$00,$00,$00,$00,$00 ; 8
	.by $00,$00,$00,$00,$50,$51,$52,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00 ; 9             
	.by $00,$00,$00,$00,$53,$54,$55,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00 ; 10
	.by $00,$00,$00,$00,$56,$57,$58,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00 ; 11
	.by $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$90,$91,$92,$00,$00,$00,$00,$00 ; 12
	.by $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$10,$11,$12,$00,$93,$94,$95,$00,$00,$00,$00,$00 ; 13
	.by $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$13,$14,$15,$00,$96,$97,$98,$00,$00,$00,$00,$00 ; 14
	.by $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$16,$17,$18,$00,$00,$00,$00,$00,$00,$00,$00,$00 ; 15

SCREEN_BASE ; yeah, redundant copy  of first screen
	.by $10,$11,$12,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00 ; 1
	.by $13,$14,$15,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00 ; 2
	.by $16,$17,$18,$90,$91,$92,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00 ; 3
	.by $00,$00,$00,$93,$94,$95,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00 ; 4
	.by $00,$00,$00,$96,$97,$98,$00,$00,$50,$51,$52,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00 ; 5
	.by $00,$00,$00,$00,$00,$00,$00,$00,$53,$54,$55,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00 ; 6
	.by $00,$00,$00,$00,$00,$00,$00,$00,$56,$57,$58,$00,$00,$00,$00,$00,$00,$00,$50,$51,$52,$00,$00,$00 ; 7
	.by $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$10,$11,$12,$00,$53,$54,$55,$00,$00,$00 ; 8
	.by $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$13,$14,$15,$00,$56,$57,$58,$00,$00,$00 ; 9             
	.by $00,$00,$90,$91,$92,$00,$00,$00,$00,$00,$00,$00,$00,$00,$16,$17,$18,$00,$00,$00,$00,$00,$00,$00 ; 10
	.by $00,$00,$93,$94,$95,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00 ; 11
	.by $00,$00,$96,$97,$98,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00 ; 12
	.by $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00 ; 13
	.by $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$90,$91,$92,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00 ; 14
	.by $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$93,$94,$95,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00 ; 15

; ==========================================================================
; CHARACTER SET

	.align 512 ; half-K alignment for character set.
	
SNOWFONT
	.by $00,$00,$00,$00,$00,$00,$00,$00    ; Make sure the blank space is blank

	; Define shapes at chars "0", "1", "2"... etc.

	ORG SNOWFONT+$80 
	.by $00,$00,$00,$14,$0C,$1C,$02,$01
	.by $00,$20,$A8,$71,$21,$A9,$72,$24
	.by $00,$00,$00,$40,$80,$C0,$00,$00

	.by $24,$12,$7F,$12,$24,$01,$02,$1C
	.by $A9,$72,$FF,$72,$A9,$24,$72,$A9
	.by $20,$40,$F0,$40,$20,$00,$00,$C0

	.by $0C,$14,$00,$00,$00,$00,$00,$00
	.by $21,$71,$A8,$20,$00,$00,$00,$00
	.by $80,$40,$00,$00,$00,$00,$00,$00

; ==========================================================================
; DISPLAY LIST

	.align 256

DISPLAY_LIST
	.byte DL_LMS|DL_VSCROLL|DL_TEXT_7 ; Line 1
LMS_ADDRESS
	.word SCREEN_BASE                          
	.byte DL_VSCROLL|DL_TEXT_7        ; Line 2
	.byte DL_VSCROLL|DL_TEXT_7        ; Line 3
	.byte DL_VSCROLL|DL_TEXT_7        ; Line 4
	.byte DL_VSCROLL|DL_TEXT_7        ; Line 5
	.byte DL_VSCROLL|DL_TEXT_7        ; Line 6
	.byte DL_VSCROLL|DL_TEXT_7        ; Line 7
	.byte DL_VSCROLL|DL_TEXT_7        ; Line 8
	.byte DL_VSCROLL|DL_TEXT_7        ; Line 9
	.byte DL_VSCROLL|DL_TEXT_7        ; Line 10
	.byte DL_VSCROLL|DL_TEXT_7        ; Line 11
	.byte DL_VSCROLL|DL_TEXT_7        ; Line 12
	.byte DL_VSCROLL|DL_TEXT_7        ; Line 13
	.byte DL_VSCROLL|DL_TEXT_7        ; Line 14
	.byte DL_TEXT_7                   ; Line 15

	.byte DL_JUMP_VB                  ; JuMP for Vertical Blank
	.word DISPLAY_LIST


; ==========================================================================

PROGRAM_START

	lda #0                 ; Turn off display
	sta SDMCTL

	lda #>SNOWFONT
	sta CHBAS              ; Set new  character set images.
	
	lda #15                ; init vscroll variable.  (bottom of row.)
	sta CurrentVScroll
	
	lda #$0E               ; White
	sta COLOR0
	lda #$7e               ; A light blue
	sta COLOR1
	lda #$8e               ; Another light blue
	sta COLOR2
	lda #$0e               ; Will be randomized so, doesn't matter.
	sta COLOR3
	lda #$70               ; Dark Blue sky.
	sta COLOR4
	
	lda #0                 ; Turn off display
	sta SDMCTL
	
	lda #<DISPLAY_LIST     ; Set new Display List
	sta SDLSTL
	lda #>DISPLAY_LIST     
	sta SDLSTL+1
	
	ldy #<MyImmediateVBI    ; Add the VBI to the system 
	ldx #>MyImmediateVBI
	lda #6                  ; 6 = Immediate VBI
	jsr SETVBV              ; Tell OS to set it

	lda #ENABLE_DL_DMA|PLAYFIELD_WIDTH_WIDE ; Enable running the Display List, overscan
	sta SDMCTL

; Nothing else to do.   VBI does all the scrolling, etc.  Just Loop forever.

DO_WHILE_MORE_ELECTRICITY
	jmp DO_WHILE_MORE_ELECTRICITY




; ==========================================================================
;  VBI Routine.
; --------------------------------------------------------------------------
; Kill Attract Mode.
; Randomize COLOR3.
; Decrement Vscroll. 
; When VScroll rolls over (negative) then reset to 15 and corse scroll.
; When coarse scroll reaches the first line of the buffer reset it to the 
; duplicate screen at the bottom of the buffer.  
; Rinse.
; Repeat. 
;
; CurrentVScroll is defined in page 0 earlier.
; ==========================================================================

MyImmediateVBI

	lda #0                  ; Turn Off attract mode
	sta ATRACT

	lda RANDOM              ; Randomise the bright magic snowflake.      
	ora #$0C
	sta COLOR3

	dec CurrentVscroll      ; Subtract a scroll line. (moves scrolling lines down.)
	bpl SkipReset 
	
	lda #15
	sta CurrentVscroll
	
	sec
	lda LMS_ADDRESS
	sbc #24
	sta LMS_ADDRESS
	bcs CheckForCoarseReset 
	dec LMS_ADDRESS+1
	
CheckForCoarseReset       ; If the display LMS has reached the top of the buffer,...?
	lda LMS_ADDRESS      
	cmp #<SCREEN_MEM
	bne SkipReset 
	lda LMS_ADDRESS+1
	cmp #>SCREEN_MEM
	bne SkipReset
	
	; End of scroll buffer,   reset display list to the starting position.
	
	lda #<SCREEN_BASE
	sta LMS_ADDRESS
	lda #>SCREEN_BASE
	sta LMS_ADDRESS+1
	
SkipReset	
	lda CurrentVScroll      ; Update Antic with fine scroll
	sta VSCROL
	
	jmp SYSVBV ; Continue OS Immediate VBI



; ==========================================================================

	ORG DOS_RUN_ADDR   ; Tell DOS where this program begins execution after it loads the file.
	.word PROGRAM_START


	END


