Texture2DArray<float4> theTextureArray : register(t0);
RWTexture2D<float4> outputTexture0 : register(u0);
RWTexture2D<float4> outputTexture1 : register(u1);
RWTexture2D<float4> outputTexture2 : register(u2);
RWTexture2D<float4> outputTexture3 : register(u3);
RWTexture2D<float4> outputTexture4 : register(u4);
RWTexture2D<float4> outputTexture5 : register(u5);
RWTexture2D<float4> outputTexture6 : register(u6);
RWTexture2D<float4> outputTexture7 : register(u7);
//sampler texSampler : register(s0);

cbuffer ParamConstants : register(b0)
{
    float outputIndexStart;
}
cbuffer ParamConstants : register(b1)
{
    float doWriteTexture0;
    float doWriteTexture1;
    float doWriteTexture2;
    float doWriteTexture3;
    float doWriteTexture4;
    float doWriteTexture5;
    float doWriteTexture6;
    float doWriteTexture7;
}

[numthreads(16,16,1)]
void main(uint3 input : SV_DispatchThreadID)
{
    int width, height, elements;
    theTextureArray.GetDimensions(width, height, elements);
    //theTextureArray.GetDimensions(width, height);
    float2 pixelSize = 1.0 / float2(width, height);
    
    //float2 texCoord = (float2) i.xy * pixelSize;
    uint offset = uint(outputIndexStart);
 
    if (doWriteTexture0 > .5)
        outputTexture0[input.xy] = theTextureArray.Load(uint4(input.xy, 0 + offset, 0)).xyzw;
    if (doWriteTexture1 > .5)
        outputTexture1[input.xy] = theTextureArray.Load(uint4(input.xy, 1 + offset, 0)).xyzw;
    if (doWriteTexture2 > .5)
        outputTexture2[input.xy] = theTextureArray.Load(uint4(input.xy, 2 + offset, 0)).xyzw;
    if (doWriteTexture3 > .5)
        outputTexture3[input.xy] = theTextureArray.Load(uint4(input.xy, 3 + offset, 0)).xyzw;
    if (doWriteTexture4 > .5)
        outputTexture4[input.xy] = theTextureArray.Load(uint4(input.xy, 4 + offset, 0)).xyzw;
    if (doWriteTexture5 > .5)
        outputTexture5[input.xy] = theTextureArray.Load(uint4(input.xy, 5 + offset, 0)).xyzw;
    if (doWriteTexture6 > .5)
        outputTexture6[input.xy] = theTextureArray.Load(uint4(input.xy, 6 + offset, 0)).xyzw;
    if (doWriteTexture7 > .5)
        outputTexture7[input.xy] = theTextureArray.Load(uint4(input.xy, 7 + offset, 0)).xyzw;
    //outputTexture0[i.xy] = float4(pos0+pos1+pos2+pos3+pos4+pos5+pos6+pos7, 1);
}

