Texture2D<float3> positionTexture : register(t0);
RWTexture2DArray<float4> theTextureArray : register(u0);
RWTexture2D<float4> texture1 : register(u1);
RWTexture2D<float4> texture2 : register(u2);
RWTexture2D<float4> texture3 : register(u3);
RWTexture2D<float4> texture4 : register(u4);
RWTexture2D<float4> texture5 : register(u5);
RWTexture2D<float4> texture6 : register(u6);
RWTexture2D<float4> texture7 : register(u7);

sampler texSampler : register(s0);

#define mod(x) (x-1.*floor(x))

cbuffer ParamConstants : register(b0)
{
    float i1;
    float iter;
    float iLevelOverwrite;
}
cbuffer ParamConstants : register(b1)
{
    float doWriteTexture0;
    float doWriteTexture1;
    float doWriteTexture2;
    float doWriteTexture3;
    float doWriteTexture4;
    float doWriteTexture5;
    float doWriteTexture6;
    
}
cbuffer ParamConstants : register(b2)
{
    float doWriteTexture7;
    float doWriteTexture8;
    float doWriteTexture9;
    float doWriteTexture10;
    float doWriteTexture11;
    float doWriteTexture12;
    float doWriteTexture13;
    float doWriteTexture14;
}
cbuffer ParamConstants : register(b3)
{
    float doWriteTexture15;
    float doWriteTexture16;
    float doWriteTexture17;
    float doWriteTexture18;
    float doWriteTexture19;
    float doWriteTexture20;
    float doWriteTexture21;
    float doWriteTexture22;
}

cbuffer ParamConstants : register(b4)
{
    float doWriteTexture23;
    float doWriteTexture24;
    float doWriteTexture25;
    float doWriteTexture26;
    float doWriteTexture27;
    float doWriteTexture28;
    float doWriteTexture29;
    float doWriteTexture30;
}


void writeToTexture(int textureId, uint2 coordinate, float3 _color)
{
    switch (textureId)
    {
        case 0:
            if (doWriteTexture0 < .5)
                return;
            texture1[coordinate] = float4(_color, 1.);
            break;
        case 1:
            if (doWriteTexture1 < .5)
                return;
            texture2[coordinate] = float4(_color, 1.);
            break;
        case 2:
            if (doWriteTexture2 < .5)
                return;
            texture3[coordinate] = float4(_color, 1.);
            break;
        case 3:
            if (doWriteTexture3 < .5)
                return;
            texture4[coordinate] = float4(_color, 1.);
            break;
        case 4:
            if (doWriteTexture4 < .5)
                return;
            texture5[coordinate] = float4(_color, 1.);
            break;
        case 5:
            if (doWriteTexture5 < .5)
                return;
            texture6[coordinate] = float4(_color, 1.);
            break;
        case 6:
            if (doWriteTexture6 < .5)
                return;
            texture7[coordinate] = float4(_color, 1.);
            break;
        case 7:
            if (doWriteTexture7 < .5)
                return;
            theTextureArray[uint3(coordinate, textureId - 7)] = float4(_color, 1.);
            break;
        case 8:
            if (doWriteTexture8 < .5)
                return;
            theTextureArray[uint3(coordinate, textureId - 7)] = float4(_color, 1.);
            break;
        case 9:
            if (doWriteTexture9 < .5)
                return;
            theTextureArray[uint3(coordinate, textureId - 7)] = float4(_color, 1.);
            break;
        case 10:
            if (doWriteTexture10 < .5)
                return;
            theTextureArray[uint3(coordinate, textureId - 7)] = float4(_color, 1.);
            break;
        case 11:
            if (doWriteTexture11 < .5)
                return;
            theTextureArray[uint3(coordinate, textureId - 7)] = float4(_color, 1.);
            break;
        case 12:
            if (doWriteTexture12 < .5)
                return;
            theTextureArray[uint3(coordinate, textureId - 7)] = float4(_color, 1.);
            break;
        case 13:
            if (doWriteTexture13 < .5)
                return;
            theTextureArray[uint3(coordinate, textureId - 7)] = float4(_color, 1.);
            break;
        case 14:
            if (doWriteTexture14 < .5)
                return;
            theTextureArray[uint3(coordinate, textureId - 7)] = float4(_color, 1.);
            break;
        case 15:
            if (doWriteTexture15 < .5)
                return;
            theTextureArray[uint3(coordinate, textureId - 7)] = float4(_color, 1.);
            break;
        case 16:
            if (doWriteTexture16 < .5)
                return;
            theTextureArray[uint3(coordinate, textureId - 7)] = float4(_color, 1.);
            break;
        case 17:
            if (doWriteTexture17 < .5)
                return;
            theTextureArray[uint3(coordinate, textureId - 7)] = float4(_color, 1.);
            break;
        case 18:
            if (doWriteTexture18 < .5)
                return;
            theTextureArray[uint3(coordinate, textureId - 7)] = float4(_color, 1.);
            break;
        case 19:
            if (doWriteTexture19 < .5)
                return;
            theTextureArray[uint3(coordinate, textureId - 7)] = float4(_color, 1.);
            break;
        case 20:
            if (doWriteTexture20 < .5)
                return;
            theTextureArray[uint3(coordinate, textureId - 7)] = float4(_color, 1.);
            break;
        case 21:
            if (doWriteTexture21 < .5)
                return;
            theTextureArray[uint3(coordinate, textureId - 7)] = float4(_color, 1.);
            break;
        case 22:
            if (doWriteTexture22 < .5)
                return;
            theTextureArray[uint3(coordinate, textureId - 7)] = float4(_color, 1.);
            break;

        case 23:
            if (doWriteTexture23 < .5)
                return;
            theTextureArray[uint3(coordinate, textureId - 7)] = float4(_color, 1.);
            break;

        case 24:
            if (doWriteTexture24 < .5)
                return;
            theTextureArray[uint3(coordinate, textureId - 7)] = float4(_color, 1.);
            break;

        case 25:
            if (doWriteTexture25 < .5)
                return;
            theTextureArray[uint3(coordinate, textureId - 7)] = float4(_color, 1.);
            break;

        case 26:
            if (doWriteTexture26 < .5)
                return;
            theTextureArray[uint3(coordinate, textureId - 7)] = float4(_color, 1.);
            break;

        case 27:
            if (doWriteTexture27 < .5)
                return;
            theTextureArray[uint3(coordinate, textureId - 7)] = float4(_color, 1.);
            break;

        case 28:
            if (doWriteTexture28 < .5)
                return;
            theTextureArray[uint3(coordinate, textureId - 7)] = float4(_color, 1.);
            break;

        case 29:
            if (doWriteTexture29 < .5)
                return;
            theTextureArray[uint3(coordinate, textureId - 7)] = float4(_color, 1.);
            break;

        case 30:
            if (doWriteTexture30 < .5)
                return;
            theTextureArray[uint3(coordinate, textureId - 7)] = float4(_color, 1.);
            break;


        
    }
    
    
    /*
    float4 color = float4(_color, 1.);
    if (textureId>6)
        theTextureArray[uint3(coordinate, textureId -7)] = color;
    else if (textureId == 0)
        texture1[coordinate] = color;
    else if (textureId == 1)
        texture2[coordinate] = color;
    else if (textureId == 2)
        texture3[coordinate] = color;
    else if (textureId == 3)
        texture4[coordinate] = color;
    else if (textureId == 4)
        texture5[coordinate] = color;
    else if (textureId == 5)
        texture6[coordinate] = color;
    else if (textureId == 6)
        texture7[coordinate] = color;
    */

}


[numthreads(16,16,1)]
void main(uint3 input : SV_DispatchThreadID)
{
    
    /*bool ifWriteTexture[24] =
    {
        doWriteTexture0 > .5,
        doWriteTexture1 > .5,
        doWriteTexture2 > .5,
        doWriteTexture3 > .5,
        doWriteTexture4 > .5,
        doWriteTexture5 > .5,
        doWriteTexture6 > .5,
        doWriteTexture7 > .5,
        doWriteTexture8 > .5,
        doWriteTexture9 > .5,
        doWriteTexture10 > .5,
        doWriteTexture11 > .5,
        doWriteTexture12 > .5,
        doWriteTexture13 > .5,
        doWriteTexture14 > .5,
        doWriteTexture15 > .5,
        doWriteTexture16 > .5,
        doWriteTexture17 > .5,
        doWriteTexture18 > .5,
        doWriteTexture19 > .5,
        doWriteTexture20 > .5,
        doWriteTexture21 > .5,
        doWriteTexture22 > .5,
        doWriteTexture23 > .5
    };*/
    
    int width, height;
    positionTexture.GetDimensions(width, height);
    float2 pixelSize = 1.0 / float2(width, height);
    
    float2 texCoord = (float2) input.xy * pixelSize;

    



    float3 p = positionTexture.SampleLevel(texSampler, texCoord, 0).xyz;

    //float xrand = frac(sin(dot(texCoord*p.x, float2(12.9898, 78.233))) * 43758.5453) * 2.0 - 1.0;
    //float yrand = frac(sin(dot(texCoord*p.y*2, float2(12.9898, 78.233))) * 43758.5453) * 2.0 - 1.0;
    //float zrand = frac(sin(dot(texCoord*p.z*3, float2(12.9898, 78.233))) * 43758.5453) * 2.0 - 1.0;
    //p+=float3(xrand,yrand, zrand);


    float levelOverwrite =     iLevelOverwrite;
    if (levelOverwrite > 1.)
    {
        levelOverwrite = floor(levelOverwrite);
        if (levelOverwrite == 3.)
            levelOverwrite = 4.;


    }
    
    int coloredKleeIterOffset = 1; // INPUT!!!!!!!!!!!!!!!
    float3 storeOrbIter0Level2;
    float storeKleeIter1Level2;
    float storeKleeIter0Level2;
    
    //int colorizeSpacesIterOffset = 18; // kein INPUT. ist jetzt maxIter
    float colorizeSpacesPow = 1.5; // INPUT!!!!!
    float3 colorizedSpaceiter0;
    float3 colorizedSpaceiter1;
    
    //glassBubbleP
    int glassBubbleIter = 1; //INPUT!!!!!!!!!!!!
    float3 glassBubbleP; //INPUT!!!!!!!!!!!!

    float scaleIn = 1.;
    float4 orb_min = float4(1., 1., 1., 1.);
    float4 orb_max = float4(0., 0., 0., 0.);
    //float4 orb_minReduced = orb_min;
    float4 orb = float4(1., 1., 1., 1.);
    float3 previousP = p;
    float3 previouspreviousP = p;
    float4 previousOrb = orb_min;
    float4 multiplyOrb = orb_min;
    float4 previouspreviousOrb = orb;
    float4 previousOrbMin = orb_min;
    float previousScaleIn = scaleIn;
    
    int level1Iterations = 0;
    int level2Iterations = iter;    
    int level4Iterations = 0;



    for (int l = 0; l < 3; l++)
    {
        
        float level = levelOverwrite;

        if (levelOverwrite == 0.)
        {
            if (l == 0)
                level = 1.;//max(0., min(1., iLevel1Multiplyer));
            else if (l == 1)
                level = 2.;
            else if (l == 2)
                level = 4.;
        }
                    
        int thisLevelIteraion = 6;
        if (l == 0)
            thisLevelIteraion = level1Iterations;
        else if (l == 1)
            thisLevelIteraion = level2Iterations;
        else if (l == 2)
            thisLevelIteraion = level4Iterations;
            
        //RESET
        if (thisLevelIteraion > 0)
        {
            p = positionTexture.SampleLevel(texSampler, texCoord, 0).xyz;
            scaleIn = 1.;
            orb_min = float4(1., 1., 1., 1.);
            orb = float4(1., 1., 1., 1.);
            previouspreviousOrb = float4(1., 1., 1., 1.);
            //orb_minReduced = orb_min;
            previouspreviousP = previousP;
            previousP = p;
            previousOrb = orb_min;
            multiplyOrb = orb_min;
            previousOrbMin = orb_min;
            previousScaleIn = scaleIn;
        }



        for (int i = 0; i < thisLevelIteraion; i++)
        {
            previouspreviousP = previousP;
            previouspreviousOrb = previousOrb;
            previousP = p;
            previousOrb = orb;
            previousScaleIn = scaleIn;
            previousOrbMin = orb_min;
            p = -1. + 2. * mod(.5 * p + .5);
            float r2 = dot(p, p);
            //orb = float4((p * p), r2);        
            orb = float4(abs(p), r2);        
            float k = level / r2;
            p *= k;
            scaleIn *= k;
            
            multiplyOrb *= orb;
            orb_min = min(orb_min, orb);
            orb_max = max(orb_max, orb);
            float iMul = float(thisLevelIteraion-i) / float(thisLevelIteraion);
            //iMul *= iMul;
            //orb_minReduced = min(orb_minReduced, (orb) / iMul);
            
            //orb = orb_min;


            if (l == 0)//level1
            {
                
            }
            else if (l == 1)//level2
            {
                // full colored klee
                if (i == 0 + coloredKleeIterOffset)
                {
                    storeOrbIter0Level2 = orb.xyz;//for both: full and edge colored
                    storeKleeIter0Level2 = abs(p.x * p.y * p.z * scaleIn * 0.01);//for edge colored
                }
                if (i == 1 + coloredKleeIterOffset)
                    storeKleeIter1Level2 = abs(p.x * p.y * p.z * scaleIn * 0.0001); //0.000104 = pow(.4, 10.)); // for full colored
                
                if (i == thisLevelIteraion - 2)// 0 + colorizeSpacesIterOffset)
                {
                    float3 colorgrading = float3(pow(1. - orb_min.x, 9.), pow(1. - orb_min.y, 9.), pow(1. - orb_min.z, 9.));
                    colorizedSpaceiter0 = colorgrading * sqrt(abs(50. / p.x / p.y / p.z / scaleIn) * .05);
                }
                if (i == thisLevelIteraion - 1)// 1 + colorizeSpacesIterOffset)
                {
                    float3 colorgrading = float3(pow(1. - orb_min.x, 9.), pow(1. - orb_min.y, 9.), pow(1. - orb_min.z, 9.));
                    colorizedSpaceiter1 = colorgrading * sqrt(abs(50. / p.x / p.y / p.z / scaleIn) * .05);
                }
                if (i == glassBubbleIter)
                {
                    glassBubbleP = p;
                }

            }
            else if (l == 2)//level4
            {
                
            
            }
        }
    
    }
    //p 
    writeToTexture(0, input.xy, p);
    
    //p abs
    writeToTexture(1, input.xy, abs(p));
    
    //1 - abs(ppp)
    writeToTexture(2, input.xy, (1. - abs(p * p * p)) );
    
    //orb
    writeToTexture(3, input.xy, orb.xyz);
    
    //orb_min
    writeToTexture(4, input.xy, orb_min.xyz );
    
    //pow large orb
    writeToTexture(5, input.xy, pow(orb.xyz, 10.));
    
    //pow large orb -1Iter
    writeToTexture(6, input.xy, pow(previousOrb.xyz, 7.));
    
    //pow small orb
    writeToTexture(7, input.xy, 1. - pow(orb.xyz, .1));
    
    //pow small orb_min
    writeToTexture(8, input.xy, 1. - pow(orb_min.xyz, .1));
    
        //pow small orb_min
    //writeToTexture(14, input.xy, 1. - pow(orb_minReduced.xyz, .1));
    
    
    writeToTexture(14, input.xy, previousOrb.xyz+0.+orb.xyz);
    writeToTexture(15, input.xy, previousOrb.xyz/orb.xyz);
    
    //tryout
     //writeToTexture(9, input.xy, (previouspreviousP*previousP)/(p*p));


     //writeToTexture(9, input.xy, length(previousP-p) );
     //writeToTexture(9, input.xy, length(p/previousP) );
     //writeToTexture(9, input.xy, 1-length((previousP)/(p)) ); //ELECTRON

     //float water = 1.-length(p/previouspreviousP);

     float3 px = p;
     px.x=1;

     float3 py = p;
     py.y=1;

     float3 pz = p;
     pz.z=1;

     float water = 1.-length(previouspreviousP/p);

     float waterx = 1.-length(previouspreviousP/px);
     float watery = 1.-length(previouspreviousP/py);
     float waterz = 1.-length(previouspreviousP/pz);

     float water3 = 1.-length(previouspreviousP.xyz/p.x/p.y)*3.;
     //float water2 = 1.-length(p/previousP);
     float water2 = 1.-length(previousP/p);
     //float ty = 1.-length(previousOrb/orb);
     float ty = 1.-length(orb/previousOrb);
writeToTexture(25, input.xy, float3(water,water2,ty) );//water3! //ELECTRON WATER
     //writeToTexture(9, input.xy, float(water) ); 
     //writeToTexture(9, input.xy, water*p*p ); little colored
     //writeToTexture(9, input.xy, water*p*p *previousP*previousP*previouspreviousP*previouspreviousP); 
     //writeToTexture(9, input.xy, water*orb*orb*1000); 



    writeToTexture(27, input.xy, water); //ELECTRON WATER
    writeToTexture(30, input.xy, float3(waterx,watery,waterz));

    //colored klee   TODO DAS HIER WIEDER AN DER STELLE EINKOMMENTIEREN
    writeToTexture(9, input.xy, storeOrbIter0Level2 * storeKleeIter1Level2);
    
    //edge colored klee   
    writeToTexture(10, input.xy, storeOrbIter0Level2 * storeKleeIter0Level2);
    
    //ppp * previousppp
    writeToTexture(11, input.xy, (1. - (p * p )) * (1. - (previousP * previousP )));
    

    //try
writeToTexture(23, input.xy, 1-(previousP*previousP)/(p*p));
writeToTexture(24, input.xy, 1-(previouspreviousP*previouspreviousP)/(p*p));

writeToTexture(26, input.xy, (previouspreviousP-previousP)/ (previousP-p));
writeToTexture(28, input.xy,  float(1-length(previousP-p)/length(previouspreviousP-previousP)));

//writeToTexture(29, input.xy, pow(orb-previouspreviousOrb,1));
writeToTexture(29, input.xy, pow(orb_max*orb_max-orb_min*orb_min,10));



    //glassbubble p
    //TODO DAS HIER WIDER AN DER STELLE EINKOMMENTIEREN
    writeToTexture(12, input.xy, glassBubbleP);
    
    //previous p
    writeToTexture(13, input.xy, previousP);
    
    
    //p multiplied small
    float3 outputP = p;//-previousP;
    //outputP = 1. - outputP;
    outputP *= outputP;
    //outputP = abs(outputP);
    writeToTexture(16, input.xy, outputP * .1);
    
    //2-color kleeblatt
    float kleeblattSoftness = 5.;//INPUT!!!!!!!!!!!!!!!!!!!!!
    float3 pMultiplied2 =  abs(float3(p.y * p.z, p.x * p.z, p.x * p.y));
    pMultiplied2 *= pMultiplied2;
    pMultiplied2 -= kleeblattSoftness;
    pMultiplied2 /= scaleIn;
    writeToTexture(17, input.xy, pMultiplied2);
    
    //colorfull bubles
    float bubbleSoftness = 10.;//INPUT!!!!!!!!!!!!!
    float3 pMultiplied1 = abs(float3(p.x, p.y, p.z)) ;
    pMultiplied1 *= bubbleSoftness;
    pMultiplied1 -= bubbleSoftness;
    //pMultiplied1 /= scaleIn;
    writeToTexture(18, input.xy, pMultiplied1);
    
    //colorized spaces. best in combination with 1/scaleIn
    writeToTexture(19, input.xy, pow( (colorizedSpaceiter0 + colorizedSpaceiter1), colorizeSpacesPow));
    
    
    //from here only monochrome textures:
    
    //orb multiplied alpha
    float orbPow = .2; //INPUT
    float orbValue = multiplyOrb.a; //    (orb.a) * (previousOrb.a);
    float orb_bubbles = pow(1. - orbValue, 1. / orbPow);
    
    //orb difference alpha
    float orbPow2 = .2; //INPUT
    float orbValue2 = 1. - ((orb.a) * (previousOrb.a));
    float orb_bubbles2 = 1. - pow(1. - orbValue2, 1. / orbPow2);
    
    //orb min alpha
    float orbPow3 = .2; //INPUT
    float orbValue3 = orb_min.a;
    float orb_bubbles3 = pow(1. - orbValue3, 1. / orbPow3);
    
    writeToTexture(20, input.xy, float3(orb_bubbles, orb_bubbles2, orb_bubbles3));

    
    //orb current alpha
    float orbPow4 = .2; //INPUT
    float orbValue4 = orb.a;
    float orb_bubbles4 = pow(1. - orbValue4, 1. / orbPow4);

    
    //full net at high iter
    float bloom = .55; //INPUT!!!!!!!!!!!!
    float bloomMultiplier = pow(bloom, 10.);
    float outputGray = abs(p.x * p.y * p.z * scaleIn * bloomMultiplier);
    
    //standard gray kleeblatt
    float pMultiplied = p.x * p.y * p.z;
    pMultiplied *= pMultiplied;
    pMultiplied += -50.;
    pMultiplied /= scaleIn;
    
    writeToTexture(21, input.xy, float3(orb_bubbles4, outputGray, pMultiplied));
    
    
    
    //scaleIn
    float outputScaleIn = (1. / scaleIn);
    
    //scaleIn + previous
    float scaleSpacesToNet = 1.;//INPUT!!!!!!!!!! -1 to 2
    float scaleSpacesToNetMultiplier = pow(10.,scaleSpacesToNet + 1);
    float outputScaleInWithPreviousIter = (2. / (scaleIn + previousScaleIn));
    outputScaleInWithPreviousIter *= scaleSpacesToNetMultiplier; //    outputScaleInWithPreviousIter;
    //outputScaleInWithPreviousIter = 1.- (pow((scaleIn - previousScaleIn) * (scaleIn - previousScaleIn), 1.1));
    
    //scaleInPow
    float scaleInPow = .2; //INPUT !!!!!!!!!!!!!!!!!!!!!
    float powValue = pow(.001, scaleInPow);
    float outputScaleInPow = (pow(1. - powValue, scaleIn));
    
    writeToTexture(22, input.xy, float3(outputScaleIn, outputScaleInWithPreviousIter, outputScaleInPow));


    {
    float4x4 mat = (float4x4)0.;
    float scale = scaleIn;
    p = abs(p);


    mat[0][0] = p.y/scale;
    mat[0][2] = .3*p.x*p.y*p.z/scale;
    mat[0][1] = 100./p.x/p.y/scale;
    mat[1][0] = orb_min.x;
    mat[1][1] = orb_min.y;
    mat[1][2] = orb_min.z;
    mat[1][3] = orb_min.a;

    float s = 10000.;

    {
    //gold_rings
    //linienstaerke multiplikator
    
    float lsm1 = 15;
    float lsm2 = 3.+0.4;
    if(i1 > 0){
    lsm1 = 2;
    lsm2 = 0.8;
    }

    float t = (mat[0][0]) *s/lsm1;// linienstaerke
    float3 color = lerp(   float3(.5,.5,.5),   float3(1.,.5,0.),  pow(1.-2.*mat[1][1],8.));
    //float bloom = (.05/t);//optional
    //float3 ret = sqrt(  color    *(bloom+exp(-t))*.4/mat[1][3]);
    float3 ret = sqrt(  color    *(exp(-t))*(lsm2)/mat[1][3]);
    writeToTexture(28, input.xy, ret);
    }

    
    {
    //gold_elec
    //linienstaerke multiplikator
    float lsm1 = 3.;

    float t2 = (mat[0][1]) *s/lsm1;// linienstaerke
    float3 color2 = lerp(   float3(.5,.5,.5),   float3(1.,.5,0.),  pow(1.-2.*mat[1][1],8.));
    float3 ret = sqrt(  color2    *(exp(-t2))*.4/mat[1][3]);
    writeToTexture(30, input.xy, ret);
    }

    }

}

