static const float PI = 3.14159265f;


cbuffer ParamConstants : register(b0)
{
    float iTime;
    float iZoom;
    float iSize;
    
    float iAngle;
    float iPosX;
    float iPosY;
    float iPosZ;
    
    float iMode;
    
    float iShiftScreenX;
    float iShiftScreenY;
}


struct vsOutput
{
    float4 position : SV_POSITION;
    float2 uv : TEXCOORD;
};

Texture2D<float4> Image : register(t0);
sampler texSampler : register(s0);

#define mod(x) (x-1.*floor(x))


float3 getCoordinate(vsOutput input)
{
    float perspectiveSelection = iMode;
    float scale = iSize;//* 0.001+1.1;
    float zoom = iZoom;
    float inv = 1.;
    float time = iTime; //    +0.001 * iMouse.x;
         
    

    float width, height;
    
    Image.GetDimensions(width, height);
    
    float2 pixelSize = 1.0 / float2(width, height);
    float2 texCoord = (float2) input.position.xy * pixelSize;
    float3 inputImage = Image.SampleLevel(texSampler, texCoord, 0).xyz;
    
    float3 shiftScreenCoordinate = float3(iShiftScreenX, iShiftScreenY,1.);
    float2 q = input.position.xy;
    float2 p = (2. * q - float2(float(width), float(height))) / float(height);


    //float noise2 = 0.006*frac(sin(dot(time*10000.*(texCoord.y*texCoord.x)*0.00002, float2(12.9898, 78.233))) * 43758.5453) * 2.0 - 1.0;
    //time += noise2;

    float3 ro = float3(0., 0., 0.);
    if (perspectiveSelection < .25)
    {
        ro = float3(time, time * 3. + sin(time), time * 5. + sin(time));
    }
    else if (perspectiveSelection < .5)
    {
        ro = float3(time, 3.*time , time * 5. );
    }
    else if (perspectiveSelection < .75)
    {
        ro = float3(time, time, 0.);
    }
    else
    {
        ro = float3(0, time, 0);
    }
    
    float3 cw = normalize(ro * inv);
    //float3 cu = cross(cw, float3(1., 0., 1.));
    float3 cu = normalize(cross(cw, float3(cos(iAngle), sin(iAngle), 0.)));
    float3 cv = (cross(cu, cw));
        
    //float3 rd = normalize(p.x * cu + p.y * cv + zoom * cw); //zoom
    float3 rd = normalize((p.x * cu + p.y * cv + zoom * cw * (shiftScreenCoordinate + 1.))); //zoom   or with distort:  * (1-inputImage.x*.6));
    
    //ro *= 1.+0.01*sin(10*length(texCoord.xy));
    //ro *= 1.+0.01*cos(10*length(texCoord.xy));

    float3 ret = ro + float3(iPosY, iPosZ, iPosX) + rd * scale;
    //float3 ret = 0*ro+  float3(0, 0, 0) +rd * scale;// + float3(iPosY, iPosZ, iPosX) + rd * scale;
    //ret = ro+rd*scale;

    //float r = time;
    //ret = r*float3(sin(texCoord.x)*cos(texCoord.y),sin(texCoord.x)*sin(texCoord.y),cos(texCoord.x));

    float t = iTime*10000;

    //DETAIL DIFFUSION
    //float xrand = frac(sin(dot(t*texCoord*ret.x, float2(12.9898, 78.233))) * 43758.5453) * 2.0 - 1.0;
    //float yrand = frac(sin(dot(t*texCoord*ret.y*2, float2(12.9898, 78.233))) * 43758.5453) * 2.0 - 1.0;
    //float zrand = frac(sin(dot(t*texCoord*ret.z*3, float2(12.9898, 78.233))) * 43758.5453) * 2.0 - 1.0;
    //ret+=float3(xrand,yrand, zrand)*0.00001;
    
    //FARFIELD
    //float noise = 00.6*frac(sin(dot(t*(texCoord*ret.y*texCoord*ret.x+texCoord*ret.z)*0.00002, float2(12.9898, 78.233))) * 43758.5453) * 2.0 - 1.0;
    //float noise2 = 0.6*frac(sin(dot(t*(texCoord*ret.y*texCoord*ret.x+texCoord*ret.z)*0.00002, float2(12.9898, 78.233))) * 43758.5453) * 2.0 - 1.0;
    //ret+=float3(noise,noise2,noise);
    
    //NEARFIELD
    //float noise = 00.06*frac(sin(dot(t*(texCoord*ret.y*texCoord*ret.x+texCoord*ret.z)*0.00002, float2(12.9898, 78.233))) * 43758.5453) * 2.0 - 1.0;
    //float noise2 = 0.06*frac(sin(dot(t*(texCoord*ret.y*texCoord*ret.x+texCoord*ret.z)*0.00002, float2(12.9898, 78.233))) * 43758.5453) * 2.0 - 1.0;
    //ret+=float3(noise,noise2,noise);

    return ret;
}



float4 psMain(vsOutput input) : SV_Target
{
    
    return float4(getCoordinate(input), 1.);
    
}