in vec2 uv;
in vec2 uvn;

out vec4 C;

uniform uint* text_buff;
uniform int font_tex;
uniform float t_since_displayed;

uniform int text_w = 100;
uniform int text_h = 10;

vec3 draw_glyph(vec2 uv){
    vec2 umul = uv*vec2(text_w,text_h);

    int ch_idx = int(umul.x) + int(text_h - umul.y)*int(text_w);




    ch_idx = (ch_idx + 100*100) % (100*100);

    uint ch = text_buff[ch_idx];
    if(ch == 0){
        return vec3(0);
    }

//    ch = ch_idx;

    ivec2 glyph_sz = ivec2(8,16);

    ivec2 ifruv = ivec2(mod(umul, 1.0)*vec2(glyph_sz));

    uint col = ch%16;
    uint row = ch/16;

    ivec2 tex_res = ivec2(textureSize(textures[font_tex],0));

    ivec2 glyph_offs = (ivec2(0) - ivec2(0,glyph_sz.y) + ivec2(glyph_sz.x * col, -glyph_sz.y * row)) % ivec2(tex_res);

    ivec2 samp_iuv = glyph_offs + ifruv;

    vec3 colour = texelFetch(textures[font_tex],samp_iuv,0).rrr;
    return colour;
}

#define DOS_GUY 2u
#define A_UPPER_CASE 65u
#define A_LOWER_CASE 97u


void main(){
//    C = tex_tonemapped(textures[taa_tex], uvn);
//    C = vec4();
    C.rgb = draw_glyph(uvn);

    if(C.r > 0.01){
        splat_ss(gl_FragCoord.xy, vec3(5));
    }

    C.a = 1.0*C.r;
    C.a = 0.0001;

}
