in vec2 uv;

out vec4 C;

uniform float u_t;
uniform int tex_drawing;

#include scene_jyrevis25/common.glsl

vec3 amiga(vec2 p) {
    vec2 q = p+vec2(0.7,0.0);
    float rad = 0.7;
    float z = sqrt(pow(rad, 2.0)-pow(length(q), 2.0));
    vec3 r = vec3(q,z);
    r.zx *= rot(u_t*.75);
    r.yz *= rot(u_t*.66);
    vec2 s = vec2(atan(r.z,r.x),r.y*2.0)/TAU;
    float checker = step(0.5, mod(floor(s*12.0).x+floor(s*12.0).y+0.1,2.0));
    return mix(c_pink, mix(c_beige, c_red, checker), step(length(q),rad));
}

float drawing(vec2 p, vec2 bound) {
    if (abs(p.x)>bound.x/2.0 || abs(p.y)>bound.y/2.0) return 0.0;
    return texture(textures[tex_drawing], p).r;
}

void main() {
    vec2 UV=vec2(uv.x*R.x/R.y, uv.y);

    vec3 col = amiga(UV);

    col = mix(col, c_blue, drawing((UV+1.75)*0.3, vec2(3.0)));

    C = vec4(col, 1.0);
}
