in vec2 uv;

out vec4 C;

uniform float u_t;
uniform int tex_typo;

#include scene_jyrevis25/common.glsl

bool getText(vec2 p, vec2 ind, vec2 range) {
    if (abs(p.x)>range.x/2.0 || abs(p.y)>range.y/2.0) return false;
    return 0.5<texture(textures[tex_typo], (p+ind+4.0+vec2(0.5)*(fract(range/2.0)*2.0))/8.0).r;
}
vec2 fracture(vec2 p, float amount) {
    float part = 4.0;

    vec2 silly = sin(cos((p.yx)*2.8)*2.12)*0.5+0.5;
    silly *= 0.8;
    mat2 wobb = mat2(1.0+silly.x,0.0,0.0,1.0+silly.y);
    mat2 unwobb = mat2(1.0/(1.0+silly.x),0.0,0.0,1.0/(1.0+silly.y));
    vec2 q = (p*wobb-0.5/part)*wobb;

    vec2 i_p = floor(q*part),
         f_p = fract(q*part);
    seed = (uint)(i_p.y-i_p.x*35.124+5832.0);
    vec2 off = floor(0.5*(1.0+6.0/length(i_p+0.5))/(hash_v2()*2.0-1.0));
    return ((mix(i_p,off,amount)/part+f_p/part)*unwobb+0.5/part)*unwobb;
}

float box(vec2 p){vec2 q=abs(p); return max(q.x,q.y);}
float coin(vec2 p) {
    vec2 q = abs(p)-1.0;
    return 
        step(length(p),1.0)*
        step(length(q),1.0)
    ;
}

void main() {
    vec2 UV=vec2(uv.x*R.x/R.y, uv.y);

    vec3 col = c_blue;

    vec2 wave = UV+vec2(0.0,sin(UV.x*4.0+u_t)*sin(UV.x*7.0+u_t)*0.02);
    wave = fracture(wave, smoothstep(sin(u_t*1.5)*1.5+0.8, sin(u_t*1.5)*1.5+1.0, wave.x)*0.05);

    col = mix(col, c_beige, step(box(wave*vec2(0.325,0.7)), 0.5));
    col = mix(col, c_blue, step(length(abs(wave)-vec2(1.55,0.7)), 0.25));
    col = mix(col, c_blue, 
        step(box(fract(wave*vec2(1.0,6.0)+vec2(0.0,0.5))*2.0-1.0), 0.3)*
        step(box((wave+vec2(1.5,0))*vec2(1.0,1.2)), 0.5)
    );

    vec2 chain = vec2(wave.x*6.0+3.0,fract(wave.y*3.0-u_t*8.0)*2.0-1.0);
    col = mix(col, c_blue, coin(chain));

    if (getText(wave*2.0+vec2(2,0), vec2(0), vec2(1,3))) {
        col = c_blue;
    }

    if (getText(wave*5.0-vec2(2.5,0), vec2(0), vec2(7,5))) {
        col = c_blue;
    }

    C = vec4(col, 1.0);
}
