
struct Vert{
    vec4 pos;
    vec4 color;
    vec2 uv;
    int trans_id;
};

uniform Vert* vert_buff;
uniform mat4* transforms_buff;

out vec3 out_pos;
out vec4 color;

void main() {
    out_pos = vert_buff[gl_VertexID].pos.xyz;
    color = vert_buff[gl_VertexID].color;
    mat4 transform = mat4(1);
    if(vert_buff[gl_VertexID].trans_id >= 0){
        transform = transforms_buff[vert_buff[gl_VertexID].trans_id];
    }
    gl_Position = P * V * transform * vec4(out_pos,1.0);
}
