in vec2 uv;
in vec2 uvn;

out vec4 C;

uniform int input_tex;
uniform int preblur_tex;
uniform vec2 output_res;
uniform vec2 res_sc;

vec3 get(vec2 u){
    vec3 C = vec3(0);
    
    bool circ = true;
    bool rgb_split = false;

    vec2 input_res = vec2(textureSize(textures[input_tex],0).xy);
//    vec2 res_sc = vec2(340.,240);
//    vec2 res_sc = vec2(660.,120);

    vec2 q = u;
    q *= res_sc;

    vec2 stretch = vec2(1);

    if(circ){
        float _aspect = (input_res.x/input_res.y) / (res_sc.x/res_sc.y);
        if(_aspect > 1.0){
            //            qn.x *= 1.5;
            stretch.x *= _aspect;
        } else {
            stretch.y /= _aspect;
        }
    }
    
    float circ_sz = 0.3;

    
//    float fw = fwidth(q.y*stretch.y);
    float fw = (1./input_res.y)/stretch.y;

    ivec2 int_qid = ivec2(q);
    vec2 flq = floor(q);
    float tt = T;
//    tt = 0.4;

    vec3 input_col = texture(textures[input_tex], (flq + 0.5)/res_sc).rgb;
    float thr = 0.001;
    float rng = 0.9;
    
    float amt = smoothstep(thr,thr + rng, luma(input_col));
//    amt = 1-amt;
//    if(luma(input_col) > 0.1){
//        flq.x += 10*sin(flq.y*(3+sin(tt)) + tt*100)*10*pow(abs(sin(tt + q.y*0.01)),4.);
        flq.x += 
            13*sin(flq.y*(3+sin(tt)) + tt*100)
//            *10*pow(abs(sin(tt + q.y*0.01)),4.)
            * amt
        ;
//    }
    
    hash_f();
    vec2 qid = (flq + 0.5)/res_sc;
    vec2 qn = q;
    qn = fract(qn);
    qn -= 0.5;
    qn *= stretch;



    input_col = texture(textures[input_tex], qid).rgb;
//    input_col = clamp(input_col,0,1000);
    vec3 input_col_preblurred = texture(textures[preblur_tex], qid).rgb;
    if(luma(input_col) < luma(input_col_preblurred)){
        input_col += input_col_preblurred;
    }
//    input_col = input_col_preblurred;
    
    input_col *= 2.4;
    
    if(rgb_split){
        vec3 acc = vec3(0);
        acc[int_qid.x%3] = 1.6;
        input_col *= acc;
    }
    //    circ
    float shape;
    if(circ){
//        if(rgb_split){
//            input_col *= 4.;
//        }
        input_col *= 2.0;
        float lum = luma(input_col);
        lum = min(lum*1.0,1.0);
        float sd = length(qn);
        shape = smoothstep(fw*0.5+ pow(1.01-lum,0.2),-fw*0.5,sd - circ_sz);
    } else {
//        float sd = length(qn);
        float lum = luma(input_col);
        lum = min(lum*0.5,0.5);
        float sd = abs(qn.y);
        shape = smoothstep(fw + pow(1-lum,2.),0,sd - 0.02 - lum*0.45);
        shape *= smoothstep(fw,0.,abs(qn.x) - 0.3);
    }
    C.rgb += shape * input_col;
    
    
    return C;
}

void main() {
    vec2 u = uvn;

    C.rgb -= C.rgb;
    float ss_steps = 1.;
    
    float W = 0.;
    for(float x = -ss_steps; x <= ss_steps; x++){
        for(float y = -ss_steps; y <= ss_steps; y++){
            vec2 offs = vec2(x,y)/ss_steps/output_res*0.9;
            C.rgb += get(u+offs);
            W += 1.0;
        }
    }
    C.rgb /= W;

    
//    q = fract
    
//    C.rgb = fract(q.xyx);
//    ivec2 iR = ivec2(output_res);
//    C = vec4(1,0,0,1);
//    C = texture(textures[input_tex], u);
    C.w = 1.0;
}
