
in vec2 uv;
in vec2 uvn;

out vec4 C;

uniform int input_tex;
uniform int output_tex;
//uniform vec2* blur_coeffs;
uniform int pass;
uniform int width;
uniform float tolerance;
//uniform int iters;

void main() {
    vec2 u = uvn;
    
    vec3 col = vec3(0);
    
    vec2 size = textureSize(textures[output_tex], 0);
    vec3 center = texture(textures[input_tex],u).rgb;
    
    float center_luma = luma(center);
    
    vec2 blurDirection = vec2(0);
    blurDirection[pass] = 1;
    float W = 0.;
//    
    for (int x = -width; x <= width; x++) {
        vec2 offset = x * blurDirection  / size;
        vec3 samp = texture(textures[input_tex], u + offset).rgb;
        float w = 1.-smoothstep(0.,tolerance,abs(luma(samp) - center_luma));
        col += samp * w;
        W += w;
    }
    
    if(W > 0.0001){
        col /= W;
    } else {
        col = center;
    }
    col = max(col,0.);
    C.rgb = col;
    C.w = 1.0;
}
