﻿#pragma once

// #include "Engine.h"
#include "AudioEffect.h"
#include "AudioFile.h"
#include "SoundGroup.h"
#include "ma_reverb_node/ma_reverb_node.h"




class AudioMixer {
	public:
		ma_engine engine;
		ma_device device;
		ma_resource_manager resource_manager;
		// ReverbEffect* reverb_effect;
		ma_node_graph* node_graph;

		float master_vol = 1.0;

		AudioFile* audio_file;
		ReverbEffect* reverb_effect;

		// SoundGroup default_sound_group = SoundGroup(nullptr);
		SoundGroup default_sound_group;
		SoundGroup sfx_sound_group;

		AudioMixer();


		void update_player(
			glm::vec3 pos,
			glm::vec3 dir,
			glm::vec3 vel
		);

		void set_master_volume(float vol);

};
