﻿#pragma once
#include <game/Text.h>

struct RectDescr;

class KeyState {
	public:
		bool down = false;
		bool just_pressed = false;
		bool just_unpressed = false;
		float t_since_press = 0.0f;
		KeyState() = default;
		KeyState(bool pressed, bool just_pressed, bool just_unpressed);
};

enum class Key: WPARAM {
	Num0    = 48,
	Num1    = 49,
	Num2    = 50,
	Num3    = 51,
	Num4    = 52,
	Num5    = 53,
	Num6    = 54,
	Num7    = 55,
	Num8    = 56,
	Num9    = 57,
	A       = 65,
	B       = 66,
	C       = 67,
	D       = 68,
	E       = 69,
	F       = 70,
	G       = 71,
	H       = 72,
	I       = 73,
	J       = 74,
	K       = 75,
	L       = 76,
	M       = 77,
	N       = 78,
	O       = 79,
	P       = 80,
	Q       = 81,
	R       = 82,
	S       = 83,
	T       = 84,
	U       = 85,
	V       = 86,
	W       = 87,
	X       = 88,
	Y       = 89,
	Z       = 90,
	Left    = VK_LEFT,
	Right   = VK_RIGHT,
	Up      = VK_UP,
	Down    = VK_DOWN,
	LCtrl   = VK_CONTROL,
	LAlt   = VK_MENU,
	LShift  = VK_SHIFT,
	Esc     = VK_ESCAPE,
	Space   = VK_SPACE,
	Tab     = VK_TAB,
	F1     = VK_F1,
	F2     = VK_F2,
	F3     = VK_F3,
	F4     = VK_F4,
	F5     = VK_F5,
	F6     = VK_F6,
	F7     = VK_F7,
	F8     = VK_F8,
	F9     = VK_F9,
	Squirly = 192,
};

class IO {
private:
		POINT newMouse;
public:
	std::map<WPARAM, KeyState> key_map;

	float mouse_x = 0;
	float mouse_y = 0;
	float delta_mouse_x = 0;
	float delta_mouse_y = 0;
	bool mouse_lmb_down = false;
	bool mouse_lmb_just_pressed = false;
	bool mouse_lmb_just_unpressed = false;

	bool mouse_rmb_down = false;
	bool mouse_rmb_just_pressed = false;
	bool mouse_rmb_just_unpressed = false;

	bool mouse_mmb_down = false;
	bool mouse_mmb_just_pressed = false;
	bool mouse_mmb_just_unpressed = false;
	

	int mouse_x_before_drag_start = 0;
	int mousy_y_before_drag_start = 0;

	glm::vec2 mouse_ndc = glm::vec2(0.0f,0.0f);
	glm::vec2 mouse_uv = glm::vec2(0.0f,0.0f);
	

	bool mouse_grabbed = false;
	bool imgui_wants_mouse = false;

	bool window_focused = false;
	
	glm::vec2 delta_mouse_ndc = glm::vec2(0.0f,0.0f);

	IO () {

	}

	KeyState get_key(WPARAM key);
	KeyState get_key(Key key);

	bool handle_input(UINT msg, WPARAM wParam);
	void end_frame();
	void handle_mouse();
	void set_mouse_grabbed(bool state);
	void do_ui_elem(UIElem* elem, bool clickable);

	bool mouse_over(RectangDescr rect);

};
