#include "data\\shaders\\common.h"
#include "data\\shaders\\input_formats.h"
#include "data\\shaders\\lights.h"

StructuredBuffer<CullableLight> g_cullable_lights : register(t1, space1);

VertexOutPIOut main(VertexPNTIn vin, uint instance_id : SV_InstanceID)
{
	VertexOutPIOut vout;
  
  CullableLight light = g_cullable_lights[g_num_point_lights + instance_id];
  if (light.scatt_density > 0.0f && light.scatt_multiplier > 0.0f)
  {
    float3 forward = normalize(-light.direction);
    float3 right = normalize(cross(forward, float3(0,1,0)));
    float3 up = normalize(cross(forward,right));
    
    float s = tan(acos(light.cosangle));
    float3 scale = float3(s,1.0f,s) * light.radius;
    float3 p = vin.pos * scale;
    float3 pos = light.position + (p.y*forward + p.x*up + p.z*right);
  
    float4 clip_pos = mul(float4(pos, 1.0f), g_proj);
    vout.pos_h = clip_pos;
    vout.instance_id = instance_id;
    vout.clip_pos = clip_pos;
    vout.pos_v = pos;
  }
  else
  {
    float4 clip_pos = float4(0,0,0,-10.0f)/0.0f;
    vout.pos_h = clip_pos;
    vout.instance_id = 0;
    vout.clip_pos = clip_pos;
    vout.pos_v = clip_pos.xyz;
  }
 

  return vout;
}