#include "data\\shaders\\common.h"
#include "data\\shaders\\input_formats.h"
#include "data\\shaders\\lights.h"
#include "data\\shaders\\pcss.h"

StructuredBuffer<CullableLight> g_cullable_lights : register(t1, space1);
StructuredBuffer<float4x4> g_shadows_view_proj : register(t4, space1);

Texture2D g_depth : register(t0);
Texture2D g_shadow_maps[10] : register(t0, space2);

SamplerState g_sam_linear : register(s3);
SamplerComparisonState g_sam_shadow : register(s6);

float4 main(VertexOutPIOut pin) : SV_Target
{
  CullableLight light = g_cullable_lights[g_num_point_lights + pin.instance_id];
  float2 half_size = g_screen_size / 2.0f;

  float2 uv = pin.clip_pos.xy / pin.clip_pos.w * float2(0.5f, -0.5f) + 0.5f;
  float depth = g_depth.Sample(g_sam_linear, uv).x;
  float3 pos = ScreenToView( float4(uv, depth, 1.0f)).xyz;
  float3 pos_v = pin.pos_v;

  float d = pos.z;
  if (pos_v.z < pos.z)
    pos = pos_v;

  float3 eye_pos = float3(0,0,0);
  float dist = length(pos);
  float3 view_dir = normalize(pos);

  float3 start = eye_pos;
  float3 end = pos;

  uint sample_count = 16;
  float step_size = distance(start,end) / sample_count;
  float3 step = view_dir * step_size;

  float density = light.scatt_density;
  float multiplier = light.scatt_multiplier;
  float falloff = light.scatt_falloff;

  pos = start + step * Dither(uv*half_size);
  float3 accumulation = 0.0f.xxx;
  for (uint i = 0; i < sample_count; ++i)
  {
    float dist_to_light = distance(pos, light.position);
    float dist_to_eye = distance(pos, eye_pos);

    float d = falloff * saturate(dist_to_light / light.radius);
    float l = falloff * saturate(dist_to_eye / light.radius);

    float d2pi4 = abs(d * d * 4.0f * PI) + 0.00001f;

    float3 lin = exp(-d * density) * multiplier / ( d2pi4 );
    float3 li = lin * density * 0.01f;

    float3 attenuation = spot_light_falloff(light, pos);
    attenuation *= li * exp(-l * density) * step_size;

    if (light.shadow_map_index >= 0)
    {
      int shadow_index = light.shadow_map_index;
      float3 pos_w = mul(float4(pos,1.0f), g_inv_view).xyz;
      float3 l_uv = WorldToScreen(pos_w, g_shadows_view_proj[shadow_index]);
      l_uv.z -= 0.00006f;
      float shadow_factor = g_shadow_maps[shadow_index].SampleCmpLevelZero(g_sam_shadow, l_uv.xy, l_uv.z);
      attenuation *= shadow_factor;
    }

    accumulation += attenuation;
    pos += step;
  }

  accumulation /= sample_count;
  return float4(max(accumulation,0.0f.xxx) * light.color * light.intensity,d);
}
