#include "data\\shaders\\input_formats.h"

Texture2D g_atlas : register(t0, space3);
SamplerState g_sam_linear : register(s2);

PixelCNMOut main(VertexTextOut pin)
{
  PixelCNMOut pout;
  float3 n = normalize(pin.normal);

  float3 color = pin.color.xyz;
  float a = g_atlas.Sample(g_sam_linear, pin.uv).x;
   if (a < 0.4754)
    discard;

  pout.color = float4(color, 1.0f);
  pout.normal = float4(n, pin.pos_v.z);
  pout.material = float4(1.0,0.0,0.0,0.0);
  return pout;
}
